/*
 * arch/arm64/include/asm/debug-pl011.S
 *
 * Debugging macro include header
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm/include/debug/vexpress.S
 */
/* arch/arm/mach-realview/include/mach/debug-macro.S
 *
 * Debugging macro include header
 *
 *  Copyright (C) 1994-1999 Russell King
 *  Moved from linux/arch/arm/kernel/debug.S by Ben Dooks
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/amba/serial.h>

		.macro	senduart, rd, rx
		str	\rd, [\rx, #UART01x_DR]
		.endm

		.macro	waituart, rd, rx
1001:
		ldr	\rd, [\rx, #UART01x_FR]
		tst	\rd, #UART01x_FR_TXFF
		bne	1001b
		.endm

		.macro	busyuart, rd, rx
1001:
		ldr	\rd, [\rx, #UART01x_FR]
		tst	\rd, #UART01x_FR_BUSY
		bne	1001b
		.endm

		.macro	uart_setup
		ldr	x5, =UARTPA
		str	wzr, [x5, #UART011_IMSC] // Interrupt mask
		mov	w6, #__UART_BAUD_F
		str	w6, [x5, #UART011_FBRD]
		mov	w6, #__UART_BAUD_I
		str	w6, [x5, #UART011_IBRD]
		mov	w6, #__UART_8N1_NO_FIFO
		str	w6, [x5, #UART011_LCRH]
		str	wzr, [x5, #UART01x_ECR] // clear error
		mov	w6, #UART011_CR_TXE
		orr	w6, w6, #UART01x_CR_UARTEN
		str	w6, [x5, #UART011_CR] // TX enable
		.endm
