/*
 * head_init.h
 *
 * CXD90XXX head_init macros
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __CXD90XXX_MACH_HEAD_INIT_H
#define __CXD90XXX_MACH_HEAD_INIT_H

/*---------------- FDT --------------------*/
/* FDT at (_text - FDT_OFFSET) (Except QEMU) */
#define FDT_OFFSET	0x10000

/*------------ GenericTimer ---------------*/
#ifdef CONFIG_ARCH_CXD90XXX_FPGA
#define GT_FRQ		3000000	 /* 3MHz */
#else
#define GT_FRQ		16000000 /* 16MHz */
#endif

/*----------- GIC address map -------------*/
//#define CXD90XXX_GICV2
#if defined(CONFIG_ARCH_CXD90XXX_FVP)
#ifdef CXD90XXX_GICV2
# define GICD_BASE	0x2c001000
# define GICC_BASE	0x2c002000
#else
# define GICD_BASE	0x2f000000
# define GICR_BASE	0x2f100000
# define GICC_BASE	0x2c000000
#endif
#elif defined(CONFIG_ARCH_CXD90XXX_QEMU)
# define GICD_BASE	0x08000000
# define GICR_BASE	0x080a0000
# define GICC_BASE	0x08010000
#else
# define GICD_BASE	0xf4400000
# ifdef CONFIG_ARCH_CXD90XXX_FPGA
#  define GICR_BASE	0xf4440000 /* when number of CPUs is 1 or 2 */
# else
#  define GICR_BASE	0xf4480000 /* when number of CPUs is 3 or 4 */
# endif /* CONFIG_ARCH_CXD90XXX_FPGA */
#endif
#define GICD_NSPI	480

	.macro	bootcpu_enter
	mrs	x24, CurrentEL			// x24: saved CurrentEL
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
	bl	cxd90xxx_init
#endif
	.endm

	.macro	bootcpu_leave
#if defined(CONFIG_EJ_SIMPLE_LOADER)
	sev
#else
	adr	x0, __secondary_vector
	ldr	x1, [x0]
	add	x0, x0, x1			// x0=pa(ej_secondary_entry)
	bl	cxd90xxx_smp_init
#endif
#if !defined(CONFIG_ARCH_CXD90XXX_QEMU)
	adr	x0, __text_vector
	ldr	x1, [x0]
	add	x0, x0, x1			// x0=pa(_text)
	sub	x0, x0, #FDT_OFFSET		// x0=FDT
	mov	x1, xzr
	mov	x2, xzr
	mov	x3, xzr
#endif /* !CONFIG_ARCH_CXD90XXX_QEMU */
	.endm

	.macro	resume_bootcpu_leave
#if defined(CONFIG_EJ_SIMPLE_LOADER)
	sev
#else
	adr	x0, __secondary_resume_vector
	ldr	x1, [x0]
	add	x0, x0, x1			// x0=pa(resume_secondary_entry)
	bl	cxd90xxx_smp_init
#endif
	.endm

	.macro	secondary_enter
	mrs	x24, CurrentEL			// x24: saved CurrentEL
#if defined(CONFIG_EJ_SIMPLE_LOADER)
	wfe
#endif
	.endm

	.macro	secondary_leave
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
	bl	cxd90xxx_secondary_init
#endif
	.endm

#define CPUECTLR_EL1	S3_1_C15_C2_1
#define CPUECTLR_SMPEN	0x40

	.macro  smp_enable
#if !defined(CONFIG_ARCH_CXD90XXX_FVP)
	mrs	x10, CPUECTLR_EL1
	orr	x10, x10, #CPUECTLR_SMPEN
	msr	CPUECTLR_EL1, x10
#endif /* !CONFIG_ARCH_CXD90XXX_FVP */
	.endm

#endif /* __CXD90XXX_MACH_HEAD_INIT_H */
