/*
 * drivers/soc/cxd/include/uart.h
 *
 * UART header for ARCH_CXD90XXX
 *
 * Copyright 2023 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __ARCH_CXD90XXX_UART_H__
#define __ARCH_CXD90XXX_UART_H__

#include <mach/uart_addr.h>

/* for 8250 */
#define UART_DLF	0x30
#define UART_SHIFT	2

/* for PL011 */
#define __UART_8N1_NO_FIFO 0x70

#ifdef CONFIG_CXD90XXX_UART_IO_INIT
#include <mach/platform.h>
#include <mach/regs-gpio.h>
#include <mach/regs-clk.h>
#include <mach/regs-srst.h>

/* UART0 pin */
#define GPIO_UART0	7
#define GPIO_UART0_RXD	0
#define GPIO_UART0_TXD	1
#define GPIO_UART0_FUNC1  ((0x1<<(GPIO_UART0_RXD*2))|(0x1<<(GPIO_UART0_TXD*2)))
#endif /* CONFIG_CXD90XXX_UART_IO_INIT */

/* UART baudrate clock 96MHz, 460800baud */
#define __UART_CLK	96000000
#define __UART_BAUD	460800
#define __UART_BAUD_I	(__UART_CLK/(__UART_BAUD*16))
#define __UART_BAUD_I_L	(__UART_BAUD_I & 0xff)
#define __UART_BAUD_I_H	((__UART_BAUD_I >> 8) & 0xff)
#define __UART_BAUD_F	(((__UART_CLK*64)+(__UART_BAUD*8))/(__UART_BAUD*16)-(__UART_BAUD_I*64))

#ifdef __ASSEMBLY__
		.macro	addruart, rp, rv
		ldr	\rp, =UARTPA
#ifdef CONFIG_DEBUG_EARLY
		ldr	\rv, =UARTVA_EARLY
#else
		ldr	\rv, =UARTVA_IOMAP
#endif /* CONFIG_DEBUG_EARLY */
		.endm

		.macro	uart_portconfig
#ifdef CONFIG_CXD90XXX_UART_IO_INIT
		/* start GPIO_C */
		/* CLK */
		ldr	x5, =CXD90XXX_CLKEN(CLKEN_GPIO_C)
		mov	w6, #1U << CLKEN_GPIO_C_PCLK
		str	w6, [x5, #CLK_SET]
		/* RESET */
		ldr	x5, =CXD90XXX_RESET(SRST_GPIO_C_GRP)
		mov	w6, #1U << SRST_GPIO_C_BIT
		str	w6, [x5, #SRST_SET]
		/* wait 1CLK (dummy read) */
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		// FUNC1 UART0 TXD,RXD
		ldr	x5, =CXD90XXX_GPIO_C(GPIO_UART0)
		mov	w6, #GPIO_UART0_FUNC1
		str	w6, [x5, #GPIO_PORT+GPIO_SET]
#endif /* CONFIG_CXD90XXX_UART_IO_INIT */
		.endm
#endif /* __ASSEMBLY__ */
#endif /* !__ARCH_CXD90XXX_UART_H__ */
