/*
 * mach-cxd90xxx/resume.S
 *
 * resume entry for cxd90XXX
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm/mach-sa1100/sleep.S
 */
/*
 * SA11x0 Assembler Sleep/WakeUp Management Routines
 *
 * Copyright (c) 2001 Cliff Brake <cbrake@accelent.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 *
 * History:
 *
 * 2001-02-06: Cliff Brake         Initial code
 *
 * 2001-08-29:	Nicolas Pitre	Simplified.
 *
 * 2002-05-27:	Nicolas Pitre	Revisited, more cleanup and simplification.
 *				Storage is on the stack now.
 */

#include <linux/linkage.h>
#include <asm/assembler.h>
#ifdef CONFIG_SNSC_SSBOOT
#include <linux/ssboot_stat.h>
#endif
#include "include/head_init.h"

/*
 * cxd_resume()
 *
 * entry point from bootloader into kernel during resume
 *
 */
/*
 * Execute only CPU#0.
 * Because, other CPUs are offline before sleep.
 * CPU should be EL3.
 */
#ifdef CONFIG_SNSC_SSBOOT
	.pushsection ".data", "aw"
	.globl  cxd_ssboot_stat
	.align	2
cxd_ssboot_stat:	.long	SSBOOT_CREATE_MINSSBI
	.popsection
#endif /* CONFIG_SNSC_SSBOOT */

	.pushsection ".idmap.text", "ax"
#ifdef CONFIG_SNSC_SSBOOT
SYM_FUNC_START(cxd_resume_profile)
	mov	w1, #SSBOOT_PROFILE
	b	1f
SYM_FUNC_START(cxd_resume_optimize)
	mov	w1, #SSBOOT_CREATE_OPTSSBI
	b	1f
SYM_FUNC_START(cxd_resume_ssboot_pre)
	mov	w1, #SSBOOT_SSBOOT_PRE
	b	1f
SYM_FUNC_START(cxd_resume_ssboot)
	mov	w1, #SSBOOT_SSBOOT
1:
	// SMP common entry
	mrs	x10, mpidr_el1
	ands	x10, x10, #MPIDR_LEVEL_MASK	// CPU#
	b.ne	resume_secondary_entry

	bootcpu_enter	// x10 corrupted

	adr_l	x0, cxd_ssboot_stat
	str	w1, [x0]
	b	1f
#endif /* CONFIG_SNSC_SSBOOT */
SYM_FUNC_START(cxd_resume)
	// SMP common entry
	mrs	x10, mpidr_el1
	ands	x10, x10, #MPIDR_LEVEL_MASK	// CPU#
	b.ne	resume_secondary_entry

	bootcpu_enter

1:
#if defined(CONFIG_DEBUG_EARLY) || defined(CONFIG_CXD90XXX_UART_IO_INIT)
	bl	uart_init
#endif
#if !defined(CONFIG_ARCH_CXD90XXX_QEMU) && !defined(CONFIG_ARCH_CXD90XXX_FVP)
	bl	timer_init
#endif
#ifdef CONFIG_DEBUG_EARLY
	mov	w0, #'R'
	bl	printch			// x1-x3 corrupted
#endif /* CONFIG_DEBUG_EARLY */

	bl	v8_boot

	resume_bootcpu_leave

	b	cpu_resume
SYM_FUNC_END(cxd_resume)

	.align 3
SYM_DATA_START(__secondary_resume_vector)
	.quad   resume_secondary_entry - .
SYM_DATA_END(__secondary_resume_vector)

SYM_FUNC_START(resume_secondary_entry)
	secondary_enter

	mrs	x10, CurrentEL
	cmp	x10, CurrentEL_EL3
	b.ne	1f
	bl	gic_cpu_init
	bl	el3_setup
1:
	smp_enable

	secondary_leave

	mov	x0, xzr
	mov	x1, xzr
	mov	x2, xzr
	mov	x3, xzr

	/* spin-table */
spin:
	wfe
	adr_l	x10, mach_cpu_release_addr
	ldr	x10, [x10]
	cbz	x10, spin
	b	secondary_holding_pen		// x10
SYM_FUNC_END(resume_secondary_entry)
	.ltorg
	.popsection
