/*
 * mach-cxd90xxx/sleep.S
 *
 * pm callback for cxd90xxx
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm/mach-sa1100/sleep.S
 */
/*
 * SA11x0 Assembler Sleep/WakeUp Management Routines
 *
 * Copyright (c) 2001 Cliff Brake <cbrake@accelent.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 *
 * History:
 *
 * 2001-02-06: Cliff Brake         Initial code
 *
 * 2001-08-29:	Nicolas Pitre	Simplified.
 *
 * 2002-05-27:	Nicolas Pitre	Revisited, more cleanup and simplification.
 *				Storage is on the stack now.
 */

#include <linux/linkage.h>
#include <linux/arm_sp805.h>
#include <asm/assembler.h>
#include <asm/memory.h>
#include <mach/pm.h>
#include <mach/pm_macro.S>
#include <mach/platform.h>

/*
 * void cxd_suspend(void)
 *
 * Enter sleep state
 * This code is copyied to eSRAM.
 */
	.data
SYM_FUNC_START(cxd_suspend)
	mov	sp, x0
	/* disable MMU, the mapping is flat so */
	mrs	x0, sctlr_el1
	bic	x0, x0, #SCTLR_ELx_M
	bic	x0, x0, #SCTLR_ELx_C
	msr	sctlr_el1, x0
	isb
	tlbi	vmalle1
	dsb	nsh

/*--------------------- Memory power down ----------------------*/
	pm_memory
/*--------------------------------------------------------------*/

	ldr	w0, cxd_sus_end_msg
	cmp	w0, #0
	beq	1f

	mov	w0, #'E'
	bl	__printch
	mov	w0, #'\n'
	bl	__printch
1:

/*--------------------- D-D Conv. control ----------------------*/
dd_off:
	/* stop WDT */
	ldr	x0, =CXD90XXX_WDT
	mov	w1, #LOCK_UNLOCK
	str	w1, [x0, #WDT_LOCK]
	str	wzr, [x0, #WDT_CTRL]
	/* XPWR_OFF */
	ldr	x0, cxd_xpower_off_addr
	cmp	x0, #-1		// not defined ?
	beq	1f
	ldr	w1, cxd_xpower_off_bitmask
	str	w1, [x0]			// assert
1:

	/* wait for power off */
1:
	wfi
	b	1b
/*--------------------------------------------------------------*/
	pm_functions

	.align	3
	.globl	cxd_xpower_off_addr
cxd_xpower_off_addr:
	.quad	0xffffffffffffffff

	.globl	cxd_xpower_off_bitmask
cxd_xpower_off_bitmask:
	.long	0xffffffff

	.globl	cxd_ddr_ctrl
cxd_ddr_ctrl:
	.long	0

	.globl	cxd_sus_end_msg
cxd_sus_end_msg:
	.long	0

__udelay:
	/*
	* input: x0 (usec)
	* destroy: x0, x1, x2
	*/
	lsl	x0, x0, #1		/* usecs_to_cycles */
	isb
	mrs	x2, cntvct_el0
1:
	isb
	mrs	x1, cntvct_el0
	sub	x1, x1, x2
	cmp	x1, x0
	bcc	1b
	ret

/*------------------ for debug -------------------*/
#include <mach/debug-macro.S>
__printhex16:
	mov	x1, #16
	b	__printhex
__printhex8:
	mov	x1, #8
	b	__printhex
__printhex4:
	mov	x1, #4
	b	__printhex
__printhex2:
	mov	x1, #2
__printhex:
	adr	x2, hexbuf
	add	x3, x2, x1
	strb	wzr, [x3]
1:
	and	x1, x0, #0xf
	mov	x0, x0, lsr #4
	add	x1, x1, #'0'
	cmp	x1, #'9'
	ble	2f
	add	x1, x1, #'a'-'0'- 10
2:
	strb	w1, [x3, #-1]!
	cmp	x3, x2
	bne	1b
	mov	x0, x2
	b	__printascii

__printascii:
	addruart x2, x3
	mov	x3, x2
	b	2f
1:
	waituart x2, x3
	senduart w1, x3
	busyuart x2, x3
	cmp	w1, #'\n'
	beq	3f
2:
	cbz	x0, 4f
	ldrb	w1, [x0], #1
	cbnz	w1, 1b
4:
	ret
3:
	mov	w1, #'\r'
	b	1b

__printch:
	addruart x2, x3
	mov	x3, x2
	mov	w1, w0
	mov	x0, #0
	b	1b

hexbuf:		.space 32
	.ltorg
	.globl	cxd_suspend2
cxd_suspend2:
SYM_FUNC_END(cxd_suspend)
