/*
 * mach-cxd90xxx/reset.c
 *
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/udif/types.h>
#include <linux/udif/macros.h>
#include <linux/udif/device.h>
#include <linux/udif/spinlock.h>
#include <linux/udif/mutex.h>
#include <mach/platform.h>
#include <mach/regs-srst.h>

UDIF_ERR __udif_devio_hrst(UDIF_RESET *reset, UDIF_U8 assert)
{
	UDIF_PARM_CHK(!reset, "invalid reset", UDIF_ERR_PAR);
	if (!reset->hrst.assert || !reset->hrst.negate) {
		UDIF_PERR("invalid hrst: IGNORED.\n");
		return UDIF_ERR_OK;
	}
	if (assert >= 2) {
		return UDIF_ERR_PAR;
	}

#if !defined(CONFIG_ARCH_CXD90XXX_QEMU) && !defined(CONFIG_ARCH_CXD90XXX_FVP)
	if (assert) {
		udif_iowrite32(1U<<reset->hrst.shift, reset->hrst.assert);
	}
	else {
		udif_iowrite32(1U<<reset->hrst.shift, reset->hrst.negate);
	}
	ndelay(reset->hrst.delay);
#endif
	return UDIF_ERR_OK;
}


UDIF_ERR __udif_devio_devrst(UDIF_RESET *reset, UDIF_U8 assert)
{
	UDIF_PARM_CHK(!reset, "invalid reset", UDIF_ERR_PAR);
	if (!reset->drst.assert || !reset->drst.negate) {
		UDIF_PERR("invalid devrst: IGNORED.\n");
		return UDIF_ERR_OK;
	}
	if (assert >= 2) {
		return UDIF_ERR_PAR;
	}

#if !defined(CONFIG_ARCH_CXD90XXX_QEMU) && !defined(CONFIG_ARCH_CXD90XXX_FVP)
	if (assert) {
		udif_iowrite32(1U<<reset->drst.shift, reset->drst.assert);
	}
	else {
		udif_iowrite32(1U<<reset->drst.shift, reset->drst.negate);
	}
	ndelay(reset->drst.delay);
#endif
	return UDIF_ERR_OK;
}

EXPORT_SYMBOL(__udif_devio_hrst);
EXPORT_SYMBOL(__udif_devio_devrst);
