/*
 * drivers/soc/cxd/udif/timestamp.c
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/module.h>
#include <clocksource/arm_arch_timer.h>
#include <mach/udif/timer.h>
#ifdef CONFIG_SNSC_BOOT_TIME
#include <linux/snsc_boot_time.h>
#endif /* CONFIG_SNSC_BOOT_TIME */

#ifdef CONFIG_ARCH_CXD90XXX_FPGA
# define TIMER_MHZ  3
#endif

unsigned long long notrace
udif_cycles_to_usecs(unsigned long long cnt)
{
#ifdef CONFIG_ARCH_CXD90XXX_FPGA
	do_div(cnt, TIMER_MHZ);
	return cnt;
#else /* Freq. == 16MHz */
	return (cnt + 8) >> 4;
#endif /* CONFIG_ARCH_CXD90XXX_FPGA */
}
EXPORT_SYMBOL(udif_cycles_to_usecs);

unsigned long long notrace
udif_usecs_to_cycles(unsigned long long usec)
{
#ifdef CONFIG_ARCH_CXD90XXX_FPGA
	return (usec * TIMER_MHZ);
#else /* Freq. == 16MHz */
	return usec << 4;
#endif /* CONFIG_ARCH_CXD90XXX_FPGA */
}
EXPORT_SYMBOL(udif_usecs_to_cycles);

unsigned long long notrace
udif_cycles_to_nsecs(unsigned long long cnt)
{
#ifdef CONFIG_ARCH_CXD90XXX_FPGA
	cnt *= 1000;
	do_div(cnt, TIMER_MHZ);
	return cnt;
#else /* Freq. == 16MHz */
	return ((cnt * 125) + 1) >> 1;
#endif /* CONFIG_ARCH_CXD90XXX_FPGA */
}
EXPORT_SYMBOL(udif_cycles_to_nsecs);

#ifdef CONFIG_SNSC_BOOT_TIME
unsigned long long notrace
boot_time_cpu_clock(int cpu)
{
	return udif_cycles_to_nsecs(udif_read_freerun());
}
#endif /* CONFIG_SNSC_BOOT_TIME */

#ifdef CONFIG_PRINTK
unsigned long long notrace
printk_ts(void)
{
	return udif_cycles_to_nsecs(udif_read_freerun());
}
#endif /* CONFIG_PRINTK */

#ifdef CONFIG_THREAD_MONITOR
unsigned long long notrace tmonitor_ts(void)
{
	return udif_read_freerun();
}

unsigned long long notrace
tmonitor_ts_to_us(unsigned long long ts)
{
	return udif_cycles_to_usecs(ts);
}
#endif /* CONFIG_THREAD_MONITOR */
