// SPDX-License-Identifier: GPL-2.0
/*
 * usb2_smmu.h
 *
 * Copyright 2022 Sony Corporation, SOCIONEXT INC.
 *
 */
#include "../dwc2/core.h"
//#define D_SMMU_DEBUG_LOG_EN

int32_t dwc2_smmu_init(struct dwc2_hsotg *hsotg, void *smmu_hndl);
void dwc2_smmu_exit(struct dwc2_hsotg *hsotg);

#ifdef CONFIG_USB2_SMMU_LIB
bool dwc2_smmu_is_range_of_alloc(dma_addr_t addr);
int dwc2_smmu_alloc(struct dwc2_hsotg *hsotg, uint64_t addr64, uint32_t size, uint32_t *p_addr32);
void dwc2_smmu_free(struct dwc2_hsotg *hsotg, uint64_t addr64);
int64_t dwc2_get_free_addr(struct dwc2_hsotg *hsotg, uint64_t addr);
#endif
// for debug
#ifdef D_SMMU_DEBUG_LOG_EN
void dwc2_smmu_debug_print_info(struct dwc2_hsotg *hsotg);
void dwc2_smmu_debug_print_TLB_status(struct dwc2_hsotg *hsotg);
#endif
