#include <linux/io.h>
#include <linux/delay.h>
#include "../cxd/sdebug.h"
#include <linux/usb/f_usb/usb_otg_control.h>

// SCU(MISC)
#define MISC_ADDR		0xFC5E0000
#define MISC_SIZE		0x3000

// USB20_PHY_CTRL0
#define D_OFS_USB20_PHY_CTRL0	0x2140
#define         D_BIT_USB20_COMPDISTUNE0	12
#define         D_MASK_USB20_COMPDISTUNE0	0x7000
#define		D_BIT_USB20_SQRXTUNE0		16
#define		D_MASK_USB20_SQRXTUNE0		0x70000
// USB20_PHY_CTRL1
#define D_OFS_USB20_PHY_CTRL1	0x2150
#define         D_BIT_USB20_TXVREFTUNE0		8
#define         D_MASK_USB20_TXVREFTUNE0	0xF00
#define		D_BIT_USB20_TXRISETUNE0		12
#define		D_MASK_USB20_TXRISETUNE0	0x3000
#define         D_BIT_USB20_TXPREEMPAMPTUNE0	20
#define         D_MASK_USB20_TXPREEMPAMPTUNE0	0x300000

static inline u32 dwc2_cxd_readl(void __iomem *base, u32 offset)
{
	return readl(base + offset);
}
 
static inline void dwc2_cxd_writel(void __iomem *base, u32 offset, u32 value)
{
	writel_relaxed(value, base + offset);
}

void __iomem *dwc2_cxd_phy_base = NULL;
void dwc2_cxd_set_phy_reg(void)
{
	uint32_t reg_val;
	s_print(S_DEBUG_INGO, "%s", __func__);
	reg_val = dwc2_cxd_readl(dwc2_cxd_phy_base, D_OFS_USB20_PHY_CTRL0);
	s_print(S_DEBUG_INFO, "USB20_PHY_CTRL0: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_USB20_COMPDISTUNE0;
	reg_val |= (backup_phy_param.phy_data[P1_PARAM_COMPDISTUNE0] << D_BIT_USB20_COMPDISTUNE0);
	reg_val &= ~D_MASK_USB20_SQRXTUNE0;
	reg_val |= (backup_phy_param.phy_data[P1_PARAM_SQRXTUNE0] << D_BIT_USB20_SQRXTUNE0);
	s_print(S_DEBUG_INFO, "USB20_PHY_CTRL0 = 0x%.8x", reg_val);
	dwc2_cxd_writel(dwc2_cxd_phy_base, D_OFS_USB20_PHY_CTRL0, reg_val);

	reg_val = dwc2_cxd_readl(dwc2_cxd_phy_base, D_OFS_USB20_PHY_CTRL1);
	s_print(S_DEBUG_INFO, "USB20_PHY_CTRL1: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_USB20_TXVREFTUNE0;
	reg_val |= (backup_phy_param.phy_data[P1_PARAM_TXVREFTUNE0] << D_BIT_USB20_TXVREFTUNE0);
	reg_val &= ~D_MASK_USB20_TXPREEMPAMPTUNE0;
	reg_val |= (backup_phy_param.phy_data[P1_PARAM_TXPREEMPAMPTUNE0] << D_BIT_USB20_TXPREEMPAMPTUNE0);
	reg_val &= ~D_MASK_USB20_TXRISETUNE0;
	reg_val |= (backup_phy_param.phy_data[P1_PARAM_TXRISETUNE0] << D_BIT_USB20_TXRISETUNE0);
	s_print(S_DEBUG_INFO, "USB20_PHY_CTRL1 = 0x%.8x", reg_val);
	dwc2_cxd_writel(dwc2_cxd_phy_base, D_OFS_USB20_PHY_CTRL1, reg_val);
}

volatile static int dwc2_cxd_drd_lock;
void dwc2_cxd_wait_drd_done(void)
{
	int wait_limit;
	wait_limit = 500;

	s_print(S_DEBUG_INFO, "%s: pid=%d start\n", __func__, current->pid);
	while(dwc2_cxd_drd_lock != 0) {
		printk("%s wait\n", __func__);
		msleep(10);
		wait_limit--;
		if(wait_limit <=0) {
			printk("%s time out to wait for drd\n", __func__);
			break;
		}
	}
	s_print(S_DEBUG_INFO, "%s: end\n", __func__);
}
EXPORT_SYMBOL(dwc2_cxd_wait_drd_done);

void dwc2_cxd_set_drd_done(void)
{
	s_print(S_DEBUG_INFO, "%s pid=%d\n", __func__, current->pid);
	dwc2_cxd_drd_lock = 0;
}
EXPORT_SYMBOL(dwc2_cxd_set_drd_done);

void dwc2_cxd_start_drd(void)
{
	int wait_limit;
	wait_limit = 500;

	s_print(S_DEBUG_INFO, "%s start\n", __func__);
	while(dwc2_cxd_drd_lock != 0) {
		printk("%s wait\n", __func__);
		msleep(10);
		wait_limit--;
		if(wait_limit <=0) {
			printk("%s time out to wait for start\n", __func__);
			break;
		}
	}
	dwc2_cxd_drd_lock= 1;
	s_print(S_DEBUG_INFO, "%s end\n", __func__);
}

void dwc2_cxd_init_suppl(void)
{
	s_print(S_DEBUG_INFO, "%s", __func__);

	dwc2_cxd_phy_base = ioremap(MISC_ADDR, MISC_SIZE);
	if(dwc2_cxd_phy_base == NULL)
		printk("no mem: phy");

	dwc2_cxd_set_drd_done();
}

