/* Copyright 2022 Sony Corporation, SOCIONEXT INC. */

#ifndef __DWC2_CXD_H__
#define __DWC2_CXD_H__

//#define TESTCODE_USB_DWC2_TIME_DRD
//#define TESTCODE_USB_DWC2_LOCK

#define D_PSAVE_ON				1
#define D_PSAVE_OFF				0

#define D_WA_DDR_COHERENCY_ISSUE

/**
 * struct cxd_dwc2 - dwc2-cxd driver private structure
 * @dev:		device pointer
 * @glue_base:		ioaddr for the glue registers
 */
struct cxd_dwc2 {
	struct device *dev;
	void __iomem *glue_base;
	void __iomem *ho_glue_base;
	void __iomem *anpd_glue_base;
#if defined(CONFIG_ARCH_CXD90XXX_FPGA) || defined(D_WA_DDR_COHERENCY_ISSUE)
	void __iomem *axi2avb_glue_base;
#endif
	void __iomem *host_glue_base;
#ifdef CONFIG_ARCH_CXD90XXX_FPGA
	void __iomem *axi2avb_ho_glue_base;
#endif
#if defined(CONFIG_USB2_SMMU_LIB)
	void __iomem *smmu_base;
#endif
#if defined(D_WA_DDR_COHERENCY_ISSUE)
	void __iomem *axi2avb_ohci_glue_base;
#endif
	struct clk		*hclk;/* E_SCU_CLK_USB20_HCLK */
	struct clk		*ohci_clk48;/* E_SCU_CLK_USB20_OHCI_CLK48 */
	struct clk		*ho_hclk;/* E_SCU_CLK_USB20_HO_HCLK */
	struct clk		*mmu_cclk;/*E_SCU_CLK_USB20_MMU_CCLK*/
	struct clk		*mmu_tbu_bclk0;/*E_SCU_CLK_USB20_MMU_TBU_BCLK0*/
	struct reset_control	*por_rst;/* E_SCU_RST_USB20_POR */
	struct reset_control	*prst_n;/* E_SCU_RST_USB20_PRST_N */
	struct reset_control	*hresetn;/* E_SCU_RST_USB20_HRESETN */
	struct reset_control	*ho_hresetn;/*E_SCU_RST_USB20_HO_HRESETN*/
	struct reset_control	*mmu_cresetn;/*E_SCU_RST_USB20_MMU_CRESETN*/
	struct reset_control	*mmu_tbu_bresetn0;/*E_SCU_RST_USB20_MMU_TBU_BRESETN0*/
	struct platform_device	*child_pdev;
	struct device *kdev;
#if defined(CONFIG_USB2_SMMU_LIB)
	uint64_t smmu_ram;
	uint32_t smmu_len;
#endif
	uint32_t psave_on;
};
inline void dwc2_cxd_misc_clear(struct cxd_dwc2 *dwc);
int dwc2_cxd_dev_clk_start(struct cxd_dwc2 *dwc);
void dwc2_cxd_dev_clk_stop(struct cxd_dwc2 *dwc);
int dwc2_cxd_dev_prepare_start(struct cxd_dwc2 *dwc);
void dwc2_cxd_dev_prepare_stop(struct cxd_dwc2 *dwc);
int dwc2_cxd_host_prepare_start(struct cxd_dwc2 *dwc);
void dwc2_cxd_host_prepare_stop(struct cxd_dwc2 *dwc);

#include "dwc2-cxd-suppl.h"
#endif /* __DWC2_CXD_H__ */
