#include <linux/io.h>
#include <linux/delay.h>
#include "../cxd/sdebug.h"
#include <linux/usb/f_usb/usb_otg_control.h>

// MEDIA/USB32/PHY
#define USB32PHY_ADDR	0xF0D00000
#define USB32PHY_SIZE	0x80000

// MEDIA/USB32/LINK
#define USB32LINK_ADDR	0xF0D80000
#define USB32LINK_SIZE	0x10000

// Global Register
#define D_OFS_GUSB2PHYCFG			0xC200
#define		D_BIT_GUSB2PHYCFG_PHYSOFTRST	0x80000000
#define D_OFS_GUSB3PIPECTL			0xC2C0
#define		D_BIT_GUSB3PIPECTL_PHYSOFTRST	0x80000000

// Additional Register
#define D_OFS_U2PCNTL2				0xE204
#define 	D_BIT_COMPDISTUNE0		29
#define		D_MASK_COMPDISTUNE0		0xE0000000
#define		D_BIT_SQRXTUNE0			26
#define		D_MASK_SQRXTUNE0		0x1C000000
#define 	D_BIT_TXVREFTUNE0		8
#define		D_MASK_TXVREFTUNE0		0xF00
#define		D_BIT_TXPREEMPAMPTUNE0		2
#define		D_MASK_TXPREEMPAMPTUNE0		0xC

// CR Parallel Register
#define D_OFS_TXRX			0x40088
#define 	D_BIT_TX_VBOOST_LVL_EN	7
#define		D_MASK_TX_VBOOST_LVL_EN	0x80	// bit 7
#define		D_BIT_TX_VBOOST_LVL	4
#define		D_MASK_TX_VBOOST_LVL	0x70	// bit 6:4

#define D_OFS_TXEQ_MAIN_LANE0		0x44008
#define D_OFS_TXEQ_MAIN_LANE1		0x44408
#define		D_BIT_MAIN_OVRD_EN	10
#define 	D_MASK_MAIN_OVRD_EN	0x400	// bit 10
#define		D_BIT_TX_MAIN_CURSOR	4
#define		D_MASK_TX_MAIN_CURSOR	0x3F0	// bit 9:4

#define D_OFS_TXEQ_PRE_POST_LANE0	0x4400C
#define D_OFS_TXEQ_PRE_POST_LANE1	0x4440C
#define		D_BIT_POST_OVRD_EN	13
#define		D_MASK_POST_OVRD_EN	0x2000	// bit 13
#define		D_BIT_TX_POST_CURSOR	7
#define		D_MASK_TX_POST_CURSOR	0x1F80	// bit 12:7
#define		D_BIT_PRE_OVRD_EN	6
#define		D_MASK_PRE_OVRD_EN	0x40	// bit 6
#define		D_BIT_TX_PRE_CURSOR	0
#define		D_MASK_TX_PRE_CURSOR	0x3F	// bit 5:0

static inline u32 dwc3_cxd_readl(void __iomem *base, u32 offset)
{
	return readl(base + offset);
}
 
static inline void dwc3_cxd_writel(void __iomem *base, u32 offset, u32 value)
{
	writel_relaxed(value, base + offset);
}

void __iomem *dwc3_cxd_link_base = NULL;
void __iomem *dwc3_cxd_phy_base = NULL;

void dwc3_cxd_set_phy_reg(void)
{
	uint32_t reg_val;

	s_print(S_DEBUG_INFO, "%s", __func__);

	// assert soft reset
	reg_val = dwc3_cxd_readl(dwc3_cxd_link_base, D_OFS_GUSB2PHYCFG);
	reg_val |= D_BIT_GUSB2PHYCFG_PHYSOFTRST;
	dwc3_cxd_writel(dwc3_cxd_link_base, D_OFS_GUSB2PHYCFG, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_link_base, D_OFS_GUSB3PIPECTL);
	reg_val |= D_BIT_GUSB3PIPECTL_PHYSOFTRST;
	dwc3_cxd_writel(dwc3_cxd_link_base, D_OFS_GUSB3PIPECTL, reg_val);

	// set phy reg
	reg_val = dwc3_cxd_readl(dwc3_cxd_phy_base, D_OFS_TXRX);
	s_print(S_DEBUG_INFO, "TX/RX: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_TX_VBOOST_LVL_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_VBOOST_LVL_EN] << D_BIT_TX_VBOOST_LVL_EN);
	reg_val &= ~D_MASK_TX_VBOOST_LVL;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_VBOOST_LVL] << D_BIT_TX_VBOOST_LVL);
	s_print(S_DEBUG_INFO, "TX/RX = 0x%.8x", reg_val); 
	dwc3_cxd_writel(dwc3_cxd_phy_base, D_OFS_TXRX, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_phy_base, D_OFS_TXEQ_MAIN_LANE0);
	s_print(S_DEBUG_INFO, "TX EQ main lane0: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_MAIN_OVRD_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_MAIN_OVRD_EN_L1] << D_BIT_MAIN_OVRD_EN);
	reg_val &= ~D_MASK_TX_MAIN_CURSOR;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_MAIN_CURSOR_L1] << D_BIT_TX_MAIN_CURSOR);
	s_print(S_DEBUG_INFO, "TX EQ main lane0 = 0x%.8x", reg_val);
	dwc3_cxd_writel(dwc3_cxd_phy_base, D_OFS_TXEQ_MAIN_LANE0, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_phy_base, D_OFS_TXEQ_PRE_POST_LANE0);
	s_print(S_DEBUG_INFO, "TX EQ pre/post lane0: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_POST_OVRD_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_POST_OVRD_EN_L1] << D_BIT_POST_OVRD_EN);
	reg_val &= ~D_MASK_TX_POST_CURSOR;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_POST_CURSOR_L1] << D_BIT_TX_POST_CURSOR);
	reg_val &= ~D_MASK_PRE_OVRD_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_PRE_OVRD_EN_L1] << D_BIT_PRE_OVRD_EN);
	reg_val &= ~D_MASK_TX_PRE_CURSOR;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_PRE_CURSOR_L1] << D_BIT_TX_PRE_CURSOR);
	s_print(S_DEBUG_INFO, "TX EQ pre/post lane0 = 0x%.8x", reg_val);
	dwc3_cxd_writel(dwc3_cxd_phy_base, D_OFS_TXEQ_PRE_POST_LANE0, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_phy_base, D_OFS_TXEQ_MAIN_LANE1);
	s_print(S_DEBUG_INFO, "TX EQ main lane1: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_MAIN_OVRD_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_MAIN_OVRD_EN_L2] << D_BIT_MAIN_OVRD_EN);
	reg_val &= ~D_MASK_TX_MAIN_CURSOR;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_MAIN_CURSOR_L2] << D_BIT_TX_MAIN_CURSOR);
	s_print(S_DEBUG_INFO, "TX EQ main lane1 = 0x%.8x", reg_val);
	dwc3_cxd_writel(dwc3_cxd_phy_base, D_OFS_TXEQ_MAIN_LANE1, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_phy_base, D_OFS_TXEQ_PRE_POST_LANE1);
	s_print(S_DEBUG_INFO, "TX EQ pre/post lane1: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_POST_OVRD_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_POST_OVRD_EN_L2] << D_BIT_POST_OVRD_EN);
	reg_val &= ~D_MASK_TX_POST_CURSOR;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_POST_CURSOR_L2] << D_BIT_TX_POST_CURSOR);
	reg_val &= ~D_MASK_PRE_OVRD_EN;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_PRE_OVRD_EN_L2] << D_BIT_PRE_OVRD_EN);
	reg_val &= ~D_MASK_TX_PRE_CURSOR;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TX_PRE_CURSOR_L2] << D_BIT_TX_PRE_CURSOR);
	s_print(S_DEBUG_INFO, "TX EQ pre/post lane1 = 0x%.8x", reg_val);
	dwc3_cxd_writel(dwc3_cxd_phy_base, D_OFS_TXEQ_PRE_POST_LANE1, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_link_base, D_OFS_U2PCNTL2);
	s_print(S_DEBUG_INFO, "U2PCNTL2: 0x%.8x", reg_val);
	reg_val &= ~D_MASK_COMPDISTUNE0;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_COMPDISTUNE0] << D_BIT_COMPDISTUNE0);
	reg_val &= ~D_MASK_TXVREFTUNE0;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TXVREFTUNE0] << D_BIT_TXVREFTUNE0);
	reg_val &= ~D_MASK_TXPREEMPAMPTUNE0;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_TXPREEMPAMPTUNE0] << D_BIT_TXPREEMPAMPTUNE0);
	reg_val &= ~D_MASK_SQRXTUNE0;
	reg_val |= (backup_phy_param.phy_data[P0_PARAM_SQRXTUNE0] << D_BIT_SQRXTUNE0);
	s_print(S_DEBUG_INFO, "U2PCNTL2 = 0x%.8x", reg_val);
	dwc3_cxd_writel(dwc3_cxd_link_base, D_OFS_U2PCNTL2, reg_val);

	// deassert soft reset
	reg_val = dwc3_cxd_readl(dwc3_cxd_link_base, D_OFS_GUSB2PHYCFG);
	reg_val &= ~D_BIT_GUSB2PHYCFG_PHYSOFTRST;
	dwc3_cxd_writel(dwc3_cxd_link_base, D_OFS_GUSB2PHYCFG, reg_val);

	reg_val = dwc3_cxd_readl(dwc3_cxd_link_base, D_OFS_GUSB3PIPECTL);
	reg_val &= ~D_BIT_GUSB3PIPECTL_PHYSOFTRST;
	dwc3_cxd_writel(dwc3_cxd_link_base, D_OFS_GUSB3PIPECTL, reg_val);
}

volatile static int dwc3_cxd_drd_lock;
void dwc3_cxd_wait_drd_done(void)
{
	int wait_limit;
	wait_limit = 500;

	s_print(S_DEBUG_INFO, "%s: pid=%d start\n", __func__, current->pid);
	while(dwc3_cxd_drd_lock != 0) {
		printk("%s wait\n", __func__);
		msleep(10);
		wait_limit--;
		if(wait_limit <=0) {
			printk("%s time out to wait for drd\n", __func__);
			break;
		}
	}
	s_print(S_DEBUG_INFO, "%s: end\n", __func__);
}
EXPORT_SYMBOL(dwc3_cxd_wait_drd_done);

void dwc3_cxd_set_drd_done(void)
{
	s_print(S_DEBUG_INFO, "%s pid=%d\n", __func__, current->pid);
	dwc3_cxd_drd_lock = 0;
}
EXPORT_SYMBOL(dwc3_cxd_set_drd_done);

void dwc3_cxd_start_drd(void)
{
        int wait_limit;
	wait_limit = 500;

	s_print(S_DEBUG_INFO, "%s start\n", __func__);
	while(dwc3_cxd_drd_lock != 0) {
		printk("%s wait\n", __func__);
		msleep(10);
		wait_limit--;
		if(wait_limit <=0) {
			printk("%s time out to wait for start\n", __func__);
			break;
		}
	}
	dwc3_cxd_drd_lock= 1;
	s_print(S_DEBUG_INFO, "%s end\n", __func__);
}
EXPORT_SYMBOL(dwc3_cxd_start_drd);

void dwc3_cxd_init_suppl(void)
{
	s_print(S_DEBUG_INFO, "%s\n", __func__);
	dwc3_cxd_link_base = ioremap(USB32LINK_ADDR, USB32LINK_SIZE);
	if(dwc3_cxd_link_base == NULL)
		printk("no mem: link\n");
	dwc3_cxd_phy_base = ioremap(USB32PHY_ADDR, USB32PHY_SIZE);
	if(dwc3_cxd_phy_base == NULL)
		printk("no mem: phy\n");

	dwc3_cxd_set_drd_done();
}

