/* Copyright 2022 Sony Corporation, SOCIONEXT INC. */
#ifndef __DWC3_CXD_H__
#define __DWC3_CXD_H__

//#define TESTCODE_USB_DWC3_TIME_DRD
//#define TESTCODE_USB_DWC3_LOCK

#define D_PSAVE_ON				1
#define D_PSAVE_OFF				0
#define D_IS_DISCONN				1
#define D_IS_CONNECT				0
/**
 * struct cxd_dwc3 - dwc33xd driver private structure
 * @dev:		device pointer
 * @glue_base:		ioaddr for the glue registers
 */
struct cxd_dwc3 {
	struct device *dev;
	void __iomem *glue_base;
	void __iomem *phy_base;
	struct clk		*tca_apb_clk;/* E_SCU_CLK_USB32_TCA_APB_CLK */
	struct clk		*suspend_clk;/* E_SCU_CLK_USB32_SUSPEND_CLK */
	struct clk		*aclk;/* E_SCU_CLK_USB32_ACLK */
	struct reset_control	*phy_reset;/* E_SCU_RST_USB32_PHY_RESET */
	struct reset_control	*por_rst;/* E_SCU_RST_USB32_POR */
	struct reset_control	*aresetn;/* E_SCU_RST_USB32_ARESETN */
	struct reset_control	*apbrst;/* E_SCU_RST_USB32_APBRST */
	spinlock_t lock;
	spinlock_t tcalock;
	uint32_t psave_on;
};

#ifndef CONFIG_ARCH_CXD90XXX_FPGA
void dwc3_cxd_is_disconnect(struct cxd_dwc3 *dwc, uint32_t is_disconn);
void dwc3_tca_cc_control_event(struct cxd_dwc3 *dwc, uint32_t polarity);
#endif
int dwc3_cxd_psave_off(struct cxd_dwc3 *data);
void dwc3_cxd_psave_on(struct cxd_dwc3 *data);

#include "dwc3-cxd-suppl.h"
#endif // __DWC3_CXD_H__

