/*
 * drivers/usb/f_usb/udif_usb_otg_if.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*--------------------------------------------------------------------------*
 * drivers/usb/scd/scd_device.c
 *
 * OTG and, Platform bus driver operations
 *
 * Copyright 2011 Sony Corporation
 *
 * This file is part of the HS-OTG Controller Driver SCD.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *---------------------------------------------------------------------------*/

#ifndef _UDIF_USB_OTG_IF_H_
#define _UDIF_USB_OTG_IF_H_

#define FUSB_A_DEVICE			0
#define FUSB_B_DEVICE			1

#define FUSB_VBUS_ON			1U
#define FUSB_VBUS_OFF			0

int fusb_try_start_notify(unsigned int port);
int fusb_try_stop_notify(unsigned int port);

#include <linux/irqreturn.h>

#ifdef CONFIG_USB_FUSB_OTG_TEST
void *fusb_test_get_notify_control(void);
void fusb_test_signal_event(UDIF_ULONG data);
irqreturn_t fusb_test_interrupt_usb_id(int irq, void *p);
irqreturn_t fusb_test_interrupt_usb_vbus(int irq, void *p);
#else
static inline void *fusb_test_get_notify_control(void) { return (void*)0; }
static inline void fusb_test_signal_event(UDIF_ULONG data) { return; }
static inline irqreturn_t fusb_test_interrupt_usb_id(int irq, void *p) { return IRQ_HANDLED; }
static inline irqreturn_t fusb_test_interrupt_usb_vbus(int irq, void *p) { return IRQ_HANDLED; }
#endif

#endif  /* !_UDIF_USB_OTG_IF_H_ */
