/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __USBG_SEN_LDISC_H__
#define __USBG_SEN_LDISC_H__

#include <linux/version.h>

#ifdef __USBG_SEN_LDISC_PVT__

#define USBG_LDISC_FLAG_BUFFERED		0
#define USBG_LDISC_FLAG_BUFFER_FULL		1
#define USBG_LDISC_FLAG_BUFFER_INTR		2
#define USBG_LDISC_FLAG_CLOSING			3
#define USBG_LDISC_FLAG_SENDING			4
#define USBG_LDISC_FLAG_RECEIVEING		5
#define USBG_LDISC_FLAG_SEND_INTR		6
#define USBG_LDISC_FLAG_RECEIVE_INTR		7
#define USBG_LDISC_FLAG_TX_THREAD		8
#define USBG_LDISC_FLAG_COMM_ACTIVE		9

/**
  *	pre-define
  */
struct usbg_ldisc_buf;
struct func_data;

struct usbg_ldisc_wait {
	wait_queue_head_t que;
	unsigned long flag;
};

struct usbg_ldisc_driver {
	struct usbg_ldisc_driver* p_this;
	struct usbg_ldisc_buf* tx_buf;
	struct usbg_ldisc_buf* rx_buf;
	struct func_data* usb;
	struct tty_struct* tty;
	struct console* con;
};

struct usbg_ldisc_buf {
	unsigned char* buf;
	unsigned char* rp;
	unsigned char* wp;
	ssize_t len;
	ssize_t size;

	/* wait queue	*/
	wait_queue_head_t wait_que;
	unsigned long wait_flag;

	/* operations	*/
	ssize_t(*read)(struct usbg_ldisc_buf* p_buf,
		       unsigned char* cp, size_t count);
	ssize_t(*write)(struct usbg_ldisc_buf* p_buf,unsigned char* cp,
			size_t count);

	/* copy function	*/
	ssize_t(*copy_from)(unsigned char* p_w, unsigned char* p_r,
				size_t count );
	ssize_t(*copy_to)(unsigned char* p_w, unsigned char* p_r,
				size_t count );
};

/**
 *	ldisc operations
 */
static int usbg_sen_ldisc_open(struct tty_struct *tty);
static void usbg_sen_ldisc_close(struct tty_struct *tty);
static ssize_t usbg_sen_ldisc_read(struct tty_struct *tty, struct file *file,
				   unsigned char __user * buf, size_t nr,
				   void **cookie, unsigned long offset);
static ssize_t usbg_sen_ldisc_write(struct tty_struct *tty, struct file *file,
				    const unsigned char *buf, size_t nr);
static int usbg_sen_ldisc_ioctl(struct tty_struct * tty, struct file * file,
				unsigned int cmd, unsigned long arg);
static void usbg_sen_ldisc_receive_buf(struct tty_struct *tty,
				       const unsigned char *cp,
				       const char *fp, int count);
static unsigned int usbg_sen_ldisc_poll(struct tty_struct *tty,
					struct file *file,
					struct poll_table_struct *poll_table);
static void ldisc_cleanup(struct tty_struct* tty);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 16)
#else
static int usbg_sen_ldisc_receive_room(struct tty_struct *tty);
#endif

static void usbg_sen_change_termios(struct tty_struct * tty, struct ktermios * new_termios);
static int usbg_sen_set_termios(struct tty_struct * tty, void __user *arg, int opt);

/**
 *	console operations
 */
static void usbg_sen_console_write(struct console *co, const char*s,
				   unsigned int count);


/**
 *	buffer operation
 */
static int usbg_ldisc_buf_init(struct usbg_ldisc_buf* p_buf);
static ssize_t usbg_ldisc_buf_read(
	struct usbg_ldisc_buf* p_buf,unsigned char* cp, size_t count);

static ssize_t usbg_ldisc_buf_write(
	struct usbg_ldisc_buf* p_buf,unsigned char* cp, size_t count);
static ssize_t usbg_ldisc_buf_memcpy(unsigned char* p_w, unsigned char* p_r,
				     size_t count );
/**
  *	thread
  */
static int tx_thread(void* vp);

/**
 *	xfer operation
 */
static ssize_t usbg_ldisc_send(struct usbg_ldisc_driver* p_driver);
static void comp_usbg_ldisc_send(struct usb_ep* ep, struct usb_request* req);
static ssize_t usbg_ldisc_receive(struct usbg_ldisc_driver* p_driver);
static void comp_usbg_ldisc_receive(struct usb_ep* ep, struct usb_request* req);
static void cleanup_ldisc_usb_request_buf(struct usb_ep* ep,
					  struct usb_request* p_req);
#endif

typedef enum USBG_SEN_LDISC_DIR {
	USBG_SEN_LDISC_DIR_TX = 0,
	USBG_SEN_LDISC_DIR_RX,
	USBG_SEN_LDISC_DIR_NBROF,
	USBG_SEN_LDISC_DIR_ERR = -1,
} usbg_sen_ldisc_dir_t;

extern int usbg_ldisc_init(void);
extern void usbg_ldisc_exit(void);
extern int usbg_ldisc_start(struct func_data* p_this);
extern int usbg_ldisc_stop(struct func_data* p_this);
extern void usbg_ldisc_cleanup_ep_data( struct usb_ep *ep );
#endif
