/*
 * usbg_mbf.c
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << Message Buffer Processing >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#define __USBG_STORAGE_MBF_C__
/*

 󥯥롼ɥե                                                 
*/
#include "usbg_mbf.h"
#include "usbg_storage_debug.h"

/*

 ؿץȥ                                                 
*/
static int queue_msg( GSTORAGE__Mbf *, void *, int );
static int dequeue_msg( GSTORAGE__Mbf *, void * );

/*

 ѿ                                                             
*/
#if GS_OUT__MBF_QUEUE_NUM
static int msgQueueNum    = 0;
       int maxMsgQueueNum = 0;
#endif

/*

 ؿ                                                             
*/
/**
 * cre_mbf
 **/
GSTORAGE__Mbf *cre_mbf( int msgSize, int msgNum )
{
    GSTORAGE__Mbf *pMbf;

    GS_DET( GS_OUT__MBF, "func Req" );

    /* alloc memory */
    pMbf = ( GSTORAGE__Mbf * )kmalloc( sizeof( GSTORAGE__Mbf ), GFP_ATOMIC );
    pMbf->maxMsgSize = msgSize;
    pMbf->bufSize = msgSize * msgNum;
    pMbf->free = pMbf->bufSize;
    pMbf->pStart = ( void * )kmalloc( pMbf->bufSize, GFP_ATOMIC );
    if ( pMbf->pStart == NULL ){
        kfree( pMbf );
        pMbf = NULL;
    }
    pMbf->pHead = pMbf->pTail = pMbf->pStart;
    pMbf->cond = 0;
    init_waitqueue_head( &pMbf->wqh );
    spin_lock_init( &pMbf->lock );

    return pMbf;
}

/**
 * del_mbf
 **/
void del_mbf( GSTORAGE__Mbf *pMbf )
{
    GS_DET( GS_OUT__MBF, "func Req" );

    /* free memory */
    if ( pMbf ){
        kfree( pMbf->pStart );
        kfree( pMbf );
        pMbf = NULL;
    }
}

/**
 * snd_mbf
 **/
int snd_mbf( GSTORAGE__Mbf *pMbf, void *pMsg, int msgSize )
{
    int           err = GSTORAGE_MBF__OK;
    unsigned long flags;

    GS_DET( GS_OUT__MBF, "func Req : pMbf = %p", pMbf );

    /* ¾ */
    spin_lock_irqsave( &pMbf->lock, flags );

    /* åХåե̵ͭå */
    if ( !pMbf ) {
        err = GSTORAGE_MBF__ERROR;
    }
    else {
        /* 塼ɲ */
        err = queue_msg( pMbf, pMsg, msgSize );
        /* Tell the main thread that something has happened */
        pMbf->cond = 1;
    }

    /* ޤ¾ */
    spin_unlock_irqrestore( &pMbf->lock, flags );

    wake_up_interruptible( &pMbf->wqh );

    GS_DET( GS_OUT__MBF, "func Comp" );

    return err;
}

/**
 * rcv_mbf
 **/
int rcv_mbf( GSTORAGE__Mbf *pMbf, void *pMsg )
{
    int           msgSize = 0;
    unsigned long flags;

    GS_DET( GS_OUT__MBF, "func Req" );

    /* Wait until a signal arrives or we are woken up */
    wait_event_interruptible( pMbf->wqh, pMbf->cond );

    GS_DET( GS_OUT__MBF, "event received : wait_event_interruptible() Comp" );

    /* ¾ */
    spin_lock_irqsave( &pMbf->lock, flags );

    /* åХåե̵ͭå */
    if ( !pMbf ) {
        msgSize = GSTORAGE_MBF__ERROR;
    }
    /* åͭ */
    else {
        /* 塼 */
        msgSize = dequeue_msg( pMbf, pMsg );
        /* å¾̵Сcond  0 */
        if ( ( pMbf->pHead == pMbf->pTail ) && ( pMbf->free  == pMbf->bufSize ) ){
            pMbf->cond = 0;
        }
    }

    /* ޤ¾ */
    spin_unlock_irqrestore( &pMbf->lock, flags );

    GS_DET( GS_OUT__MBF, "func Comp : pMbf = %p", pMbf );

    return msgSize;
}

/**
 * queue_msg
 **/
static int queue_msg( GSTORAGE__Mbf *pMbf, void *pMsg, int msgSize )
{
    int err = GSTORAGE_MBF__OK;

    GS_DET( GS_OUT__MBF, "func Req" );

    if ( pMbf->free >= pMbf->maxMsgSize ){
        pMbf->free  -= pMbf->maxMsgSize;
        memcpy( pMbf->pTail, &msgSize, sizeof( msgSize ) );
        memcpy( ( pMbf->pTail + sizeof( msgSize ) ), pMsg, msgSize );
        pMbf->pTail += pMbf->maxMsgSize;
        if ( pMbf->pTail >= pMbf->pStart + pMbf->bufSize )
            pMbf->pTail = pMbf->pStart;
#if GS_OUT__MBF_QUEUE_NUM
        if ( msgQueueNum < 10 ){
            msgQueueNum++;
            if ( msgQueueNum > maxMsgQueueNum ){
                maxMsgQueueNum = msgQueueNum;
            }
        }
        else {
            GS_ERR( GS_OUT__MBF_QUEUE_NUM, "Message Layer Error!!" );
        }
#endif
    }
    else {
        GS_INF( GS_OUT__MBF, "message size error" );
        err = GSTORAGE_MBF__ERROR;
    }

    return err;
}

/**
 * dequeue_msg
 **/
static int dequeue_msg( GSTORAGE__Mbf *pMbf, void *pMsg )
{
    int msgSize = 0;

    GS_DET( GS_OUT__MBF, "func Req" );

    if ( pMbf->free < pMbf->bufSize ){
        memcpy( &msgSize, pMbf->pHead, sizeof( msgSize ) );
        memcpy( pMsg, ( pMbf->pHead + sizeof( msgSize ) ), msgSize );
        pMbf->pHead += pMbf->maxMsgSize;
        if ( pMbf->pHead >= pMbf->pStart + pMbf->bufSize )
            pMbf->pHead = pMbf->pStart;
        pMbf->free += pMbf->maxMsgSize;
#if GS_OUT__MBF_QUEUE_NUM
        if ( msgQueueNum > 0 ){
            msgQueueNum--;
        }
        else {
            GS_ERR( GS_OUT__MBF_QUEUE_NUM, "Message Layer Error!!" );
        }
#endif
    }
    else {
        GS_INF( GS_OUT__MBF, "buffer size error" );
        msgSize = GSTORAGE_MBF__ERROR;
    }

    return msgSize;
}

