/*
 * usbg_mbf.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << Message Buffer Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_MBF_H__
#define __USBG_STORAGE_MBF_H__
/*

 󥯥롼ɥե                                                 
*/
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/moduleparam.h>

#include <linux/uaccess.h>
#include <asm/errno.h>

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <linux/device.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 29)
#include <linux/usb/gadget.h>
#else
#include <linux/usb_gadget.h>
#endif

/*

                                                              
*/
/* ơϢ */
/* Message Ϣ */
#define GSTORAGE_MBF__OK         0      /* Error Code (No Error)        */
#define GSTORAGE_MBF__ERROR     -1      /* Error Code (Mbf Error)       */

/*

                                                                
*/
typedef struct {
    int                 maxMsgSize;     /* Message祵            */
    int                 bufSize;        /* MessageBufΥ           */
    int                 free;           /* MessageBufζ       */
    void                *pStart;        /* MessageBufγϥɥ쥹     */
    void                *pHead;         /* MessageBufƬݥ     */
    void                *pTail;         /* MessageBufνüݥ     */
    int                 cond;           /* condition                    */
    wait_queue_head_t   wqh;            /* Wait Queue                   */
    spinlock_t          lock;           /* Spin-locking                 */
} GSTORAGE__Mbf;

/*

 饹                                                           
*/

/*

 ؿ                                                         
*/
extern GSTORAGE__Mbf *cre_mbf( int, int );
extern void del_mbf( GSTORAGE__Mbf * );
extern int  snd_mbf( GSTORAGE__Mbf *, void *, int );
extern int  rcv_mbf( GSTORAGE__Mbf *, void * );

#endif /* __USBG_STORAGE_MBF_H__ */
