/*
 * usbg_storage_cmd_dvd.c
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008,2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Command Processing for DVD >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#define __USBG_STORAGE_CMD_DVD_C__
/*

 󥯥롼ɥե                                                 
*/
#include <linux/uaccess.h>
#include <asm/page.h>
#include <asm/errno.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/hdreg.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <linux/device.h>
#include <linux/mm.h>
#include <linux/cdrom.h>
#include <linux/usb/gcore/usb_event.h>
#include <linux/usb/gcore/usb_gadgetcore.h>

#include <linux/usb/specific_gadget/usbg_cmn.h>

#include "usbg_storage_cmd.h"
#include "usbg_storage_cmd_extern.h"
#include "usbg_bdio.h"

/*

                                                              
*/
#define GSTORAGE__DVD_CMD_TIMEOUT_STD   ( 1000 * 240 )		/* 240 sec */
#define GSTORAGE__DVD_CMD_TIMEOUT_RW    ( 1000 * 20  )		/*  20 sec */

#define GSTORAGE__DVD_BLOCK_SIZE        ( 2 * 1024  )		/* 2 kbyte */

/*

 ѿ                                                             
*/

/*

 ؿץȥ                                                 
*/
static unsigned int convSenseDvd( GSTORAGE_CMD__DatRequestSenseDvd *,struct request_sense *, unsigned int );

/*

 ؿ                                                             
*/
/**
 * execPacketCmd_dvd
 **
 *   ޥɼ¹( for DVD )
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status execPacketCmd_dvd( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    unsigned char ret = GSTORAGE__SUCCESS;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    switch( pCmdCtx->pCdb->opCode ){
      case GSTORAGE_CMD__OPCODE_READ10 :
      case GSTORAGE_CMD__OPCODE_READ12 :
      case GSTORAGE_CMD__OPCODE_READ_BUFFER :
      case GSTORAGE_CMD__OPCODE_WRITE10 :
      case GSTORAGE_CMD__OPCODE_WRITE12 :
      case GSTORAGE_CMD__OPCODE_WRITE_BUFFER :
        storage_drvcnt_setMediaAccess( pCmdCtx->pUnitCtx );
        ret = atapi_dvd_read_write( pCmdCtx );
        break;
      case GSTORAGE_CMD__OPCODE_REQUEST_SENSE :
        if( pCmdCtx->pUnitCtx->senseFlg == GSTORAGE__OFF ){
            ret = requestSense_dvd( pCmdCtx );
        } else {
            ret = requestSense_std( pCmdCtx );
        }
        break;
      default :
        ret = extCmd_ata( pCmdCtx );
        break;
    }

    return ret;
}


/**
 * atapi_dvd_std
 **
 *   ATAPI READ/WRITE ޥɼ¹( for DVD )
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status atapi_dvd_std( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;
    unsigned char    *pBuf = NULL;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* 1. Buffer , ž Check ================================*/
    if ( pCmdCtx->dio == DATA_IN ){
        pBuf = pCmdCtx->pUnitCtx->pSendBuf;
        if ( pCmdCtx->expectDatLen > GSTORAGE__SEND_BUF_SIZE ){
            pCmdCtx->pData = pBuf;
            pCmdCtx->totalTransLen = 0;
            pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
            setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_INVALID_COMMAND );
            return ret;
        }
    }
    else if ( pCmdCtx->dio == DATA_OUT ){
        pBuf = pCmdCtx->pUnitCtx->pReceiveBuf;
        if ( pCmdCtx->expectDatLen > GSTORAGE__RECEIVE_BUF_SIZE ){
            pCmdCtx->pData = pBuf;
            pCmdCtx->totalTransLen = 0;
            pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
            setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_INVALID_COMMAND );
            return ret;
        }
    }

    /* 2. atapi_dvd_cmn() ƤӽФ =====================================*/
    ret = atapi_dvd_cmn( pCmdCtx, pBuf, pCmdCtx->expectDatLen );

    return ret;
}


/**
 * atapi_dvd_cmn
 **
 *   ATAPI READ/WRITE ޥɼ¹( for DVD )
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status atapi_dvd_cmn( GSTORAGE_DRV__CmdContext *pCmdCtx, 
                                unsigned char *pBuf, unsigned int expectDatLen )
{
    unsigned char ret = GSTORAGE__SUCCESS;

    int ioctlErr;
    struct cdrom_generic_command cgc;
    struct file* filp;
    unsigned int buflen;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    pCmdCtx->pUnitCtx->senseFlg = GSTORAGE__OFF;

    filp = pCmdCtx->pUnitCtx->fd;
    /* ¤ν ====================================================*/
    memset( &cgc, 0, sizeof( cgc ) );

    /* Command ¤ ==============================================*/
    memcpy( cgc.cmd, pCmdCtx->pCdb, CDROM_PACKET_SIZE );
    cgc.buffer = pBuf;
    switch( cgc.cmd[0] ){
      case GSTORAGE_CMD__OPCODE_READ10 :
      case GSTORAGE_CMD__OPCODE_READ12 :
      case GSTORAGE_CMD__OPCODE_READ_BUFFER :
        cgc.buflen = buflen
                   = ( expectDatLen > GSTORAGE__SEND_READ_BUF_SIZE ) ?
                     GSTORAGE__SEND_READ_BUF_SIZE : expectDatLen;
        break;
      case GSTORAGE_CMD__OPCODE_WRITE10 :
      case GSTORAGE_CMD__OPCODE_WRITE12 :
      case GSTORAGE_CMD__OPCODE_WRITE_BUFFER :
        cgc.buflen = buflen
                   = ( expectDatLen > GSTORAGE__RECEIVE_BUF_SIZE ) ?
                     GSTORAGE__RECEIVE_BUF_SIZE : expectDatLen;
        break;
      default :
        if ( pCmdCtx->dio == DATA_IN ){
            cgc.buflen = buflen
                       = ( expectDatLen > GSTORAGE__SEND_BUF_SIZE ) ?
                         GSTORAGE__SEND_BUF_SIZE : expectDatLen;
        }
        else {
            cgc.buflen = buflen
                       = ( expectDatLen > GSTORAGE__RECEIVE_BUF_SIZE ) ?
                         GSTORAGE__RECEIVE_BUF_SIZE : expectDatLen;
        }
        break;
    }

    cgc.sense  = (struct request_sense *)pCmdCtx->pUnitCtx->senseDvd;
    setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );

    if ( pCmdCtx->dio == DATA_IN ){
        cgc.data_direction = CGC_DATA_READ;
    }
    else if ( pCmdCtx->dio == DATA_OUT ){
        cgc.data_direction = CGC_DATA_WRITE;
    }
    else {
        cgc.data_direction = CGC_DATA_NONE;
    }
    if ( ( cgc.cmd[0] == GSTORAGE_CMD__OPCODE_READ10  ) || ( cgc.cmd[0] == GSTORAGE_CMD__OPCODE_READ12  ) ||
         ( cgc.cmd[0] == GSTORAGE_CMD__OPCODE_WRITE10 ) || ( cgc.cmd[0] == GSTORAGE_CMD__OPCODE_WRITE12 ) ){
        cgc.timeout = GSTORAGE__DVD_CMD_TIMEOUT_RW;
    }
    else {
        cgc.timeout = GSTORAGE__DVD_CMD_TIMEOUT_STD;
    }

    /* IOCTLޥɽ =============================================*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->unlocked_ioctl ){
#else
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->ioctl ){
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
        ioctlErr = filp->f_op->unlocked_ioctl(  filp, CDROM_SEND_PACKET, ( unsigned long )&cgc );
#else
        ioctlErr = filp->f_op->ioctl( filp->f_dentry->d_inode , filp,
                                      CDROM_SEND_PACKET, ( unsigned long )&cgc );
#endif

        pCmdCtx->pData = cgc.buffer;

        switch(ioctlErr){
            case 0:
                /* ̾ */
                pCmdCtx->totalTransLen += buflen - cgc.buflen;
                if ( cgc.stat == 0 ){
                    pCmdCtx->status = GSTORAGE_CMD__STATUS_PASS;
                }
                else {
                    pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
                }
                break;
            case -EIO:
                /* Fail */
                /* ioctlErr == -EIO   : 󥿥ॢȥ顼*/
                pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
                if ( cgc.stat == 0 ){
                    /* Хåե128kBʾλʤΤǤꤨʤ */
                    setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
                }
                break;
            case -ETIMEDOUT:
                /* Fail */
                /* ioctlErr == -ETIMEDOUT : ॢȥ顼*/
                setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
                pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
                break;
            case -EINVAL:
            case -EBUSY:
                /* PhaseError */
                /* ioctlErr == -EINVAL : žѥ᡼顼
                   ioctlErr == -EBUSY  : ¾Υ顼 */
                setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
                pCmdCtx->status = GSTORAGE_CMD__STATUS_FATAL;
                break;
            default:
                setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
                pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
                break;
        }
    }
    else {
        pCmdCtx->pData = cgc.buffer;
        pCmdCtx->totalTransLen = 0;
        pCmdCtx->status = GSTORAGE_CMD__STATUS_FAIL;
        setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
    }

    return ret;
}


/**
 * atapi_dvd_read_write
 **
 *   ATAPI READ/WRITE ޥɼ¹( for DVD )
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status atapi_dvd_read_write( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;
    GSTORAGE__Cdb    *pCdb = pCmdCtx->pCdb;
    unsigned char    *pBuf = NULL;
    uint32_t         transLba;
    uint32_t         transLen = 0;
    unsigned char    f_continue = GSTORAGE__OFF;
    unsigned long long cdbLen = 0;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* READ10, READ12, READ BUFFER */
    if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ10      ) ||
         ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ12      ) ||
         ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ_BUFFER ) ){
        if ( pCmdCtx->expectDatLen > GSTORAGE__SEND_READ_BUF_SIZE ){
            f_continue = GSTORAGE__ON;
        }
        else {
            pBuf = pCmdCtx->pUnitCtx->pSendReadBuf[0];
        }
    }
    /* WRITE10, WRITE12, WRITE BUFFER */
    else if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE10      ) ||
              ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE12      ) ||
              ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE_BUFFER ) ){
        if ( pCmdCtx->expectDatLen > GSTORAGE__RECEIVE_BUF_SIZE ){
            f_continue = GSTORAGE__ON;
        }
        else {
            pBuf = pCmdCtx->pUnitCtx->pReceiveBuf;
        }
    }
    /* Other(BUG) */
    else {
        GS_ERR( GS_OUT__CMD_DVD, "unsupported read/write command" );
    }

    /* continue ʤ =======================================================*/
    if ( f_continue == GSTORAGE__OFF ){
        /* continueInfo  -----------------------------------------------*/
        pCmdCtx->pUnitCtx->continueInfo.address     = 0x00000000;
        pCmdCtx->pUnitCtx->continueInfo.remainLen   = 0;
        pCmdCtx->pUnitCtx->continueInfo.remainLenCdb= 0;
        pCmdCtx->pUnitCtx->continueInfo.transferLen = 0;
        pCmdCtx->pUnitCtx->continueInfo.pProc       = NULL;
        pCmdCtx->cb         = NULL;     /* ɤ̵ */
        pCmdCtx->pProcParam = NULL;

        /* atapi_dvd_cmn() ƤӽФ ----------------------------------------*/
        ret = atapi_dvd_cmn( pCmdCtx, pBuf, pCmdCtx->expectDatLen );
    }
    /* continue  =======================================================*/
    else {
        /* continueInfo  -----------------------------------------------*/
        /* READ10, READ12, WRITE10, WRITE12 */
        if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ10  ) ||
             ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE10 ) ){
            transLba = ( pCdb->param[ 1 ] << 24 ) + ( pCdb->param[ 2 ] << 16 )
                     + ( pCdb->param[ 3 ] <<  8 ) + ( pCdb->param[ 4 ]       );
            transLen = ( pCdb->param[ 6 ] <<  8 ) + ( pCdb->param[ 7 ]       );
            cdbLen   = (unsigned long long)transLen * GSTORAGE__DVD_BLOCK_SIZE;
            pCmdCtx->pUnitCtx->continueInfo.address = transLba * GSTORAGE__DVD_BLOCK_SIZE;
        }
        else if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ12  ) ||
             ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE12 ) ){
            transLba = ( pCdb->param[ 1 ] << 24 ) + ( pCdb->param[ 2 ] << 16 )
                     + ( pCdb->param[ 3 ] <<  8 ) + ( pCdb->param[ 4 ]       );
            transLen = ( pCdb->param[ 5 ] << 24 ) + ( pCdb->param[ 6 ] << 16 )
                     + ( pCdb->param[ 7 ] <<  8 ) + ( pCdb->param[ 8 ]       );
            cdbLen   = (unsigned long long)transLen * GSTORAGE__DVD_BLOCK_SIZE;
            pCmdCtx->pUnitCtx->continueInfo.address = transLba * GSTORAGE__DVD_BLOCK_SIZE;
        }
        /* READ BUFFER, WRITE BUFFER */
        else if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ_BUFFER  ) ||
                  ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE_BUFFER ) ){
            transLba = ( pCdb->param[ 2 ] << 16 ) + ( pCdb->param[ 3 ] << 8 ) + ( pCdb->param[ 4 ] );
            transLen = ( pCdb->param[ 5 ] << 16 ) + ( pCdb->param[ 6 ] << 8 ) + ( pCdb->param[ 7 ] );
            cdbLen   = (unsigned long long)transLen;
            pCmdCtx->pUnitCtx->continueInfo.address = transLba;
        }
        /* Other(BUG) */
        else {
            GS_ERR( GS_OUT__CMD_DVD, "unsupported read/write command" );
        }

        /* CBElen < CDBLenå */
        if((unsigned long long)(pCmdCtx->expectDatLen) < cdbLen){
            pCmdCtx->totalTransLen = 0;
            setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
            pCmdCtx->status = GSTORAGE_CMD__STATUS_FATAL;
            return ret;
        }

        pCmdCtx->pUnitCtx->continueInfo.remainLen   = pCmdCtx->expectDatLen;
        pCmdCtx->pUnitCtx->continueInfo.remainLenCdb= transLen;
        pCmdCtx->pUnitCtx->continueInfo.transferLen = 0;
        pCmdCtx->pUnitCtx->continueInfo.pProc       = atapi_dvd_read_write_continue;
        pCmdCtx->cb         = NULL;     /* ɤ̵ */
        pCmdCtx->pProcParam = NULL;

        /* atapi_dvd_read_write_continue() ƤӽФ ---------------------*/
        ret = atapi_dvd_read_write_continue( pCmdCtx );
    }

    return ret;
}


/**
 * atapi_dvd_read_write_continue
 **
 *   ATAPI READ/WRITE ޥɼ¹( for DVD )
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status atapi_dvd_read_write_continue( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;
    GSTORAGE__Cdb    *pCdb = pCmdCtx->pCdb;
    GSTORAGE__Cdb    localCdb;
    unsigned char    *pBuf = NULL;
    uint32_t         transLen;
    uint32_t         transBlocks = 0;
    uint32_t         bufSize;
    signed long long offset;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* ޥ¸ ====================================================*/
    memcpy( (char *)&localCdb, pCdb, sizeof( GSTORAGE__Cdb ) );

    /* žСޥԽ ====================================*/
    /* ž(byte) */
    if ( pCmdCtx->dio == DATA_IN ){
        transLen = ( pCmdCtx->pUnitCtx->continueInfo.remainLen > GSTORAGE__SEND_READ_BUF_SIZE ) ?
                   GSTORAGE__SEND_READ_BUF_SIZE : pCmdCtx->pUnitCtx->continueInfo.remainLen;
        bufSize  = GSTORAGE__SEND_READ_BUF_SIZE;

        pBuf = pCmdCtx->pUnitCtx->pSendReadBuf[0];
    }
    else {
        transLen = ( pCmdCtx->pUnitCtx->continueInfo.remainLen > GSTORAGE__RECEIVE_BUF_SIZE ) ?
                   GSTORAGE__RECEIVE_BUF_SIZE : pCmdCtx->pUnitCtx->continueInfo.remainLen;
        bufSize  = GSTORAGE__RECEIVE_BUF_SIZE;

        pBuf = pCmdCtx->pUnitCtx->pReceiveBuf;
    }

    /* READ10, WRITE10, VERIFY */
    if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ10  ) ||
         ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE10 ) ){
        /* ž(sector), offset(LBA) */
        transBlocks = ( pCmdCtx->pUnitCtx->continueInfo.remainLenCdb > (bufSize / GSTORAGE__DVD_BLOCK_SIZE) ) ?
                      (bufSize / GSTORAGE__DVD_BLOCK_SIZE) : pCmdCtx->pUnitCtx->continueInfo.remainLenCdb;
        offset = pCmdCtx->pUnitCtx->continueInfo.address / GSTORAGE__DVD_BLOCK_SIZE;
        /* set parameter */
        pCdb->param[ 1 ] = ( offset >> 24 ) & 0xFF;
        pCdb->param[ 2 ] = ( offset >> 16 ) & 0xFF;
        pCdb->param[ 3 ] = ( offset >> 8  ) & 0xFF;
        pCdb->param[ 4 ] = ( offset       ) & 0xFF;
        pCdb->param[ 6 ] = ( transBlocks >> 8 ) & 0xFF;
        pCdb->param[ 7 ] = ( transBlocks      ) & 0xFF;
    }
    /* READ12, WRITE12 */
    else if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ12  ) ||
              ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE12 ) ){
        /* ž(sector), offset(LBA) */
        transBlocks = ( pCmdCtx->pUnitCtx->continueInfo.remainLenCdb > (bufSize / GSTORAGE__DVD_BLOCK_SIZE) ) ?
                      (bufSize / GSTORAGE__DVD_BLOCK_SIZE) : pCmdCtx->pUnitCtx->continueInfo.remainLenCdb;
        offset = pCmdCtx->pUnitCtx->continueInfo.address / GSTORAGE__DVD_BLOCK_SIZE;
        /* set parameter */
        pCdb->param[ 1 ] = ( offset >> 24 ) & 0xFF;
        pCdb->param[ 2 ] = ( offset >> 16 ) & 0xFF;
        pCdb->param[ 3 ] = ( offset >> 8  ) & 0xFF;
        pCdb->param[ 4 ] = ( offset       ) & 0xFF;
        pCdb->param[ 5 ] = ( transBlocks >> 24 ) & 0xFF;
        pCdb->param[ 6 ] = ( transBlocks >> 16 ) & 0xFF;
        pCdb->param[ 7 ] = ( transBlocks >> 8  ) & 0xFF;
        pCdb->param[ 8 ] = ( transBlocks       ) & 0xFF;
    }
    /* READ BUFFER, WRITE BUFFER */
    else if ( ( pCdb->opCode == GSTORAGE_CMD__OPCODE_READ_BUFFER  ) ||
              ( pCdb->opCode == GSTORAGE_CMD__OPCODE_WRITE_BUFFER ) ){
        /* ž(byte), offset(byte) */
        transBlocks = ( pCmdCtx->pUnitCtx->continueInfo.remainLenCdb > bufSize ) ?
                      bufSize : pCmdCtx->pUnitCtx->continueInfo.remainLenCdb;
        offset = pCmdCtx->pUnitCtx->continueInfo.address;
        /* set parameter */
        pCdb->param[ 2 ] = ( offset >> 16 ) & 0xFF;
        pCdb->param[ 3 ] = ( offset >> 8  ) & 0xFF;
        pCdb->param[ 4 ] = ( offset       ) & 0xFF;
        pCdb->param[ 5 ] = ( transBlocks >> 16 ) & 0xFF;
        pCdb->param[ 6 ] = ( transBlocks >> 8  ) & 0xFF;
        pCdb->param[ 7 ] = ( transBlocks       ) & 0xFF;
    }

    /* atapi_dvd_cmn() ƤӽФ ========================================*/
    ret = atapi_dvd_cmn( pCmdCtx, pBuf, pCmdCtx->pUnitCtx->continueInfo.remainLen );

    /* ޥᤷ ====================================================*/
    memcpy( pCdb, (char *)&localCdb, sizeof( GSTORAGE__Cdb ) );

    /* continueInfo  ===============================================*/
    if ( ret == GSTORAGE__SUCCESS ){
        if ( pCmdCtx->status == GSTORAGE_CMD__STATUS_PASS ){
            pCmdCtx->pUnitCtx->continueInfo.remainLen   -= transLen;
            pCmdCtx->pUnitCtx->continueInfo.remainLenCdb-= transBlocks;
            pCmdCtx->pUnitCtx->continueInfo.address     += transLen;
            pCmdCtx->pUnitCtx->continueInfo.transferLen += transLen;
            if ( (pCmdCtx->pUnitCtx->continueInfo.remainLen > 0) &&
                 (pCmdCtx->pUnitCtx->continueInfo.remainLenCdb > 0) ){
                pCmdCtx->status = GSTORAGE_CMD__STATUS_CONTINUE;
            }
        }
    }

    return ret;
}


/**
 * atapi_dvd_set_write_protect
 **
 *   SET WRITE PROTECT ¹( for DVD )
 *   protect ON/OFF(1/0)
 *         struct file Υݥ
 *   
 * ֤͡
 **/
void atapi_dvd_set_write_protect( int protect, struct file *filp )
{
    int                          result = 0;
    struct cdrom_generic_command cgc;
    struct request_sense         sense;

    GS_DET( GS_OUT__CMD_DVD, "func Req : protect=%d", protect );

    /* ¤ν ====================================================*/
    memset( &cgc, 0, sizeof( cgc ) );
    memset( &sense, 0, sizeof( sense ) );

    /* Command ¤ ==============================================*/
    cgc.cmd[0] = GSTORAGE_CMD__OPCODE_VENDOR_SPECIFIC;
    cgc.cmd[1] = GSTORAGE_CMD__VENDOR_SET_WRITE_PROTECT;
    cgc.cmd[2] = protect & 0x01;
    cgc.buffer = NULL;
    cgc.buflen = 0;
    cgc.sense  = &sense;
    cgc.data_direction = CGC_DATA_NONE;
    cgc.timeout = GSTORAGE__DVD_CMD_TIMEOUT_STD;

    /* IOCTLޥɽ =============================================*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->unlocked_ioctl ){
#else
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->ioctl ){
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
        result = filp->f_op->unlocked_ioctl(  filp, CDROM_SEND_PACKET, ( unsigned long )&cgc );
#else
        result = filp->f_op->ioctl( filp->f_dentry->d_inode , filp,
                                      CDROM_SEND_PACKET, ( unsigned long )&cgc );
#endif

        if ( result ){
            GS_INF( GS_OUT__CMD_DVD, "ioctl error" );
        }
    }

    return;
}


/**
 * atapi_dvd_synchronize_cache
 **
 *   SYNCHRONIZE CACHE ¹( for DVD )
 *   struct file Υݥ
 *   
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
void atapi_dvd_synchronize_cache( struct file *filp )
{
    int                          result = 0;
    struct cdrom_generic_command cgc;
    struct request_sense         sense;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* ¤ν ====================================================*/
    memset( &cgc, 0, sizeof( cgc ) );
    memset( &sense, 0, sizeof( sense ) );

    /* Command ¤ ==============================================*/
    cgc.cmd[0] = GPCMD_FLUSH_CACHE;
    cgc.buffer = NULL;
    cgc.buflen = 0;
    cgc.sense  = &sense;
    cgc.data_direction = CGC_DATA_NONE;
    cgc.timeout = GSTORAGE__DVD_CMD_TIMEOUT_STD;

    /* IOCTLޥɽ =============================================*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->unlocked_ioctl ){
#else
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->ioctl ){
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
        result = filp->f_op->unlocked_ioctl(  filp, CDROM_SEND_PACKET, ( unsigned long )&cgc );
#else
        result = filp->f_op->ioctl( filp->f_dentry->d_inode , filp,
                                      CDROM_SEND_PACKET, ( unsigned long )&cgc );
#endif

        if ( result ){
            GS_INF( GS_OUT__CMD_DVD, "ioctl error" );
        }
    }

    return;
}


/**
 * atapi_dvd_reset
 **
 *   DVD RESET ¹( for DVD )
 *   struct file Υݥ
 *   
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
void atapi_dvd_reset( struct file *filp )
{
    int          result = 0;
    char         cmd[4];

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* Command ¤ ==============================================*/
    cmd[0] = 0;
    cmd[1] = 0;
    cmd[2] = 0;
    cmd[3] = 0;

    /* IOCTLޥɽ =============================================*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->unlocked_ioctl ){
#else
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->ioctl ){
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
        result = filp->f_op->unlocked_ioctl(  filp, HDIO_DRIVE_RESET, ( unsigned long )&cmd[0] );
#else
        result = filp->f_op->ioctl( filp->f_dentry->d_inode , filp,
                                      HDIO_DRIVE_RESET, ( unsigned long )&cmd[0] );
#endif

        if ( result ){
            GS_INF( GS_OUT__CMD_DVD, "ioctl error" );
        }
    }

    return;
}

/**
 * atapi_dvd_set_dma
 **
 *   SET DMA ¹( for DVD )
 *   struct file Υݥ
 *   
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
void atapi_dvd_set_dma( struct file *filp )
{
    int          result = 0;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* IOCTLޥɽ =============================================*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->unlocked_ioctl ){
#else
    if ( filp && !IS_ERR( filp ) && filp->f_op && filp->f_op->ioctl ){
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
        result = filp->f_op->unlocked_ioctl(  filp, HDIO_SET_DMA, 1 );
#else
        result = filp->f_op->ioctl( filp->f_dentry->d_inode , filp,
                                      HDIO_SET_DMA, 1 );
#endif

        if ( result ){
            GS_INF( GS_OUT__CMD_DVD, "ioctl error" );
        }
    }

    return;
}


/**
 * requestSense_dvd
 **
 *   DVD  REQUEST SENSE ޥɽ Data IN 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status requestSense_dvd( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status                 ret = GSTORAGE__SUCCESS;
    GSTORAGE_CMD__CdbRequestSense    *pCdb;
    GSTORAGE_CMD__DatRequestSenseDvd *pData;
    unsigned int bufLen = pCmdCtx->expectDatLen;
    unsigned int execLen;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    pCdb  = ( GSTORAGE_CMD__CdbRequestSense * )pCmdCtx->pCdb;
    pData = ( GSTORAGE_CMD__DatRequestSenseDvd * )pCmdCtx->pData;
    memset( pData, 0x00, sizeof( GSTORAGE_CMD__DatRequestSenseDvd ) );

    if ( ( pCmdCtx->dio == DATA_IN ) || ( pCmdCtx->dio == DATA_NON ) ){
        
        if ( ( pCdb->f1_link == 1 ) || ( pCdb->f1_naca == 1 ) ) {
            /* Invalid Filed */
            pCmdCtx->totalTransLen = 0;
            pCmdCtx->status        = GSTORAGE_CMD__STATUS_FAIL;
            setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_INVALID_FIELD );
        }
        else {
            /* REQUEST SENSE ǡѴ */
            execLen = convSenseDvd( pData, (struct request_sense *)pCmdCtx->pUnitCtx->senseDvd, pCdb->AL );
            if ( bufLen < execLen ){
                /* PhaseError */
                pCmdCtx->totalTransLen = 0;
                pCmdCtx->status = GSTORAGE_CMD__STATUS_FATAL;
                setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
            }
            else {
                /* set output data */
                pCmdCtx->totalTransLen = execLen;
                pCmdCtx->status        = GSTORAGE_CMD__STATUS_PASS;
                setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
            }
        }
    }
    else {
        /* invalid command */
        pCmdCtx->totalTransLen = 0;
        pCmdCtx->status        = GSTORAGE_CMD__STATUS_FATAL;
        setSenseDvd( pCmdCtx->pUnitCtx->senseDvd, GSTORAGE_CMD__SK_INVALID_COMMAND );
    }

    return ret;
}


/**
 * setSenseDvd
 **
 *   SENSE ǡ
 *   
 *   
 * ֤͡ʤ
 **/
void setSenseDvd( unsigned char *pSense, unsigned int senseKey )
{
    struct request_sense *pSenseDvd = (struct request_sense *)pSense;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    memset( pSenseDvd, 0x00, sizeof( struct request_sense ) );

    pSenseDvd->error_code    = 0x70;
    pSenseDvd->sense_key     = ( senseKey & 0x000f0000 ) >> 16;
    pSenseDvd->add_sense_len = 0x0A;
    pSenseDvd->asc           = ( senseKey & 0x0000ff00 ) >> 8;
    pSenseDvd->ascq          = ( senseKey & 0x000000ff );

    return;
}


/**
 * convSenseDvd
 **
 *   SENSE ǡѴ
 *   
 *   
 * ֤͡ʤ
 **/
static unsigned int convSenseDvd( GSTORAGE_CMD__DatRequestSenseDvd *pDest,
                                  struct request_sense             *pSrc,
                                  unsigned int                     len    )
{
    unsigned int i, senseLen, addSenseLen;

    GS_DET( GS_OUT__CMD_DVD, "func Req" );

    /* byte 0 ==============================================*/
    pDest->f7_errorCode = pSrc->error_code;
    pDest->f1_valid     = pSrc->valid;
    /* byte 1 ==============================================*/
    pDest->segmentNum   = pSrc->segment_number;
    /* byte 2 ==============================================*/
    pDest->f4_senseKey  = pSrc->sense_key;
    pDest->f1_reserved2 = pSrc->reserved2;
    pDest->f1_ili       = pSrc->ili;
    pDest->f2_reserved2 = pSrc->reserved1;
    /* byte 3 - 6 ==========================================*/
    for( i = 0; i < 4; i++ ){
        pDest->information[i] = pSrc->information[i];
    }
    /* byte 7 ==============================================*/
    addSenseLen = pSrc->add_sense_len + 8;
    if ( len < addSenseLen ){
        pDest->addSenseLen = len - 8;
        senseLen = len;
    }
    else {
        pDest->addSenseLen = addSenseLen - 8;
        senseLen = addSenseLen;
    }
    GS_DBG( GS_OUT__CMD_DVD, "len=%d, addSenseLen=%d, senseLen=%d\n", len, addSenseLen, senseLen );
    /* byte 8 - 11 =========================================*/
    for( i = 0; i < 4; i++ ){
        pDest->commandSpecific[i] = pSrc->command_info[i];
    }
    /* byte 12 =============================================*/
    pDest->addSenseCode = pSrc->asc;
    /* byte 13 =============================================*/
    pDest->addSenseQualifier = pSrc->ascq;
    /* byte 14 =============================================*/
    pDest->fieldReplaceableUnitCode = pSrc->fruc;
    /* byte 15 - 17 ========================================*/
    for( i = 0; i < 3; i++ ){
        pDest->senseKeySpecific[i] = pSrc->sks[i];
    }
    /* byte 18 - 63 ========================================*/
    for( i = 0; i < 46; i++ ){
        if ( i >= pDest->addSenseLen - 10 ){
            break;
        }
        pDest->addSenseBytes[i] = pSrc->asb[i];
    }

    return senseLen;
}

