/*
 * usbg_storage_cmd_ext.c
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2008,2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Command Processing (standard) >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#define __USBG_STORAGE_CMD_EXT_C__
/*

 󥯥롼ɥե                                                 
*/
#include <linux/uaccess.h>
#include <asm/page.h>
#include <asm/errno.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/hdreg.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <linux/device.h>
#include <linux/mm.h>
#include <linux/usb/gcore/usb_event.h>
#include <linux/usb/gcore/usb_gadgetcore.h>

#include <linux/usb/specific_gadget/usb_config.h>
#include <linux/usb/specific_gadget/usbg_cmn.h>
#include <linux/usb/specific_gadget/usb_extcmd.h>

#include "usbg_storage_cmd.h"
#include "usbg_storage_cmd_extern.h"
#include "usbg_bdio.h"

#include "usbg_storage_conf.h"

/*

                                                              
*/

/*

 ѿ                                                             
*/

/*

 ؿץȥ                                                 
*/

/*

 ؿ                                                             
*/
static inline int EXTCMD_IOCTL(struct file *fd,unsigned int ioc,uint32_t *extcmd_param){
    int result;

    /* The cast to a user pointer is valid due to the set_fs() */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
    result = fd->f_op->unlocked_ioctl(fd,ioc,(unsigned long)extcmd_param);
#else
    result = fd->f_op->ioctl(fd->f_dentry->d_inode,fd,ioc,(unsigned long)extcmd_param);
#endif
    return result;
}

/**
    ޥɼ¹
 **/
/**
 * extCmd_std
 **
 *   EXT ޥɽ Data IN/OUT 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS
 **/
GSTORAGE__Status extCmd_std( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    ret = extCmd_exec(pCmdCtx);

    if(ret == GSTORAGE__NON_DETECT){
        ret = unknownCmd_std( pCmdCtx );
    }

    return ret;
}

/**
 * extCmd_ata
 **
 *   EXT ޥɽ Data IN/OUT 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS
 **/
GSTORAGE__Status extCmd_ata( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    ret = extCmd_exec(pCmdCtx);

    if(ret == GSTORAGE__NON_DETECT){
        ret = atapi_dvd_std( pCmdCtx );
    }else{
        pCmdCtx->pUnitCtx->senseFlg = GSTORAGE__ON;
    }

    return ret;
}

/**
 * extCmd_exec
 **
 *   EXT ޥɽ Data IN/OUT 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__NON_DETECT/GSTORAGE__DETECT
 **/
GSTORAGE__Status extCmd_exec( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;
    GSTORAGE__Cdb    *pCdb = pCmdCtx->pCdb;
    unsigned int bufLen = (unsigned int)pCmdCtx->expectDatLen;
    union usb_extcmd_param extcmd_param;
    int res;
    unsigned int senseBuf;
    usb_extcmd_sense sense;
    struct file *fd_ext = pCmdCtx->pUnitCtx->pDevCtx->fd_ext;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    memset(&extcmd_param,0,sizeof(union usb_extcmd_param));
    memset(&sense,0,sizeof(usb_extcmd_sense));
    extcmd_param.kprm_inquiry.cbpLen     = sizeof(GSTORAGE__Cdb);
    extcmd_param.kprm_inquiry.cbp.cbwcb  = (struct _usb_extcmd_cbwcb*)pCdb;
    extcmd_param.kprm_inquiry.sense      = &sense;

    GS_DBG( GS_OUT__EXTCOMMAND, "cbpLen = %d",(unsigned int)(extcmd_param.kprm_inquiry.cbpLen) );
    if ( pCmdCtx->dio == DATA_OUT ){
        GS_DBG( GS_OUT__EXTCOMMAND, "pCmdCtx->dio = %x",pCmdCtx->dio);
        extcmd_param.kprm_inquiry.dir = EXTCMD_INQUIRY_DIR_K_WRITE;
        /* extcmd inquiry : Ͽꥯȳǧ */
        if(pCmdCtx->pUnitCtx->pDevCtx->fd_ext != NULL){
            res = EXTCMD_IOCTL(fd_ext,USB_IOC_EXTCMD_K_INQUIRY,(uint32_t *)&extcmd_param);

            GS_DBG( GS_OUT__EXTCOMMAND, "ext_inquiry res = %x",res);
            if(res == 0){
                if( !EXTCMD_IS_SENSE_REGISTERED(&sense) ){
                    /* invalid command */
                    ret = GSTORAGE__NON_DETECT;
                }
                else if( EXTCMD_IS_SENSE_NO_PROBLEM(&sense) ){
                     if ( bufLen > 0 ) {
                         pCmdCtx->pUnitCtx->continueInfo.extcmd      = GSTORAGE__ON;
                         pCmdCtx->pUnitCtx->continueInfo.remainLen   = bufLen;
                         pCmdCtx->pUnitCtx->continueInfo.address     = 0;/* LBA not user*/
                         pCmdCtx->pUnitCtx->continueInfo.transferLen = 0;
                         pCmdCtx->pUnitCtx->continueInfo.pProc       = extCmd_write_std_continue;
                         GS_DBG( GS_OUT__CMD_RW, "bufLen=%d, address=%x, remainLen=%d, transferLen=%d",
                                 bufLen, (unsigned int)pCmdCtx->pUnitCtx->continueInfo.address,
                                 pCmdCtx->pUnitCtx->continueInfo.remainLen, pCmdCtx->pUnitCtx->continueInfo.transferLen );
                         /* extcmd write : extcmd˥ǡ񤭹 */
                         ret = extCmd_write_std_continue( pCmdCtx );
                     }
                     else {
                         pCmdCtx->totalTransLen = 0;
                         pCmdCtx->status        = GSTORAGE_CMD__STATUS_PASS;
                         setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_NO_SENSE );
                     }
                }
                else {
                    pCmdCtx->totalTransLen = 0;
                    pCmdCtx->status        = GSTORAGE_CMD__STATUS_FAIL;
                    GS_INF( GS_OUT__CMD_RW, "sense error : sense=%x sensCode=%x",
                            sense.senseKey, sense.additional.sensCode );
                    GSTORAGE_CONVSENSE_EXTCMD(senseBuf,&sense);
                    setSense( &pCmdCtx->pUnitCtx->sense, ((unsigned int)senseBuf & 0x00FFFFFF) );
                }
            }
            else {/* 곰Υ顼 */
                pCmdCtx->totalTransLen = 0;
                pCmdCtx->status        = GSTORAGE_CMD__STATUS_FAIL;
                GS_INF( GS_OUT__CMD_RW, "inquiry error : res=%d", res );
                setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
            }
        }
        else {
            GS_DBG( GS_OUT__EXTCOMMAND, "invalid command or extcmd not ready");
            /* invalid command or extcmd not ready */
            ret = GSTORAGE__NON_DETECT;
        }
    } else if( pCmdCtx->dio == DATA_IN ){
        GS_DBG( GS_OUT__EXTCOMMAND, "pCmdCtx->dio = %x",pCmdCtx->dio);
        extcmd_param.kprm_inquiry.dir = EXTCMD_INQUIRY_DIR_K_READ;
        /* extcmd inquiry : Ͽꥯȳǧ */
        if(pCmdCtx->pUnitCtx->pDevCtx->fd_ext != NULL){
            res = EXTCMD_IOCTL(fd_ext,USB_IOC_EXTCMD_K_INQUIRY,(uint32_t *)&extcmd_param);

            GS_DBG( GS_OUT__EXTCOMMAND, "ext_inquiry res = %x", res );
            if(res == 0){
                if( !EXTCMD_IS_SENSE_REGISTERED(&sense) ){
                    /* invalid command */
                    ret = GSTORAGE__NON_DETECT;
                }
                else if( EXTCMD_IS_SENSE_NO_PROBLEM(&sense) ){
                     if ( bufLen > 0 ) {
                        pCmdCtx->pUnitCtx->continueInfo.extcmd      = GSTORAGE__ON;
                        pCmdCtx->pUnitCtx->continueInfo.address     = 0;/* LBA not user*/
                        pCmdCtx->pUnitCtx->continueInfo.remainLen   = bufLen;
                        pCmdCtx->pUnitCtx->continueInfo.transferLen = 0;
                        pCmdCtx->pUnitCtx->continueInfo.pProc       = extCmd_read_std_continue;
                        pCmdCtx->cb         = NULL;
                        pCmdCtx->pProcParam = pCmdCtx->pUnitCtx;
                        GS_DBG( GS_OUT__CMD_RW, "bufLen=%d, address=%x, remainLen=%d, transferLen=%d",
                                bufLen, (unsigned int)pCmdCtx->pUnitCtx->continueInfo.address,
                                pCmdCtx->pUnitCtx->continueInfo.remainLen, pCmdCtx->pUnitCtx->continueInfo.transferLen );
                        /* extcmd read : extcmdǡɤ߹ */
                        ret = extCmd_read_std_continue( pCmdCtx );
                     }
                     else {
                         pCmdCtx->totalTransLen = 0;
                         pCmdCtx->status        = GSTORAGE_CMD__STATUS_PASS;
                         setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_NO_SENSE );
                     }
                }
                else {
                    pCmdCtx->totalTransLen = 0;
                    pCmdCtx->status        = GSTORAGE_CMD__STATUS_FAIL;
                    GS_INF( GS_OUT__CMD_RW, "sense error : sense=%x sensCode=%x",
                            sense.senseKey, sense.additional.sensCode );
                    GSTORAGE_CONVSENSE_EXTCMD(senseBuf,&sense);
                    setSense( &pCmdCtx->pUnitCtx->sense, ((unsigned int)senseBuf & 0x00FFFFFF) );
                }
            }
            else {/* 곰Υ顼 */
                pCmdCtx->totalTransLen = 0;
                pCmdCtx->status        = GSTORAGE_CMD__STATUS_FAIL;
                GS_INF( GS_OUT__CMD_RW, "inquiry error : res=%d", res );
                setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
            }
        }
        else {
            GS_DBG( GS_OUT__EXTCOMMAND, "invalid command or extcmd not ready");
            /* invalid command or extcmd not ready */
            ret = GSTORAGE__NON_DETECT;
        }
    }
    else {
        /* DATA_NONξ⤳ */
        GS_DBG( GS_OUT__EXTCOMMAND, "invalid command");
        /* invalid command */
        ret = GSTORAGE__NON_DETECT;
    }

    return ret;
}

/**
 * extCmd_write_std_continue
 **
 *   Write ޥɽ
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status extCmd_write_std_continue( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;
    GSTORAGE__Status result;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    result = extCmd_writeMedia( pCmdCtx );
    pCmdCtx->status = result;

    switch( result ){
      case GSTORAGE_CMD__STATUS_PASS:
        setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_NO_SENSE );
        break;
      case GSTORAGE_CMD__STATUS_CONTINUE:
      case GSTORAGE_CMD__STATUS_FAIL:
        break;
      case GSTORAGE_CMD__STATUS_FATAL:
      default:
        setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
        break;
    }

    return ret;
}


/**
 * extcmd_writeMedia
 **
 *   Write 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status extCmd_writeMedia( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE_CMD__STATUS_PASS;
    GSTORAGE__Cdb    *pCdb = pCmdCtx->pCdb;
    unsigned int bufLen = (unsigned int)pCmdCtx->expectDatLen;
    int result;
    unsigned int transLen;
    union usb_extcmd_param extcmd_param;
    usb_extcmd_sense sense;
    unsigned int senseBuf;
    struct file *fd_ext = pCmdCtx->pUnitCtx->pDevCtx->fd_ext;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    memset(&extcmd_param,0,sizeof(union usb_extcmd_param));
    memset(&sense,0,sizeof(usb_extcmd_sense));
    extcmd_param.kprm_rw.cbpLen       = sizeof(GSTORAGE__Cdb);
    extcmd_param.kprm_rw.cbp.cbwcb    = (struct _usb_extcmd_cbwcb*)pCdb;
    extcmd_param.kprm_rw.totalReqLen  = bufLen;
    extcmd_param.kprm_rw.timeout      = 0;
    extcmd_param.kprm_rw.mode         = 0;
    extcmd_param.kprm_rw.sense        = &sense;

    if ( pCmdCtx->pUnitCtx->continueInfo.remainLen > GSTORAGE__RECEIVE_BUF_SIZE ){
        transLen = GSTORAGE__RECEIVE_BUF_SIZE;
    }
    else {
        transLen = pCmdCtx->pUnitCtx->continueInfo.remainLen;
    }
    GS_INF( GS_OUT__CMD_RW, "WriteParam size=%d ", transLen  );
    extcmd_param.kprm_rw.dataLen      = transLen;
    pCmdCtx->pData = pCmdCtx->pUnitCtx->pReceiveBuf;
    extcmd_param.kprm_rw.data    = (void *)pCmdCtx->pData;

    result = EXTCMD_IOCTL(fd_ext,USB_IOC_EXTCMD_K_WRITE,(uint32_t *)&extcmd_param);

    GS_INF( GS_OUT__CMD_RW, "result=%d", (unsigned int)result );
    GS_INF( GS_OUT__CMD_RW, "ret_size size=%d ", (unsigned int)(extcmd_param.kprm_rw.ret_size) );

    if( result == 0 ){
        if( EXTCMD_IS_SENSE_NO_PROBLEM(&sense) ){
            if ( (extcmd_param.kprm_rw.ret_size) == transLen ){
                pCmdCtx->pUnitCtx->continueInfo.remainLen   -= transLen;
                pCmdCtx->pUnitCtx->continueInfo.address      = 0;
                pCmdCtx->pUnitCtx->continueInfo.transferLen += transLen;
                pCmdCtx->totalTransLen                      += transLen;
        
                GS_INF( GS_OUT__CMD_RW, "remain Len=%d ", pCmdCtx->pUnitCtx->continueInfo.remainLen );
                if ( pCmdCtx->pUnitCtx->continueInfo.remainLen == 0 ){
                    ret = GSTORAGE_CMD__STATUS_PASS;
                }
                else {
                    ret = GSTORAGE_CMD__STATUS_CONTINUE;
                }
            }
            else {/* 곰Υ顼 */
                ret = GSTORAGE_CMD__STATUS_FAIL;
                GS_INF( GS_OUT__CMD_RW, "Write error : ret_size=%d transLen=%d",
                        (unsigned int)(extcmd_param.kprm_rw.ret_size),transLen );
                setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
            }
        }
        else {
            ret = GSTORAGE_CMD__STATUS_FAIL;
            GS_INF( GS_OUT__CMD_RW, "sense error : sense=%x sensCode=%x",
                    sense.senseKey, sense.additional.sensCode );
            GSTORAGE_CONVSENSE_EXTCMD(senseBuf,&sense);
            setSense( &pCmdCtx->pUnitCtx->sense, ((unsigned int)senseBuf & 0x00FFFFFF) );
        }
    }
    else {/* 곰Υ顼 */
        ret = GSTORAGE_CMD__STATUS_FAIL;
        GS_INF( GS_OUT__CMD_RW, "read error : result=%d", result );
        setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
    }

    return ret;
}

/**
 * extcmd_read_std_continue
 **
 *   Read 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status extCmd_read_std_continue( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE__SUCCESS;
    GSTORAGE__Status result;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    result = extCmd_readMedia( pCmdCtx );
    pCmdCtx->status = result;

    switch( result ){
      case GSTORAGE_CMD__STATUS_PASS:
        setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_NO_SENSE );
        break;
      case GSTORAGE_CMD__STATUS_CONTINUE:
      case GSTORAGE_CMD__STATUS_FAIL:
        break;
      case GSTORAGE_CMD__STATUS_FATAL:
      default:
        setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
        break;
    }

    return ret;
}


/**
 * extcmd_readMedia
 **
 *   Read 
 *   GSTORAGE_DRV__CmdContext Υݥ
 *   GSTORAGE_DRV__CmdContext
 *         ( GSTORAGE_DRV__DeviceContext, GSTORAGE_DRV__UnitContext )
 * ֤͡GSTORAGE__SUCCESS/GSTORAGE__ERROR
 **/
GSTORAGE__Status extCmd_readMedia( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GSTORAGE__Status ret = GSTORAGE_CMD__STATUS_PASS;
    GSTORAGE__Cdb    *pCdb = pCmdCtx->pCdb;
    unsigned int bufLen = (unsigned int)pCmdCtx->expectDatLen;
    int  result;
    unsigned int  transLen;
    union usb_extcmd_param extcmd_param;
    usb_extcmd_sense sense;
    unsigned int senseBuf;
    struct file *fd_ext = pCmdCtx->pUnitCtx->pDevCtx->fd_ext;

    GS_DET( GS_OUT__CMD_STD, "func Req" );

    memset(&extcmd_param,0,sizeof(union usb_extcmd_param));
    memset(&sense,0,sizeof(usb_extcmd_sense));
    extcmd_param.kprm_rw.cbpLen       = sizeof(GSTORAGE__Cdb);
    extcmd_param.kprm_rw.cbp.cbwcb    = (struct _usb_extcmd_cbwcb*)pCdb;
    extcmd_param.kprm_rw.totalReqLen  = bufLen;
    extcmd_param.kprm_rw.timeout      = 0;
    extcmd_param.kprm_rw.mode         = 0;
    extcmd_param.kprm_rw.data         = (uint32_t *)pCmdCtx->pUnitCtx->pSendBuf;
    extcmd_param.kprm_rw.sense        = &sense;

    if ( pCmdCtx->pUnitCtx->continueInfo.remainLen > GSTORAGE__SEND_READ_BUF_SIZE ){
        transLen = GSTORAGE__SEND_READ_BUF_SIZE;
    }
    else {
        transLen = pCmdCtx->pUnitCtx->continueInfo.remainLen;
    }
    GS_INF( GS_OUT__CMD_RW, "ReadParam size=%d ", transLen  );
    extcmd_param.kprm_rw.dataLen    = transLen;

    result = EXTCMD_IOCTL(fd_ext,USB_IOC_EXTCMD_K_READ,(uint32_t *)&extcmd_param);

    GS_INF( GS_OUT__CMD_RW, "result=%d", result );
    GS_INF( GS_OUT__CMD_RW, "ret_size size=%d ", (unsigned int)(extcmd_param.kprm_rw.ret_size) );
    pCmdCtx->pData = (unsigned char *)extcmd_param.kprm_rw.data;

    if( result == 0 ){
        if( EXTCMD_IS_SENSE_NO_PROBLEM(&sense) ){
            if ( (extcmd_param.kprm_rw.ret_size)  == transLen ){
                pCmdCtx->totalTransLen                      += transLen;
                pCmdCtx->pUnitCtx->continueInfo.remainLen   -= transLen;
                pCmdCtx->pUnitCtx->continueInfo.address     += 0;
                pCmdCtx->pUnitCtx->continueInfo.transferLen += transLen;
        
                GS_INF( GS_OUT__CMD_RW, "remain Len=%d ", pCmdCtx->pUnitCtx->continueInfo.remainLen );
                if ( pCmdCtx->pUnitCtx->continueInfo.remainLen == 0 ){
                    ret = GSTORAGE_CMD__STATUS_PASS;
                }
                else {
                    ret = GSTORAGE_CMD__STATUS_CONTINUE;
                }
            }
            else {/* 곰Υ顼 */
                ret = GSTORAGE_CMD__STATUS_FAIL;
                GS_INF( GS_OUT__CMD_RW, "read error : ret_size=%d transLen=%d",
                        (unsigned int)(extcmd_param.kprm_rw.ret_size),transLen );
                setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
            }
        }
        else {
            ret = GSTORAGE_CMD__STATUS_FAIL;
            GS_INF( GS_OUT__CMD_RW, "sense error : sense=%x sensCode=%x",
                    sense.senseKey, sense.additional.sensCode );
            GSTORAGE_CONVSENSE_EXTCMD(senseBuf,&sense);
            setSense( &pCmdCtx->pUnitCtx->sense, ((unsigned int)senseBuf & 0x00FFFFFF) );
        }
    }
    else {/* 곰Υ顼 */
        ret = GSTORAGE_CMD__STATUS_FAIL;
        GS_INF( GS_OUT__CMD_RW, "read error : result=%d", result );
        setSense( &pCmdCtx->pUnitCtx->sense, GSTORAGE_CMD__SK_HARDWARE_ERROR );
    }

    return ret;
}

/**
 * extcmd_cancel
 **/
int extcmd_cancel( GSTORAGE_DRV__DeviceContext *pDevCtx )
{
    int  result=0;
    union usb_extcmd_param extcmd_param;

    memset(&extcmd_param,0,sizeof(union usb_extcmd_param));
    GS_DET( GS_OUT__CMD_STD, "func Req" );

    if(pDevCtx->fd_ext != NULL){
        result = EXTCMD_IOCTL(pDevCtx->fd_ext,USB_IOC_EXTCMD_K_RESET,(uint32_t *)&extcmd_param);
        if(result < 0){
            GS_INF( GS_OUT__CMD_RW, "extcmd ioctl error result = %x", result );
        }
    }

    return result;
}


