/*
 * usbg_storage_cmn.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008,2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Common Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_CMN_H__
#define __USBG_STORAGE_CMN_H__
/*

 󥯥롼ɥե                                                 
*/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/moduleparam.h>

#include <linux/uaccess.h>
#include <asm/errno.h>

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <linux/device.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 29)
#include <linux/usb/gadget.h>
#else
#include <linux/usb_gadget.h>
#endif

#include <linux/usb/gcore/usb_gadgetcore.h>
#include <linux/usb/specific_gadget/usbg_cmn.h>
#include <linux/usb/specific_gadget/usbg_storage.h>
#include <linux/usb/specific_gadget/usb_ioctl_storage.h>

#include "usbg_storage_debug.h"


/*

                                                              
*/
#define GSTORAGE__NAME      "/dev/usb/massstorage"

/* ơϢ */
#define GSTORAGE__SUCCESS       0
#define GSTORAGE__ERROR         1
#define GSTORAGE__NON_DETECT    2
#define GSTORAGE__DETECT        3

#define GSTORAGE__OFF           0
#define GSTORAGE__ON            1

/* ܴϢ */
#define GSTORAGE__MSG_TBL_EOT           0x00    /* Message Table ü   */
#define GSTORAGE__STATE_NO_CHANGE       0xFF    /* ܤʤ         */

#define GSTORAGE__COMMON_BUF_SIZE       64*1024 /* ̥Хåե   */
#if   GS_OUT__BUFLEN_16K
#define GSTORAGE__SEND_BUF_SIZE         16*1024 /* (readʳ)     */
#define GSTORAGE__SEND_READ_BUF_SIZE    16*1024 /* (read)       */
#define GSTORAGE__RECEIVE_BUF_SIZE      16*1024 /* ()         */
#elif GS_OUT__BUFLEN_32K
#define GSTORAGE__SEND_BUF_SIZE         32*1024 /* (readʳ)     */
#define GSTORAGE__SEND_READ_BUF_SIZE    32*1024 /* (read)       */
#define GSTORAGE__RECEIVE_BUF_SIZE      32*1024 /* ()         */
#else
#define GSTORAGE__SEND_BUF_SIZE         64*1024 /* (readʳ)     */
#define GSTORAGE__SEND_READ_BUF_SIZE    512*1024 /* (read)       */
#define GSTORAGE__RECEIVE_BUF_SIZE      64*1024 /* ()         */
#endif
#define GSTORAGE__CBW_BUF_SIZE          1024      /* CBW                *//* 32->1024 for usb_ep_align_maybe() */
#define GSTORAGE__CSW_BUF_SIZE          16      /* CSW                */
#define GSTORAGE__CDB_BUF_SIZE          16      /* CDB                */
#define GSTORAGE__PREREAD_SIZE          64*1024 /* ɤߺǾ     */

#define GSTORAGE__MAX_LUN               7       /* MAX LUN ()       */
#define GSTORAGE__MAX_UNIT              GSTORAGE__MAX_LUN + 1

#define GSTORAGE__EXTCMD_MAX_ENTNUM     1

/*

                                                                
*/
/**
    
 **/
typedef unsigned int GSTORAGE__Status;
typedef unsigned int GSTORAGE__State;
typedef unsigned int GSTORAGE__MsgId;

/* Хåؿ */
typedef void ( *GSTORAGE__Cb )( GSTORAGE__Status );
typedef void ( *GSTORAGE__StartCb )( GSTORAGE__Status, unsigned char );
typedef void ( *GSTORAGE__MedStatCb )( GSTORAGE__Status, unsigned char, unsigned int lun );
typedef void ( *GSTORAGE__PacketCb )( GSTORAGE__Status, unsigned int, unsigned char, unsigned int * );

/**
    MassStorage饹 Bulk-OnlyץȥϢ
 **/
/* CBWη */
typedef struct {
    unsigned int  cbwSignature;
    unsigned int  cbwTag;
    unsigned int  cbwDataTransLen;
    unsigned char cbwFlags;
    unsigned char cbwLun;
    unsigned char cbwCdbLen;
    unsigned char cbwCdb[ 16 ];
    unsigned char cbwReserve;
} GSTORAGE__Cbw;

/* CSWη */
typedef struct {
    unsigned int  dCSWSignature;
    unsigned int  dCSWTag;
    unsigned int  dCSWDataResidue;
    unsigned char bCSWStatus;
    unsigned char CSWtmp[ 3 ];
} GSTORAGE__Csw;

/**
    PACKETޥϢ
 **/
/* CDBΥǡ¤ */
typedef struct {
    unsigned char opCode;               /* Operation Code       */
    unsigned char param[ 11 ];          /* parameter            */
    unsigned char dummy[ 4 ];           /* dummy                */
} GSTORAGE__Cdb;

/* ǡž */
typedef enum {
    DATA_NON = 0,
    DATA_IN,
    DATA_OUT
} GSTORAGE__Dio;

/* PACKETޥɤΥǡ¤ */
typedef struct {
    unsigned int  bufLength;    /* ǡХåեΥ       */
    GSTORAGE__Cbw *pCbw;        /* CBWΥݥ                */
    GSTORAGE__Cdb *pCdb;        /* CDBΥݥ                */
    unsigned char cdbLength;    /* CDBΥ                  */
    unsigned char lun;          /* LUN                          */
    GSTORAGE__Dio dio;          /* ǡž               */
} GSTORAGE__Packet;


typedef struct {
    wait_queue_head_t wqh;      /* Wait Queue                   */
    spinlock_t        lock;     /* Spin-locking                 */
    spinlock_t        lock_storage_in;
    int               end;      /* end flag                     */
} GSTORAGE__Thread;

struct GSTORAGE__UserData {
    unsigned char dummy;
};

struct GSTORAGE__Req {
    struct usb_request *req;
    void               *buf;
    unsigned int       len;
    unsigned char      in_use;
    GSTORAGE__data     data;
    struct list_head   list;
};

struct usbg_storage_ep_data {
    struct GSTORAGE__Req *req_data;
    u8                   halted;
};


/**
    åϢ
 **/
/* å¤ */
typedef union {                         /* max 26bytes          */
    GSTORAGE__MsgId id;                 /* unsigned int   -- 4  */
    /*----------------------------------------------------------*/
    /* Main / Drive Controller ưߴϢ( & probe/remove ) */
    struct {
        GSTORAGE__MsgId  id;            /* unsigned int   -- 4  */
        GSTORAGE__Cb     cb;            /* void *         -- 4  */
        GSTORAGE__Status stat;          /* unsigned int   -- 4  */
    } cnt;
    /*----------------------------------------------------------*/
    /* Main / Drive Controller ư                           */
    struct {
        GSTORAGE__MsgId   id;           /* unsigned int   -- 4  */
        GSTORAGE__StartCb cb;           /* void *         -- 4  */
    } start;
    /*----------------------------------------------------------*/
    /* Main / Drive Controller ưλ Callback              */
    struct {
        GSTORAGE__MsgId  id;            /* unsigned int   -- 4  */
        GSTORAGE__Status stat;          /* unsigned int   -- 4  */
        unsigned char    unknownMedia;  /* unsigned char  -- 1  */
    } compStart;
    /*----------------------------------------------------------*/
    /* Set Media Status Ϣ                                    */
    struct {
        GSTORAGE__MsgId     id;         /* unsigned int   -- 4  */
        GSTORAGE__MedStatCb cb;         /* void *         -- 4  */
        GSTORAGE__InfoMediaStatus info; /* struct         -- n  */
    } reqMedStat;
    /*----------------------------------------------------------*/
    /* Set Media Status λ CallBack Ϣ                      */
    struct {
        GSTORAGE__MsgId  id;            /* unsigned int   -- 4  */
        GSTORAGE__Status stat;          /* unsigned int   -- 4  */
        unsigned char    unknownMedia;  /* unsigned char  -- 1  */
        unsigned int     lun;           /* unsigned int   -- 4  */
    } compMedStat;
    /*----------------------------------------------------------*/
    /* Class Request Ϣ                                       */
    struct {
        GSTORAGE__MsgId  id;            /* unsigned int   -- 4  */
    } class;
    /*----------------------------------------------------------*/
    /* Service CallBack Ϣ                                    */
    struct {
        GSTORAGE__MsgId id;             /* unsigned int   -- 4  */
        GSTORAGE__Cb    cb;             /* void *         -- 4  */
    } cb;
    /*----------------------------------------------------------*/
    /* USB žλ CallBack Ϣ                               */
    struct {
        GSTORAGE__MsgId  id;            /* unsigned int   -- 4  */
        GSTORAGE__Status stat;          /* unsigned int   -- 4  */
        unsigned int     *pBuf;         /* unsigned int * -- 4  */
        unsigned int     size;          /* unsigned int   -- 4  */
    } compCb;
    /*----------------------------------------------------------*/
    /* Drive Controller λ CallBack Ϣ                      */
    struct {
        GSTORAGE__MsgId  id;            /* unsigned int   -- 4  */
        GSTORAGE__Status stat;          /* unsigned int   -- 4  */
        unsigned int     dataResidue;   /* unsigned int   -- 4  */
        unsigned char    status;        /* unsigned char  -- 1  */
        unsigned int     *pBuf;         /* unsigned int * -- 4  */
    } compDrvCnt;
    /*----------------------------------------------------------*/
    /* PACKET Ϣ                                          */
    struct {
        GSTORAGE__MsgId    id;          /* unsigned int   -- 4  */
        GSTORAGE__PacketCb cb;          /* void *         -- 4  */
        GSTORAGE__Packet   pckt;        /* struct         -- 18 */
    } pckt;
    /*----------------------------------------------------------*/
    /* Command Continue Ϣ                                    */
    struct {
        GSTORAGE__MsgId    id;          /* unsigned int   -- 4  */
        GSTORAGE__PacketCb cb;          /* void *         -- 4  */
    } cmdContinue;
} GSTORAGE__Msg;

/* åơ֥ι¤ */
typedef struct {
    GSTORAGE__MsgId id;
    GSTORAGE__State ( *func )( GSTORAGE__Msg *pMsg );
} GSTORAGE__MsgTbl;

/* Cmn ѹ¤ */
typedef struct {
    signed int         maxLunNum;       /* Max LUN num          */
    int                cond;            /* condition            */
    wait_queue_head_t  wqh;             /* Wait Queue           */
    struct func_data   *pThis;          /* this pointer for Cmn */
} GSTORAGE__Cmn;

/* Cmn  MainCnt, DrvCnt Ϥǡ */
typedef struct {
    unsigned char *pSendBuf;    /* ѥХåե(Readʳ)     */
    unsigned char *pReceiveBuf; /* ѥХåե()         */

    int                      extCmdNum;   /* Ͽĥޥɿ */
    GSTORAGE__InfoInitExtCmd *pExtCmd;    /* ĥޥɾ   */
} GSTORAGE__InfoInitCmn;

typedef struct {
    signed int maxLun;                  /* LUN              */
} GSTORAGE__InfoInitMain;

typedef struct {
    unsigned char *pSendReadBuf[ 2 ];   /* ѥХåե(Read) */
    GSTORAGE__InfoInitDrive *pDrive;    /* ɥ饤־         */
} GSTORAGE__InfoInitLun;

/* ޥ */
/* ǥѴ */
#define GSTORAGE_TRANS_ENDIAN( a ) ( ( ( a << 24 ) & 0xFF000000 ) | \
                                     ( ( a <<  8 ) & 0x00FF0000 ) | \
                                     ( ( a >>  8 ) & 0x0000FF00 ) | \
                                     ( ( a >> 24 ) & 0x000000FF ) )


/*

 饹                                                           
*/

/*

 ؿ                                                         
*/
extern GSTORAGE__State storage_execFunc( GSTORAGE__Msg *, GSTORAGE__State,
                                         const GSTORAGE__MsgTbl *[]      );
extern void storage_exec_remove( void );
extern void storage_comp_setMediaStatus( GSTORAGE__Status, unsigned int lun );
extern void storage_detect_ExtCommand( int lun, GSTORAGE__Cdb *pCdb );
extern void storage_storageIn( void );
extern void storage_storageOut( void );
extern void storage_set_waitResetRecovery( void );
extern void storage_dequeue_ep( struct usb_ep * );


#endif /* __USBG_STORAGE_CMN_H__ */

