/*
 * usbg_storage_drvcnt.c
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008,2009,2010,2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Drive Controller Function >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#define __USBG_STORAGE_DRVCNT_C__
/*

 󥯥롼ɥե                                                 
*/
#include <linux/uaccess.h>
#include <asm/page.h>
#include <asm/errno.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/version.h>
#include <linux/blkdev.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 3, 0)
#include <linux/kthread.h>
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)
#include <generated/autoconf.h>
#else
#include <linux/autoconf.h>
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <linux/device.h>
#include <linux/mm.h>
#include <linux/usb/gcore/usb_event.h>
#include <linux/usb/gcore/usb_gadgetcore.h>


#include <linux/usb/specific_gadget/usb_config.h>
#include <linux/usb/specific_gadget/usbg_cmn.h>
#include <linux/usb/specific_gadget/usb_kdbg.h>
#include <linux/usb/specific_gadget/usb_putpid_config.h>
#include <linux/usb/specific_gadget/usb_node_info.h>


#include "usbg_mbf.h"
#include "usbg_storage_drvcnt.h"
#include "usbg_storage_cmd_extern.h"

#include "usbg_storage_conf.h"

/*

                                                              
*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 3, 0)
#define f_dentry	f_path.dentry
#endif

#define MSG_DRVCNT_MAX_NUM      10      /* å             */

/* Message ID( Drive Controller ) */
enum {
    MSG_DRVCNT__EOT = GSTORAGE__MSG_TBL_EOT,
    MSG_DRVCNT__STOP_THREAD      ,      /* Drv Cnt Thread ׵      */
    MSG_DRVCNT__START_DRVCNT     ,      /* Drv Cnt ׵             */
    MSG_DRVCNT__STOP_DRVCNT      ,      /* Drv Cnt ׵             */
    MSG_DRVCNT__SET_MEDIA_STATUS ,      /* Set Media Status ׵        */
    MSG_DRVCNT__SND_CMD          ,      /* ޥ׵             */
    MSG_DRVCNT__SND_CMD_CONTINUE ,      /* ޥ׵(CONTINUE)   */
};

/* Ƽ */
#define DRVCNT_STATE__NO_CHANGE GSTORAGE__STATE_NO_CHANGE /* ܤʤ */
enum {
    DRVCNT_STATE_OFF = 0,                               /*  */
    DRVCNT_STATE_ON,                                    /* ư */
};

/* ֥åIO */
enum {
    DRVCNT_ACCESS_STATE_OFF = 0,              /* ̵ */
    DRVCNT_ACCESS_STATE_ON,                   /* ͭ */
};

/*

 ؿץȥ                                                 
*/
/* Thread ׵ */
static GSTORAGE__State reqStopThread( GSTORAGE__Msg * );
/* Drive Controller  */
static GSTORAGE__State startDrvCnt( GSTORAGE__Msg * );
/* Drive Controller  */
static GSTORAGE__State stopDrvCnt( GSTORAGE__Msg * );
/* Set Media Status ׵ */
static GSTORAGE__State reqSetMediaStatus( GSTORAGE__Msg * );
/* Set Media Status  */
static GSTORAGE__Status setMediaStatus( GSTORAGE__InfoMediaStatus * );
/* PACKET ޥϢ */
static GSTORAGE__State drvcnt_sndCmdPacket( GSTORAGE__Msg * );
static GSTORAGE__State drvcnt_sndCmdContinue( GSTORAGE__Msg * );
/* send message */
static void drvcnt_sendMsg( GSTORAGE__Msg *, int );
/* thread main */
static int drvcnt_threadFunc( void * );


/*

 ѿ                                                             
*/
/* åХåեݥ */
static GSTORAGE__Mbf *pMbf = NULL;
/* åɾݥ */
static GSTORAGE__Thread *pStorageDrvCnt = NULL;
/* Device Context */
static GSTORAGE_DRV__DeviceContext *pDevCtx = NULL;

/* Message Table [ Gadget Storage Bridge Driver ] */
static const GSTORAGE__MsgTbl storageMsgTbl_DrvCntOff[] = {
    { MSG_DRVCNT__START_DRVCNT    , startDrvCnt         },
    { MSG_DRVCNT__SET_MEDIA_STATUS, reqSetMediaStatus   },
    { MSG_DRVCNT__STOP_THREAD     , reqStopThread       },
    { MSG_DRVCNT__EOT             , 0                   },
};

static const GSTORAGE__MsgTbl storageMsgTbl_DrvCntOn[] = {
    { MSG_DRVCNT__STOP_DRVCNT     , stopDrvCnt            },
    { MSG_DRVCNT__SET_MEDIA_STATUS, reqSetMediaStatus     },
    { MSG_DRVCNT__SND_CMD         , drvcnt_sndCmdPacket   },
    { MSG_DRVCNT__SND_CMD_CONTINUE, drvcnt_sndCmdContinue },
    { MSG_DRVCNT__EOT             , 0                     },
};

/* Function Table List [ Gadget Storage Bridge Driver ] */
static const GSTORAGE__MsgTbl *spStorageMsgTbl_DrvCnt[] = {
    storageMsgTbl_DrvCntOff,
    storageMsgTbl_DrvCntOn,
};

static wait_queue_head_t access_q;
static int msc_access = DRVCNT_ACCESS_STATE_OFF;

/*

 ؿ                                                             
*/
/**
 * storage_drvcnt_reqStopThread
 **/
void storage_drvcnt_reqStopThread( GSTORAGE__Cb cb )
{
    GSTORAGE__Msg msg;

    GS_DET( GS_OUT__REMOVE, "func Req" );

    /* Drive Controller  DrvCnt Thread ׵ Message  */
    msg.cnt.id = MSG_DRVCNT__STOP_THREAD;
    msg.cnt.cb = cb;
    drvcnt_sendMsg( &msg, sizeof( msg.cnt ) );

    return;
}

/**
 * reqStopThread
 **/
static GSTORAGE__State reqStopThread( GSTORAGE__Msg *pMsg )
{
    GS_DET( GS_OUT__REMOVE, "func Req" );

    /* DrvCnt Thread  */
    pStorageDrvCnt->end = 1;

    return DRVCNT_STATE__NO_CHANGE;
}

/**
    ǥХϿ
 **/
/**
 * storage_drvcnt_setInitInfo
 **/
int storage_drvcnt_setInitInfo( int                   maxLun,
                                GSTORAGE__InfoInitCmn *pInfoCmn,
                                GSTORAGE__InfoInitLun **ppInfoLun )
{
    int                   i, j, err = 0, nodeSize = 0;
    GSTORAGE__InfoInitLun *pInfoLun;

    GS_DET( GS_OUT__INIT_INFO, "func Req" );

    /* Device Context */
    pDevCtx = kmalloc( sizeof( GSTORAGE_DRV__DeviceContext ), GFP_ATOMIC );
    GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx)                     =%p", pDevCtx );
    if ( pDevCtx == NULL ){
        err = GSTORAGE__ERROR;
        GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pDevCtx) error" );
    }
    if ( !err ){
        pDevCtx->maxLun = maxLun;
        pDevCtx->fd_ext = NULL;
        /* Unit Context */
        for ( i = 0; i <= maxLun; i++ ){
            pDevCtx->pUnitCtx[i] = NULL;
        }
        pInfoLun = *ppInfoLun;
        for ( i = 0; i <= maxLun; i++ ){
            pDevCtx->pUnitCtx[i] = kmalloc( sizeof( GSTORAGE_DRV__UnitContext ), GFP_ATOMIC );
            GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d])        =%p", i, pDevCtx->pUnitCtx[i] );
            if ( pDevCtx->pUnitCtx[i] == NULL ){
                err = GSTORAGE__ERROR;
                GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pUnitCtx) error" );
                for ( j = 0; j < i; j++ ){
                    if ( pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                         || pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", j, pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                        kfree( pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                    }
                    if ( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData ){
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->devNode );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", j, pDevCtx->pUnitCtx[j]->pDrive );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", j, pDevCtx->pUnitCtx[j]->pDrive );
                    kfree( pDevCtx->pUnitCtx[j]->pDrive->devNode );
                    kfree( pDevCtx->pUnitCtx[j]->pDrive );
                    kfree( pDevCtx->pUnitCtx[j] );
                }
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", pDevCtx );
                kfree( pDevCtx );
                pDevCtx = NULL;
                break;
            }
            pDevCtx->pUnitCtx[i]->pDevCtx = pDevCtx;

            /* GSTORAGE__InfoInitDrive 򥳥ԡ */
            pDevCtx->pUnitCtx[i]->pDrive = kmalloc( sizeof( GSTORAGE__InfoInitDrive ), GFP_ATOMIC );
            GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d]->pDrive)=%p", i, pDevCtx->pUnitCtx[i]->pDrive );
            if ( pDevCtx->pUnitCtx[i]->pDrive == NULL ){
                err = GSTORAGE__ERROR;
                GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pDrive) error" );
                for ( j = 0; j <= i ; j++ ){
                    if ( j < i ){
                        if ( pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                             || pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", j, pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                            kfree( pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                        }
                        if ( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData ){
                            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                            kfree( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                        }
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", j, pDevCtx->pUnitCtx[j]->pDrive );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", j, pDevCtx->pUnitCtx[j] );
                    kfree( pDevCtx->pUnitCtx[j] );
                }
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", pDevCtx );
                kfree( pDevCtx );
                pDevCtx = NULL;
                break;
            }
            memcpy( pDevCtx->pUnitCtx[i]->pDrive, pInfoLun->pDrive, sizeof( GSTORAGE__InfoInitDrive ) );
            
            pDevCtx->pUnitCtx[i]->pSendBuf    = pInfoCmn->pSendBuf;
            pDevCtx->pUnitCtx[i]->pReceiveBuf = pInfoCmn->pReceiveBuf;
            pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] = pInfoLun->pSendReadBuf[ 0 ];
            pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] = pInfoLun->pSendReadBuf[ 1 ];
            
            /* devNode 򥳥ԡ */
            nodeSize = strlen( pInfoLun->pDrive->devNode ) + 1;
            pDevCtx->pUnitCtx[i]->pDrive->devNode = kmalloc( nodeSize, GFP_ATOMIC );
            GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->devNode );
            if ( pDevCtx->pUnitCtx[i]->pDrive->devNode == NULL ){
                err = GSTORAGE__ERROR;
                GS_ERR( GS_OUT__INIT_INFO, "kmalloc(devNode) error" );
                for ( j = 0; j <= i ; j++ ){
                    if ( j < i ){
                        if ( pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                             || pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", j, pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                            kfree( pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                        }
                        if ( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData ){
                            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                            kfree( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                        }
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive->devNode );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", j, pDevCtx->pUnitCtx[j]->pDrive );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])        =%p", j, pDevCtx->pUnitCtx[j] );
                    kfree( pDevCtx->pUnitCtx[j]->pDrive );
                    kfree( pDevCtx->pUnitCtx[j] );
                }
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", pDevCtx );
                kfree( pDevCtx );
                pDevCtx = NULL;
                break;
            }
            memcpy( pDevCtx->pUnitCtx[i]->pDrive->devNode, pInfoLun->pDrive->devNode, nodeSize );
            /* pInquiryData 򥳥ԡ */
            if ( pDevCtx->pUnitCtx[i]->pDrive->inquiryDataLen ){
                pDevCtx->pUnitCtx[i]->pDrive->pInquiryData
                             = kmalloc( pDevCtx->pUnitCtx[i]->pDrive->inquiryDataLen, GFP_ATOMIC );
                GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                if ( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData == NULL ){
                    err = GSTORAGE__ERROR;
                    GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pInquiryData) error" );
                    for ( j = 0; j <= i ; j++ ){
                        if ( j < i ){
                            if ( pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                                 || pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", j, pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                                kfree( pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                            }
                            if ( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData ){
                                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                                kfree( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                            }
                        }
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", j, pDevCtx->pUnitCtx[j]->pDrive );
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", j, pDevCtx->pUnitCtx[j] );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive );
                        kfree( pDevCtx->pUnitCtx[j] );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", (void *)pDevCtx );
                    kfree( pDevCtx );
                    pDevCtx = NULL;
                    break;
                }
                memcpy( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData, pInfoLun->pDrive->pInquiryData,
                        pDevCtx->pUnitCtx[i]->pDrive->inquiryDataLen );
            }
            else {
                pDevCtx->pUnitCtx[i]->pDrive->pInquiryData = NULL;
            }
            pDevCtx->pUnitCtx[i]->fd = NULL;
            pDevCtx->pUnitCtx[i]->media.lastLBA       = 0x00000000;
            pDevCtx->pUnitCtx[i]->media.blockLength   = 0x00000000;
            pDevCtx->pUnitCtx[i]->media.blocks        = 0x00000000;
            pDevCtx->pUnitCtx[i]->media.writeProtect  = 0;
            pDevCtx->pUnitCtx[i]->media.mediumType    = 0;
            pDevCtx->pUnitCtx[i]->media.mediaStatus   = GSTORAGE__MEDIA_UNKNOWN;
            pDevCtx->pUnitCtx[i]->media.unitStatus    = GSTORAGE__UNIT_NOT_EJECT_START;
            pDevCtx->pUnitCtx[i]->media.changed       = GSTORAGE__OFF;
            pDevCtx->pUnitCtx[i]->mediaExt.pExt       = NULL;
            if ( pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                 || pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo = kmalloc( sizeof( GSTORAGE_DRV__MsInfo ), GFP_ATOMIC );
                GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", i, pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
                if ( pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo == NULL ){
                    err = GSTORAGE__ERROR;
                    GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pMsInfo) error" );
                    for ( j = 0; j <= i ; j++ ){
                        if ( j < i ){
                            if ( pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                                 || pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", j, pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                                kfree( pDevCtx->pUnitCtx[j]->mediaExt.pMsInfo );
                            }
                        }
                        if ( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData ){
                            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                            kfree( pDevCtx->pUnitCtx[j]->pDrive->pInquiryData );
                        }
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", j, pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", j, pDevCtx->pUnitCtx[j]->pDrive );
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", j, pDevCtx->pUnitCtx[j] );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive->devNode );
                        kfree( pDevCtx->pUnitCtx[j]->pDrive );
                        kfree( pDevCtx->pUnitCtx[j] );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", pDevCtx );
                    kfree( pDevCtx );
                    pDevCtx = NULL;
                    break;
                }
            }
            memset( &pDevCtx->pUnitCtx[i]->DatReadCapa, 0x00, sizeof( GSTORAGE_CMD__DatReadCapa ) );
            setSense( &pDevCtx->pUnitCtx[i]->sense, GSTORAGE_CMD__SK_NO_SENSE );
            setSenseDvd( pDevCtx->pUnitCtx[i]->senseDvd, GSTORAGE_CMD__SK_NO_SENSE );
            pDevCtx->pUnitCtx[i]->senseFlg = 0x00;
            pDevCtx->pUnitCtx[i]->preRead.pAccessBuf = pDevCtx->pUnitCtx[i]->pSendReadBuf[0];
            pDevCtx->pUnitCtx[i]->preRead.startAddr  = 0x0000000000000000;
            pDevCtx->pUnitCtx[i]->preRead.nextAddr   = 0x0000000000000000;
            pDevCtx->pUnitCtx[i]->continueInfo.pProc       = NULL;
            pDevCtx->pUnitCtx[i]->continueInfo.address     = 0x0000000000000000;
            pDevCtx->pUnitCtx[i]->continueInfo.remainLen   = 0x00000000;
            pDevCtx->pUnitCtx[i]->continueInfo.remainLenCdb= 0x00000000;
            pDevCtx->pUnitCtx[i]->continueInfo.transferLen = 0x00000000;
            pDevCtx->pUnitCtx[i]->mediaAccess = 0;
            pInfoLun++;
        }
        /* Command Context */
        if ( !err ){
            pDevCtx->pCmdCtx = kmalloc( sizeof( GSTORAGE_DRV__CmdContext ), GFP_ATOMIC );
            GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pCmdCtx)             =%p", pDevCtx->pCmdCtx );
            if ( pDevCtx->pCmdCtx == NULL ){
                err = GSTORAGE__ERROR;
                GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pCmdCtx) error" );
                for ( i = 0; i <= maxLun ; i++ ){
                    if ( pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                         || pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", i, pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
                        kfree( pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
                    }
                    if ( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData ){
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                        kfree( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->devNode );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", i, pDevCtx->pUnitCtx[i]->pDrive );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", i, pDevCtx->pUnitCtx[i] );
                    kfree( pDevCtx->pUnitCtx[i]->pDrive->devNode );
                    kfree( pDevCtx->pUnitCtx[i]->pDrive );
                    kfree( pDevCtx->pUnitCtx[i] );
                }
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", pDevCtx );
                kfree( pDevCtx );
                pDevCtx = NULL;
            }
        }
        /* ĥޥɾ */
        if( !err ) {
            pDevCtx->extCmdNum = pInfoCmn->extCmdNum; /* ĥޥϿ */
            if( pDevCtx->extCmdNum > GSTORAGE__EXTCMD_MAX_ENTNUM ) {
                pDevCtx->extCmdNum = 0;
                err = GSTORAGE__ERROR;
                GS_ERR( GS_OUT__INIT_INFO, "ExtCommand Num Error" );
            }
            for( i = 0; i < pDevCtx->extCmdNum; i++ ) {
                pDevCtx->pExtCmd[ i ] = kmalloc( sizeof( GSTORAGE__InfoInitExtCmd ), GFP_ATOMIC );
                GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pExtCmd[%d])          =%p", i, pDevCtx->pExtCmd[i] );
                if( pDevCtx->pExtCmd[ i ] == NULL ) {
                    err = GSTORAGE__ERROR;
                    GS_ERR( GS_OUT__INIT_INFO, "kmalloc(pExtCmd) error" );
                    pDevCtx->extCmdNum = 0;
                    for( j = 0; j < i ; j++ ) {
                        kfree( pDevCtx->pExtCmd[ j ] );
                    }
                    break;
                }
                pDevCtx->pExtCmd[ i ]->opCode = pInfoCmn->pExtCmd[ i ].opCode;    /* ĥޥOP */
            }
            if( err ) {
                kfree( pDevCtx->pCmdCtx );
                GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pCmdCtx)             =%p", pDevCtx->pCmdCtx );
                for( i = 0; i <= maxLun ; i++ ) {
                    if( pDevCtx->pUnitCtx[ i ]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                        || pDevCtx->pUnitCtx[ i ]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ) {
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", i, pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
                        kfree( pDevCtx->pUnitCtx[ i ]->mediaExt.pMsInfo );
                    }
                    if ( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData ){
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                        kfree( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->devNode );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", i, pDevCtx->pUnitCtx[i]->pDrive );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", i, pDevCtx->pUnitCtx[i] );
                    kfree( pDevCtx->pUnitCtx[i]->pDrive->devNode );
                    kfree( pDevCtx->pUnitCtx[i]->pDrive );
                    kfree( pDevCtx->pUnitCtx[i] );
                }
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", (void *)pDevCtx );
                kfree( pDevCtx );
                pDevCtx = NULL;
            }
        }
        /* Kernelΰ */
        if( !err ) {
            for( i = 0; i <= maxLun; i++ ) {
                if (pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_SXS) {
                    pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] = NULL;
                    pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] = NULL;
                    pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] = kmalloc((64*1024), GFP_ATOMIC);
                    pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] = kmalloc((64*1024), GFP_ATOMIC);
                    GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d]->pSendReadBuf[ 0 ]=%p", i, pDevCtx->pUnitCtx[i]->pSendReadBuf[0] );
                    GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pUnitCtx[%d]->pSendReadBuf[ 1 ]=%p", i, pDevCtx->pUnitCtx[i]->pSendReadBuf[1] );
                    if (( pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] == NULL ) ||
                        ( pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] == NULL )) {
                        err = GSTORAGE__ERROR;
                        GS_ERR( GS_OUT__INIT_INFO, "kmalloc(Kernel buf) error" );
                        for( j = 0; j < i ; j++ ) {
                            if ( pDevCtx->pUnitCtx[j]->pDrive->drvType == GSTORAGE__DRIVE_ID_SXS) {
                                if(pDevCtx->pUnitCtx[j]->pSendReadBuf[ 0 ] != NULL) {
                                    kfree( pDevCtx->pUnitCtx[j]->pSendReadBuf[ 0 ] );
                                }
                                if(pDevCtx->pUnitCtx[j]->pSendReadBuf[ 1 ] != NULL) {
                                    kfree( pDevCtx->pUnitCtx[j]->pSendReadBuf[ 1 ] );
                                }
                            }
                        }
                        break;
                    }
                }
            }
            if( err ) {
                for( i = 0; i < pDevCtx->extCmdNum; i++ ) {
                    kfree( pDevCtx->pExtCmd[ i ] );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pExtCmd[%d])          =%p", i, pDevCtx->pExtCmd[i] );
                }
                kfree( pDevCtx->pCmdCtx );
                GS_DBG( GS_OUT__INIT_INFO, "kmalloc(pDevCtx->pCmdCtx)             =%p", pDevCtx->pCmdCtx );
                for( i = 0; i <= maxLun ; i++ ) {
                    if( pDevCtx->pUnitCtx[ i ]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                        || pDevCtx->pUnitCtx[ i ]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ) {
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", i, pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
                        kfree( pDevCtx->pUnitCtx[ i ]->mediaExt.pMsInfo );
                    }
                    if ( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData ){
                        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                        kfree( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                    }
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->devNode );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", i, pDevCtx->pUnitCtx[i]->pDrive );
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", i, pDevCtx->pUnitCtx[i] );
                    kfree( pDevCtx->pUnitCtx[i]->pDrive->devNode );
                    kfree( pDevCtx->pUnitCtx[i]->pDrive );
                    kfree( pDevCtx->pUnitCtx[i] );
                }
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", (void *)pDevCtx );
                kfree( pDevCtx );
                pDevCtx = NULL;
            }
        }
    }

    /* DEBUG PRINT */
    if ( 0 ){
        printDevCtx();
    }

    return err;
}

/**
 * storage_drvcnt_clearInitInfo
 **/
void storage_drvcnt_clearInitInfo( void )
{
    int i, maxLun, extCmdNum;

    GS_DET( GS_OUT__INIT_INFO, "func Req" );

    if ( pDevCtx ){
        /* ExtCmd */
        extCmdNum = pDevCtx->extCmdNum;
        for( i = 0; i < extCmdNum; i++ ) {
            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pExtCmd[%d])          =%p", i, pDevCtx->pExtCmd[i] );
            kfree( pDevCtx->pExtCmd[ i ] );
        }
        /* CmdCtx */
        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pCmdCtx)              =%p", pDevCtx->pCmdCtx );
        kfree( pDevCtx->pCmdCtx );
        /* UnitCtx */
        maxLun = pDevCtx->maxLun;
        for ( i = 0; i <= maxLun; i++ ){
            if ( pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
                 || pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->mediaExt.pMsInfo)=%p", i, pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
                kfree( pDevCtx->pUnitCtx[i]->mediaExt.pMsInfo );
            }
            if ( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData ){
                GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
                kfree( pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
            }
            if ( pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_SXS) {
                if(pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] != NULL) {
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pSendReadBuf[ 0 ])=%p", i, pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] );
                    kfree( pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] );
                }
                if(pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] != NULL) {
                    GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pSendReadBuf[ 1 ])=%p", i, pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] );
                    kfree( pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] );
                }
            }
            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive->devNode)=%p", i, pDevCtx->pUnitCtx[i]->pDrive->devNode );
            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d]->pDrive)=%p", i, pDevCtx->pUnitCtx[i]->pDrive );
            GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx->pUnitCtx[%d])         =%p", i, pDevCtx->pUnitCtx[i] );
            kfree( pDevCtx->pUnitCtx[i]->pDrive->devNode );
            kfree( pDevCtx->pUnitCtx[i]->pDrive );
            kfree( pDevCtx->pUnitCtx[i] );
        }
        /* DevCtx */
        GS_DBG( GS_OUT__INIT_INFO, "kfree(pDevCtx                       =%p", pDevCtx );
        kfree( pDevCtx );
        pDevCtx = NULL;
    }
}


/**
    Get Receive Buffer Pointer
 **/
/**
 * storage_drvcnt_getReceiveBufP
 **/
unsigned char *storage_drvcnt_getReceiveBufP( int lun )
{
    unsigned char *pBuf;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    pBuf = pDevCtx->pUnitCtx[lun]->pReceiveBuf;

    return pBuf;
}

/**
    ExtCommand Driver Open/Close/Cansel
 **/
/**
 * storage_drvcnt_extcmdOpen
 **/
int storage_drvcnt_extcmdOpen( void )
{
    int  res = GSTORAGE__RES_OK;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    /* 2Openå */
    if(pDevCtx->fd_ext == NULL){
        pDevCtx->fd_ext = filp_open( USB_NODE_EXT_CMD, O_RDWR, 0 );
        if ( IS_ERR( pDevCtx->fd_ext ) ){
            GS_INF( GS_OUT__EXTCOMMAND, "filp_open(fd_ext) error" );
            pDevCtx->fd_ext = NULL;
            res = GSTORAGE__RES_SYS;
        }
    } else {
        GS_INF( GS_OUT__EXTCOMMAND, "extcmd is doubly open" );
    }
    GS_DBG( GS_OUT__EXTCOMMAND, "pDevCtx->fd_ext=%p",pDevCtx->fd_ext );

    return res;
}

/**
 * storage_drvcnt_extcmdClose
 **/
int storage_drvcnt_extcmdClose( void )
{
    int  res = GSTORAGE__RES_OK;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    if(pDevCtx->fd_ext != NULL){
        filp_close( pDevCtx->fd_ext, NULL );
        pDevCtx->fd_ext = NULL;
    } else {
        GS_INF( GS_OUT__EXTCOMMAND, "fd_ext is NULL" );
        res = GSTORAGE__RES_PTR;
    }

    return res;
}

/**
 * storage_drvcnt_extcmdCancel
 **/
int storage_drvcnt_extcmdCancel( void )
{
    int  res = GSTORAGE__RES_OK;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    extcmd_cancel(pDevCtx);

    return res;
}

/**
    Drive Controller 
 **/
/**
 * storage_drvcnt_startDrvCnt
 **/
void storage_drvcnt_startDrvCnt( GSTORAGE__StartCb cb )
{
    GSTORAGE__Msg msg;

    GS_DET( GS_OUT__START, "func Req" );

    msg.start.id = MSG_DRVCNT__START_DRVCNT;
    msg.start.cb = cb;
    drvcnt_sendMsg( &msg, sizeof( msg.start ) );

    return;
}

/**
 * startDrvCnt
 **/
static GSTORAGE__State startDrvCnt( GSTORAGE__Msg *pMsg )
{
    unsigned char    i, unknownMedia = GSTORAGE__OFF;
    GSTORAGE__Status stat = GSTORAGE__SUCCESS;
    GSTORAGE__InfoMediaStatus info = { 0 };

    GS_DET( GS_OUT__START, "func Req" );

    for ( i = 0; i <= pDevCtx->maxLun; i++ ){
        info.lun = i;
        if ( pDevCtx->pUnitCtx[i]->pDrive->drvType == GSTORAGE__DRIVE_ID_DVD ){
            info.status = GSTORAGE__MEDIA_READY;
        }
        else {
            info.status = GSTORAGE__MEDIA_UNKNOWN;
            /* Dolphin8201:Vistaٻ߾֤б driveReset OFF */
            /* pDevCtx->pUnitCtx[i]->driveReset = GSTORAGE__ON; */
        }
        stat = setMediaStatus( &info );
        if ( stat ){
            break;
        }
        setSense( &pDevCtx->pUnitCtx[i]->sense, GSTORAGE_CMD__SK_NO_SENSE );
    }

    for ( i = 0; i <= pDevCtx->maxLun; i++ ){
        if ( pDevCtx->pUnitCtx[i]->media.mediaStatus == GSTORAGE__MEDIA_UNKNOWN ){
            unknownMedia = GSTORAGE__ON;
            break;
        }
    }

    /* ( Main Controller ) CallBack */
    pMsg->start.cb( stat, unknownMedia );

    /* Drive Controller ư֤ */
    return DRVCNT_STATE_ON;
}


/**
    Drive Controller 
 **/
/**
 * storage_drvcnt_stopDrvCnt
 **/
void storage_drvcnt_stopDrvCnt( GSTORAGE__Cb cb )
{
    GSTORAGE__Msg msg;

    GS_DET( GS_OUT__STOP, "func Req" );

//    storage_drvcnt_extcmdCancel();

    msg.cnt.id = MSG_DRVCNT__STOP_DRVCNT;
    msg.cnt.cb = cb;
    drvcnt_sendMsg( &msg, sizeof( msg.cnt ) );

    return;
}

/**
 * stopDrvCnt
 **/
static GSTORAGE__State stopDrvCnt( GSTORAGE__Msg *pMsg )
{
    int              i;
    GSTORAGE__Status stat = GSTORAGE__SUCCESS;
    GSTORAGE__InfoMediaStatus info = { 0 };

    GS_DET( GS_OUT__STOP, "func Req" );

    info.status = GSTORAGE__MEDIA_UNKNOWN;
    for ( i = 0; i <= pDevCtx->maxLun; i++ ){
        info.lun = i;
        stat = setMediaStatus( &info );
    }

    /* ( Main Controller ) CallBack */
    pMsg->cb.cb( stat );

    /* Drive Controller ߽ */
    return DRVCNT_STATE_OFF;
}


/**
    Set Media Status
 **/
/**
 * storage_drvcnt_reqSetMediaStatus
 **/
void storage_drvcnt_reqSetMediaStatus( GSTORAGE__MedStatCb cb, GSTORAGE__InfoMediaStatus *info )
{
    GSTORAGE__Msg msg;

    GS_DET( GS_OUT__MEDIA_STATUS, "func Req" );

    msg.reqMedStat.id     = MSG_DRVCNT__SET_MEDIA_STATUS;
    msg.reqMedStat.cb     = cb;
    msg.reqMedStat.info.lun          = info->lun;
    msg.reqMedStat.info.status       = info->status;
    msg.reqMedStat.info.lastLBA      = info->lastLBA;
    msg.reqMedStat.info.blocks       = info->blocks;
    msg.reqMedStat.info.writeProtect = info->writeProtect;
    msg.reqMedStat.info.mediumType   = info->mediumType;
    memcpy(msg.reqMedStat.info.attr, info->attr, sizeof(msg.reqMedStat.info.attr));

    drvcnt_sendMsg( &msg, sizeof( msg.reqMedStat ) );

    return;
}

/**
 * reqSetMediaStatus
 **/
static GSTORAGE__State reqSetMediaStatus( GSTORAGE__Msg *pMsg )
{
    GSTORAGE__Status stat = GSTORAGE__SUCCESS;
    unsigned char    i, unknownMedia = GSTORAGE__OFF;

    GS_DET( GS_OUT__MEDIA_STATUS, "func Req" );

    if ( pDevCtx->pUnitCtx[pMsg->reqMedStat.info.lun]->pDrive->drvType
                                                != GSTORAGE__DRIVE_ID_DVD ){
        stat = setMediaStatus( &pMsg->reqMedStat.info );
    }

    for ( i = 0; i <= pDevCtx->maxLun; i++ ){
        if ( pDevCtx->pUnitCtx[i]->media.mediaStatus == GSTORAGE__MEDIA_UNKNOWN ){
            unknownMedia = GSTORAGE__ON;
            break;
        }
    }

    if ( pMsg->reqMedStat.cb != NULL ){
        pMsg->reqMedStat.cb( stat, unknownMedia, pMsg->reqMedStat.info.lun );
    }

    return DRVCNT_STATE__NO_CHANGE;
}

/**
 * setMediaStatus
 **/
#include <linux/delay.h>
static GSTORAGE__Status setMediaStatus( GSTORAGE__InfoMediaStatus *info )
{
    GSTORAGE__Status stat = GSTORAGE__SUCCESS;
    unsigned int     lastLba, blockLen;
    struct file      *filp;
#if !defined(BUILD_FOR_UPDATER)
    int policy;
#endif
    int                 lun, status;
    int                 ioctlErr;
    struct block_device *bdev;
    struct inode        *inode = NULL;

    lun = info->lun;
    status = info->status;
    GS_DET( GS_OUT__MEDIA_STATUS, "func Req : lun = %d, status = %d", lun, status );

    switch( status ){
      case GSTORAGE__MEDIA_READY :
        GS_DBG( GS_OUT__MEDIA_STATUS, "set MEDIA_READY" );
        if ( pDevCtx->pUnitCtx[lun]->fd == NULL ){
            if ( pDevCtx->pUnitCtx[lun]->pDrive->drvType == GSTORAGE__DRIVE_ID_DVD ){
                pDevCtx->pUnitCtx[lun]->fd = filp_open( pDevCtx->pUnitCtx[lun]->pDrive->devNode, O_RDWR|O_NONBLOCK, 0 );
            }
#if defined( STORAGE_NAND_NO_MBR )
            else if ( strcmp( pDevCtx->pUnitCtx[lun]->pDrive->devNode, "/dev/nand2" ) == 0 ){
                pDevCtx->pUnitCtx[lun]->fd = filp_open( "/dev/nand", O_RDWR, 0 );
            }
            
#elif defined( STORAGE_MOVINAND_MULTILUN_NO_MBR )
            else if ( strcmp( pDevCtx->pUnitCtx[lun]->pDrive->devNode, GSTORAGE_PARTITION1_DEVICE_NODE_NAME ) == 0 ){
                pDevCtx->pUnitCtx[lun]->fd = filp_open( GSTORAGE_LEADING_PART1_DEVICE_NODE_NAME, O_RDWR, 0 );
            }
            else if ( strcmp( pDevCtx->pUnitCtx[lun]->pDrive->devNode, GSTORAGE_PARTITION2_DEVICE_NODE_NAME ) == 0 ){
                pDevCtx->pUnitCtx[lun]->fd = filp_open( GSTORAGE_LEADING_PART2_DEVICE_NODE_NAME, O_RDWR, 0 );
            }
#endif
            else {
                pDevCtx->pUnitCtx[lun]->fd = filp_open( pDevCtx->pUnitCtx[lun]->pDrive->devNode, O_RDWR, 0 );
                if(-EROFS == PTR_ERR(pDevCtx->pUnitCtx[lun]->fd)){
                    pDevCtx->pUnitCtx[lun]->fd = filp_open( pDevCtx->pUnitCtx[lun]->pDrive->devNode, O_RDONLY, 0 );
                }
            }
            filp = pDevCtx->pUnitCtx[lun]->fd;
        }
        else {
            filp = pDevCtx->pUnitCtx[lun]->fd;
        }

        switch( pDevCtx->pUnitCtx[lun]->pDrive->drvType ){
          /* MS */
          case GSTORAGE__DRIVE_ID_MS :
          case GSTORAGE__DRIVE_ID_MSB :
            if ( info ){
                GS_DBG( GS_OUT__MEDIA_STATUS, " MS: lun=%d, node=%s\n", lun, pDevCtx->pUnitCtx[lun]->pDrive->devNode);
                pDevCtx->pUnitCtx[lun]->media.blockLength  = 0x0200;
                pDevCtx->pUnitCtx[lun]->media.blocks       = info->blocks;
                pDevCtx->pUnitCtx[lun]->media.lastLBA      = info->lastLBA;
                pDevCtx->pUnitCtx[lun]->media.writeProtect = info->writeProtect;
                memcpy( pDevCtx->pUnitCtx[lun]->mediaExt.pMsInfo, info->attr, sizeof( GSTORAGE_DRV__MsInfo ) );
                pDevCtx->pUnitCtx[lun]->media.mediumType = info->mediumType;
                /* set last LBA, block length */
                lastLba  = GSTORAGE_TRANS_ENDIAN( pDevCtx->pUnitCtx[lun]->media.lastLBA );
                blockLen = GSTORAGE_TRANS_ENDIAN( pDevCtx->pUnitCtx[lun]->media.blockLength );
                memcpy( pDevCtx->pUnitCtx[lun]->DatReadCapa.lastLBA, ( signed char * )&lastLba, sizeof( lastLba ) );
                memcpy( pDevCtx->pUnitCtx[lun]->DatReadCapa.blockLen, ( signed char * )&blockLen, sizeof( blockLen ) );
                if ( pDevCtx->pUnitCtx[lun]->media.unitStatus == GSTORAGE__UNIT_EJECT ){
                    if ( pDevCtx->pUnitCtx[lun]->media.mediaStatus != GSTORAGE__MEDIA_UNKNOWN ){
                        pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                    }
                }
                else {
                    if ( ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_NOT_READY ) ||
                         ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_ERROR     ) ){
                        pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                    }
                }
                pDevCtx->pUnitCtx[lun]->media.mediaStatus = status;
                pDevCtx->pUnitCtx[lun]->media.unitStatus  = GSTORAGE__UNIT_NOT_EJECT_START;
                /* set preRead info */
                pDevCtx->pUnitCtx[lun]->preRead.pAccessBuf = pDevCtx->pUnitCtx[lun]->pSendReadBuf[0];
                pDevCtx->pUnitCtx[lun]->preRead.startAddr  = 0x0000000000000000;
                pDevCtx->pUnitCtx[lun]->preRead.nextAddr   = 0x0000000000000000;
                /* set continue info */
                pDevCtx->pUnitCtx[lun]->continueInfo.pProc       = NULL;
                pDevCtx->pUnitCtx[lun]->continueInfo.address     = 0x0000000000000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.remainLen   = 0x00000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.remainLenCdb= 0x00000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.transferLen = 0x00000000;
                pDevCtx->pUnitCtx[lun]->mediaAccess = 0;
            }
            else {
                /* stat == GSTORAGE_ERROR */
                pDevCtx->pUnitCtx[lun]->fd = NULL;
                if ( pDevCtx->pUnitCtx[lun]->media.unitStatus != GSTORAGE__UNIT_EJECT ){
                    if ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_READY ){
                        pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                    }
                }
                pDevCtx->pUnitCtx[lun]->media.mediaStatus = GSTORAGE__MEDIA_ERROR;
                pDevCtx->pUnitCtx[lun]->media.unitStatus  = GSTORAGE__UNIT_NOT_EJECT_START;
            }
            printMediaInfo( pDevCtx->pUnitCtx[lun] );
            break;

          /* IDE(HDD,ATA-NAND) */
          case GSTORAGE__DRIVE_ID_HDD :
          case GSTORAGE__DRIVE_ID_CF :
          case GSTORAGE__DRIVE_ID_NAND :
          case GSTORAGE__DRIVE_ID_MMC :
          case GSTORAGE__DRIVE_ID_SXS :
          case GSTORAGE__DRIVE_ID_SXS_ADPT :
            GS_DBG( GS_OUT__MEDIA_STATUS,
                    " IDE(%d): lun=%d, node=%s\n",
                    pDevCtx->pUnitCtx[lun]->pDrive->drvType, lun,
                    pDevCtx->pUnitCtx[lun]->pDrive->devNode);
            if ( IS_ERR( filp ) ){
                stat = GSTORAGE__ERROR;
                GS_ERR( GS_OUT__INIT_INFO, "open error (IDE)" );
            }
            else {
                if ( !filp->f_dentry ){
                    filp_close( filp, NULL );
                    stat = GSTORAGE__ERROR;
                    GS_ERR( GS_OUT__INIT_INFO, "f_dentry error (IDE)" );
                }
                else {
                    pDevCtx->pUnitCtx[lun]->media.writeProtect = 0;
#if !defined(BUILD_FOR_UPDATER)
                    if(pDevCtx->pUnitCtx[lun]->pDrive->drvType == GSTORAGE__DRIVE_ID_MMC){
                        GS_DBG( GS_OUT__MEDIA_STATUS,
                                " --->MMC: lun=%d, node=%s\n",
                                lun, pDevCtx->pUnitCtx[lun]->pDrive->devNode);
                        pDevCtx->pUnitCtx[lun]->media.writeProtect = info->writeProtect;
                    }
                    else if(pDevCtx->pUnitCtx[lun]->pDrive->drvType == GSTORAGE__DRIVE_ID_SXS) {
                        if((filp->f_mode & 0x80000000) == 0x80000000){
                            pDevCtx->pUnitCtx[lun]->media.writeProtect = 1;
                        }
                        else {
                            pDevCtx->pUnitCtx[lun]->media.writeProtect = 0;
                        }
                    }
                    else if(pDevCtx->pUnitCtx[lun]->pDrive->drvType == GSTORAGE__DRIVE_ID_SXS_ADPT) {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,13)
                        if ( filp->f_op->ioctl ){
#else
                        if ( filp->f_op->unlocked_ioctl ){
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,13)
                            ioctlErr = filp->f_op->ioctl( filp->f_dentry->d_inode, filp, BLKROGET, (unsigned long)&policy );
#else
                            ioctlErr = filp->f_op->unlocked_ioctl( filp, BLKROGET, (unsigned long)&policy );
#endif
                            if ( ioctlErr != 0 ){
                                filp_close( filp, NULL );
                                stat = GSTORAGE__ERROR;
                                GS_INF( GS_OUT__INIT_INFO, "ioctl return error (MS)" );
                            }
                            else {
                                if((policy & 0x00000001) == 0x00000001){
                                    pDevCtx->pUnitCtx[lun]->media.writeProtect = 1;
                                }
                                else {
                                    pDevCtx->pUnitCtx[lun]->media.writeProtect = 0;
                                }
                            }
                        }
                        else {
                            filp_close( filp, NULL );
                            stat = GSTORAGE__ERROR;
                            GS_ERR( GS_OUT__INIT_INFO, "ioctl pointer error (MS)" );
                        }
                    }
                    else {
                        /* nothing to do */
                    }
#endif
                }
            }
            if ( stat == GSTORAGE__SUCCESS ){
                inode = filp->f_mapping->host;
                bdev = I_BDEV(inode);
                pDevCtx->pUnitCtx[lun]->media.blockLength  = pDevCtx->pUnitCtx[lun]->pDrive->blockLength;

#if defined( STORAGE_NAND_NO_MBR )
                if ( strcmp( pDevCtx->pUnitCtx[lun]->pDrive->devNode, "/dev/nand2" ) == 0 ){
                    pDevCtx->pUnitCtx[lun]->media.blocks = NAND2_BLOCKS;
                    GS_INF( GS_OUT__MEDIA_STATUS, "Size = %8X", pDevCtx->pUnitCtx[lun]->media.blocks );
                }
                else {
                    pDevCtx->pUnitCtx[lun]->media.blocks
                        = ( unsigned int )( bdev->bd_inode->i_size >> 9 );
                }
#elif defined( STORAGE_MOVINAND_MULTILUN_NO_MBR )
                if ( strcmp( pDevCtx->pUnitCtx[lun]->pDrive->devNode, GSTORAGE_PARTITION1_DEVICE_NODE_NAME ) == 0 ){
                    pDevCtx->pUnitCtx[lun]->media.blocks = GSTORAGE_PARTITION1_BLOCKSZ;
                    // GS_INF( GS_OUT__MEDIA_STATUS, "Size = %8X", pDevCtx->pUnitCtx[lun]->media.blocks );
                }else if ( strcmp( pDevCtx->pUnitCtx[lun]->pDrive->devNode, GSTORAGE_PARTITION2_DEVICE_NODE_NAME ) == 0 ){
                    pDevCtx->pUnitCtx[lun]->media.blocks = GSTORAGE_PARTITION2_BLOCKSZ;
                    // GS_INF( GS_OUT__MEDIA_STATUS, "Size = %8X", pDevCtx->pUnitCtx[lun]->media.blocks );
                }else {
                    pDevCtx->pUnitCtx[lun]->media.blocks
                        = ( unsigned int )( bdev->bd_inode->i_size >> 9 );
                }
#else
                if(pDevCtx->pUnitCtx[lun]->pDrive->drvType == GSTORAGE__DRIVE_ID_SXS){
                    pDevCtx->pUnitCtx[lun]->media.blocks
                         = ( unsigned int )(filp->f_dentry->d_inode->i_mapping->host->i_size / pDevCtx->pUnitCtx[lun]->media.blockLength);
                }
                else {
                    pDevCtx->pUnitCtx[lun]->media.blocks
                         = ( unsigned int )(bdev->bd_inode->i_size / pDevCtx->pUnitCtx[lun]->media.blockLength);
                }
#endif

                pDevCtx->pUnitCtx[lun]->media.lastLBA = pDevCtx->pUnitCtx[lun]->media.blocks - 1;
                pDevCtx->pUnitCtx[lun]->media.mediumType   = 0;
                /* set last LBA, block length */
                lastLba  = GSTORAGE_TRANS_ENDIAN( pDevCtx->pUnitCtx[lun]->media.lastLBA );
                blockLen = GSTORAGE_TRANS_ENDIAN( pDevCtx->pUnitCtx[lun]->media.blockLength );
                memcpy( pDevCtx->pUnitCtx[lun]->DatReadCapa.lastLBA, ( signed char * )&lastLba, sizeof( lastLba ) );
                memcpy( pDevCtx->pUnitCtx[lun]->DatReadCapa.blockLen, ( signed char * )&blockLen, sizeof( blockLen ) );
                if ( pDevCtx->pUnitCtx[lun]->media.unitStatus == GSTORAGE__UNIT_EJECT ){
                    if ( pDevCtx->pUnitCtx[lun]->media.mediaStatus != GSTORAGE__MEDIA_UNKNOWN ){
                        pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                    }
                }
                else {
                    if ( ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_NOT_READY ) ||
                         ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_ERROR     ) ){
                        pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                    }
                }
                pDevCtx->pUnitCtx[lun]->media.mediaStatus = status;
                pDevCtx->pUnitCtx[lun]->media.unitStatus  = GSTORAGE__UNIT_NOT_EJECT_START;
                /* set preRead info */
                pDevCtx->pUnitCtx[lun]->preRead.pAccessBuf = pDevCtx->pUnitCtx[lun]->pSendReadBuf[0];
                pDevCtx->pUnitCtx[lun]->preRead.startAddr  = 0x0000000000000000;
                pDevCtx->pUnitCtx[lun]->preRead.nextAddr   = 0x0000000000000000;
                /* set continue info */
                pDevCtx->pUnitCtx[lun]->continueInfo.pProc       = NULL;
                pDevCtx->pUnitCtx[lun]->continueInfo.address     = 0x0000000000000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.remainLen   = 0x00000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.remainLenCdb= 0x00000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.transferLen = 0x00000000;
            }
            else {
                pDevCtx->pUnitCtx[lun]->fd = NULL;
                if ( pDevCtx->pUnitCtx[lun]->media.unitStatus != GSTORAGE__UNIT_EJECT ){
                    if ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_READY ){
                        pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                    }
                }
                pDevCtx->pUnitCtx[lun]->media.mediaStatus = GSTORAGE__MEDIA_ERROR;
                pDevCtx->pUnitCtx[lun]->media.unitStatus  = GSTORAGE__UNIT_NOT_EJECT_START;
            }
            printMediaInfo( pDevCtx->pUnitCtx[lun] );
            break;

          /* DVD */
          case GSTORAGE__DRIVE_ID_DVD :
            GS_DBG( GS_OUT__MEDIA_STATUS,
                    " DVD: lun=%d, node=%s\n",
                    lun, pDevCtx->pUnitCtx[lun]->pDrive->devNode);
            if ( !IS_ERR( filp ) ){
                atapi_dvd_reset( filp );
                atapi_dvd_set_dma( filp );
                if ( pDevCtx->pUnitCtx[lun]->pDrive->forceWP ){
                    atapi_dvd_set_write_protect( pDevCtx->pUnitCtx[lun]->pDrive->forceWP, filp );
                }
                /* set continue info */
                pDevCtx->pUnitCtx[lun]->continueInfo.pProc       = NULL;
                pDevCtx->pUnitCtx[lun]->continueInfo.address     = 0x0000000000000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.remainLen   = 0x00000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.remainLenCdb= 0x00000000;
                pDevCtx->pUnitCtx[lun]->continueInfo.transferLen = 0x00000000;
            }
            else {
                stat = GSTORAGE__ERROR;
                GS_INF( GS_OUT__INIT_INFO, "open error (DVD)" );
                pDevCtx->pUnitCtx[lun]->fd = NULL;
            }
            pDevCtx->pUnitCtx[lun]->media.mediaStatus = status;
            break;

          /* ̤бǥ̾Ф̤ʤ*/
          default :
            GS_ERR( GS_OUT__INIT_INFO, "non supported media" );
            break;
        }
        break;

      case GSTORAGE__MEDIA_NOT_READY :
      case GSTORAGE__MEDIA_ERROR :
        switch( pDevCtx->pUnitCtx[lun]->pDrive->drvType ){
          case GSTORAGE__DRIVE_ID_HDD :
          case GSTORAGE__DRIVE_ID_CF :
            /* Standby Immediate */
            storage_ata_standbyImmediate( pDevCtx->pUnitCtx[lun]->fd );
            break;
          default :
            break;
        }
        GS_DBG( GS_OUT__MEDIA_STATUS, "set MEDIA_NOT_READY/MEDIA_ERROR" );
        if ( pDevCtx->pUnitCtx[lun]->fd != NULL ){
            GS_DBG( GS_OUT__MEDIA_STATUS, "close fd = %p" , pDevCtx->pUnitCtx[lun]->fd );
            filp_close( pDevCtx->pUnitCtx[lun]->fd, NULL );
        }

        switch( pDevCtx->pUnitCtx[lun]->pDrive->drvType ){
          /* MS,IDE(HDD,ATA-NAND) */
          case GSTORAGE__DRIVE_ID_MS :
          case GSTORAGE__DRIVE_ID_MSB :
          case GSTORAGE__DRIVE_ID_HDD :
          case GSTORAGE__DRIVE_ID_CF :
          case GSTORAGE__DRIVE_ID_NAND :
          case GSTORAGE__DRIVE_ID_MMC :
          case GSTORAGE__DRIVE_ID_SXS :
          case GSTORAGE__DRIVE_ID_SXS_ADPT :
            pDevCtx->pUnitCtx[lun]->fd = NULL;
            if ( pDevCtx->pUnitCtx[lun]->media.unitStatus != GSTORAGE__UNIT_EJECT ){
                if ( pDevCtx->pUnitCtx[lun]->media.mediaStatus == GSTORAGE__MEDIA_READY ){
                    pDevCtx->pUnitCtx[lun]->media.changed = GSTORAGE__ON;
                }
            }
            pDevCtx->pUnitCtx[lun]->media.mediaStatus = status;
            break;
          /* DVD ξ setMediaStatus(NOT_READY,ERROR) νϹԤʤ */
          case GSTORAGE__DRIVE_ID_DVD :
            break;
          /* ̤бǥ̾Ф̤ʤ*/
          default :
            GS_ERR( GS_OUT__INIT_INFO, "non supported media" );
            break;
        }
        break;

      case GSTORAGE__MEDIA_UNKNOWN :
        if ( pDevCtx->pUnitCtx[lun]->pDrive->flushEnable ) {
            switch( pDevCtx->pUnitCtx[lun]->pDrive->drvType ){
              case GSTORAGE__DRIVE_ID_HDD :
              case GSTORAGE__DRIVE_ID_CF :
                /* Flush Cache */
                storage_ata_flushCache( pDevCtx->pUnitCtx[lun]->fd );
                /* Standby Immediate */
                storage_ata_standbyImmediate( pDevCtx->pUnitCtx[lun]->fd );
                break;
              case GSTORAGE__DRIVE_ID_DVD :
                /* Synchronize Cache */
                atapi_dvd_synchronize_cache( pDevCtx->pUnitCtx[lun]->fd );
                break;
              default :
                break;
            }
        }
        GS_DBG( GS_OUT__MEDIA_STATUS, "set MEDIA_UNKNOWN" );
        if ( pDevCtx->pUnitCtx[lun]->fd != NULL ){
            GS_DBG( GS_OUT__MEDIA_STATUS, "close fd = %p" , pDevCtx->pUnitCtx[lun]->fd );
            filp_close( pDevCtx->pUnitCtx[lun]->fd, NULL );
        }
        pDevCtx->pUnitCtx[lun]->fd = NULL;

        switch( pDevCtx->pUnitCtx[lun]->pDrive->drvType ){
          /* MS,IDE(HDD,ATA-NAND),DVD */
          case GSTORAGE__DRIVE_ID_MS :
          case GSTORAGE__DRIVE_ID_MSB :
          case GSTORAGE__DRIVE_ID_HDD :
          case GSTORAGE__DRIVE_ID_CF :
          case GSTORAGE__DRIVE_ID_DVD :
          case GSTORAGE__DRIVE_ID_NAND :
          case GSTORAGE__DRIVE_ID_MMC :
          case GSTORAGE__DRIVE_ID_SXS :
          case GSTORAGE__DRIVE_ID_SXS_ADPT :
            pDevCtx->pUnitCtx[lun]->media.mediaStatus = status;
            break;
          /* ̤бǥ̾Ф̤ʤ*/
          default :
            GS_ERR( GS_OUT__INIT_INFO, "non supported media" );
            break;
        }
        break;
    }

    GS_DBG( GS_OUT__MEDIA_STATUS, "media.changed = %d, media.mediaStatus = %d, media.unitStatus = %d",
            pDevCtx->pUnitCtx[lun]->media.changed, pDevCtx->pUnitCtx[lun]->media.mediaStatus, pDevCtx->pUnitCtx[lun]->media.unitStatus );

    return stat;
}


/**
    Check Media Access
 **/
/**
 * storage_drvcnt_checkMediaAccess
 **/
void storage_drvcnt_checkMediaAccess( unsigned char *pMediaAccess )
{
    int           i, mediaAccess = 0;
    unsigned long flags;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    /* ¾ */
    spin_lock_irqsave( &pStorageDrvCnt->lock, flags );

    /* Media Access Status Υԡꥢ */
    for ( i = 0; i <= pDevCtx->maxLun; i++ ){
        mediaAccess |= ( pDevCtx->pUnitCtx[i]->mediaAccess << i );
        pDevCtx->pUnitCtx[i]->mediaAccess = 0;
    }
    *pMediaAccess = mediaAccess;

    /* ޤ¾ */
    spin_unlock_irqrestore( &pStorageDrvCnt->lock, flags );

    return;
}

/**
 * storage_drvcnt_waitMediaAccess
 **/
int storage_drvcnt_waitMediaAccess(void)
{
    int ret = 0;
    
    ret = wait_event_interruptible( access_q, msc_access != DRVCNT_ACCESS_STATE_OFF);
    msc_access = DRVCNT_ACCESS_STATE_OFF;
    
    return ret;
    
}

/**
 * storage_drvcnt_setMediaAccess
 **/
void storage_drvcnt_setMediaAccess( GSTORAGE_DRV__UnitContext *pUnitCtx )
{
    unsigned long flags;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    msc_access = DRVCNT_ACCESS_STATE_ON;
    wake_up_interruptible(&access_q);

    /* ¾ */
    spin_lock_irqsave( &pStorageDrvCnt->lock, flags );

    pUnitCtx->mediaAccess = 1;

    /* ޤ¾ */
    spin_unlock_irqrestore( &pStorageDrvCnt->lock, flags );

    return;
}

/**
    PACKETޥ
 **/
/**
 * storage_drvcnt_sndCmdPacket
 **/
void storage_drvcnt_sndCmdPacket( GSTORAGE__PacketCb cb, GSTORAGE__Packet *pPckt )
{
    GSTORAGE__Msg msg;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    msg.pckt.id   = MSG_DRVCNT__SND_CMD;
    msg.pckt.cb   = cb;
    msg.pckt.pckt = *pPckt;
    drvcnt_sendMsg( &msg, sizeof( msg.pckt ) );

    return;
}

/**
 * drvcnt_sndCmdPacket
 **/
static GSTORAGE__State drvcnt_sndCmdPacket( GSTORAGE__Msg *pMsg )
{
    GSTORAGE__Status stat;
    GSTORAGE__Status ret;
    unsigned char    curLun;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    /* CmdCtx  */
    curLun = pMsg->pckt.pckt.pCbw->cbwLun;
    pDevCtx->pCmdCtx->pUnitCtx      = pDevCtx->pUnitCtx[curLun];
    pDevCtx->pCmdCtx->pCbw          = pMsg->pckt.pckt.pCbw;
    pDevCtx->pCmdCtx->pCdb          = pMsg->pckt.pckt.pCdb;
    pDevCtx->pCmdCtx->cdbLength     = pMsg->pckt.pckt.cdbLength;
    pDevCtx->pCmdCtx->dio           = pMsg->pckt.pckt.dio;
    pDevCtx->pCmdCtx->expectDatLen  = pMsg->pckt.pckt.bufLength;
    pDevCtx->pCmdCtx->pData         = pDevCtx->pCmdCtx->pUnitCtx->pSendBuf;
    pDevCtx->pCmdCtx->status        = 0;
    pDevCtx->pCmdCtx->totalTransLen = 0;
    pDevCtx->pCmdCtx->cb            = NULL;
    pDevCtx->pCmdCtx->pProcParam    = NULL;

    printCmdCtx( pDevCtx->pCmdCtx );

    /* stat   GSTORAGE__SUCCESS: / GSTORAGE__ERROR:۾ȯ */
    stat = storage_cmd_cmdPacket( pDevCtx->pCmdCtx );

    GS_DBG( GS_OUT__DRVCNT, "stat=%d, residue=%d, expectDatLen=%d, totalTransLen=%d, status=%d, pData=%p",
            stat, pDevCtx->pCmdCtx->expectDatLen - pDevCtx->pCmdCtx->totalTransLen, pDevCtx->pCmdCtx->expectDatLen,
        pDevCtx->pCmdCtx->totalTransLen, pDevCtx->pCmdCtx->status, pDevCtx->pCmdCtx->pData );

    /* CallBack :: stat Ͼ( Controller )ؤΤޤ֤ƾ̤Ƚ */
    pMsg->pckt.cb( stat,
                   pDevCtx->pCmdCtx->expectDatLen - pDevCtx->pCmdCtx->totalTransLen,
                   pDevCtx->pCmdCtx->status,
                   ( unsigned int * )pDevCtx->pCmdCtx->pData );

    /* ɤȽ */
    if ( pDevCtx->pCmdCtx->cb != NULL ){
        ret = pDevCtx->pCmdCtx->cb( pDevCtx->pCmdCtx->pProcParam );
    }

    /* ܤʤ(ߤξ֤Τޤ) */
    return DRVCNT_STATE__NO_CHANGE;
}

/**
 * storage_drvcnt_sndCmdContinue
 **/
void storage_drvcnt_sndCmdContinue( GSTORAGE__PacketCb cb )
{
    GSTORAGE__Msg msg;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    msg.cmdContinue.id = MSG_DRVCNT__SND_CMD_CONTINUE;
    msg.cmdContinue.cb = cb;
    drvcnt_sendMsg( &msg, sizeof( msg.cmdContinue ) );

    return;
}

/**
 * drvcnt_sndCmdContinue
 **/
static GSTORAGE__State drvcnt_sndCmdContinue( GSTORAGE__Msg *pMsg )
{
    GSTORAGE__Status stat;
    GSTORAGE__Status ret;

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    printCmdCtx( pDevCtx->pCmdCtx );

    /* stat   GSTORAGE__SUCCESS: / GSTORAGE__ERROR:۾ȯ */
    stat = storage_cmd_cmdContinue( pDevCtx->pCmdCtx );

    GS_DBG( GS_OUT__DRVCNT, "stat=%d, residue=%8X, expectDatLen=%8X, totalTransLen=%8X, status=%d, pData=%p",
            stat, pDevCtx->pCmdCtx->expectDatLen - pDevCtx->pCmdCtx->totalTransLen, pDevCtx->pCmdCtx->expectDatLen,
            pDevCtx->pCmdCtx->totalTransLen, pDevCtx->pCmdCtx->status, pDevCtx->pCmdCtx->pData );

    /* CallBack :: stat Ͼ( Controller )ؤΤޤ֤ƾ̤Ƚ */
    pMsg->cmdContinue.cb( stat,
                          pDevCtx->pCmdCtx->expectDatLen - pDevCtx->pCmdCtx->totalTransLen,
                          pDevCtx->pCmdCtx->status,
                          ( unsigned int * )pDevCtx->pCmdCtx->pData );

    /* ɤȽ */
    if ( pDevCtx->pCmdCtx->cb ){
        ret = pDevCtx->pCmdCtx->cb( pDevCtx->pCmdCtx->pProcParam );
    }

    /* ܤʤ(ߤξ֤Τޤ) */
    return DRVCNT_STATE__NO_CHANGE;
}


/**
    ååɴϢ
 **/
/**
 * storage_drvcnt_allocThread
 *
 * סDrive Controller ݽ
 **/
int storage_drvcnt_allocThread( void )
{
    int err = GSTORAGE__SUCCESS;
    int pid = 0;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 3, 0)
    struct task_struct *tsk;
#endif

    GS_DET( GS_OUT__DRVCNT, "func Req" );

    /* create message buffer */
    if ( !( pMbf = cre_mbf( sizeof( GSTORAGE__Msg ) + 4, MSG_DRVCNT_MAX_NUM ) ) ){
        err = GSTORAGE__ERROR;
        GS_ERR( GS_OUT__PROBE, "cre_mbf() error" );
    }

    if ( !err ){
        /* create & init thread information */
        if ( !( pStorageDrvCnt = kmalloc( sizeof( GSTORAGE__Thread ), GFP_ATOMIC ) ) ){
            del_mbf( pMbf );
            pMbf = NULL;
            err = GSTORAGE__ERROR;
            GS_ERR( GS_OUT__PROBE, "kmalloc(pStorageDrvCnt) error" );
        }
        else {
            memset( pStorageDrvCnt,  0, sizeof( GSTORAGE__Thread ) );
            init_waitqueue_head( &pStorageDrvCnt->wqh );
            spin_lock_init( &pStorageDrvCnt->lock );
            pStorageDrvCnt->end = 0;
        }
    }

    /* initialize media access variables */
    msc_access = DRVCNT_ACCESS_STATE_OFF;
    init_waitqueue_head(&access_q);

    if ( !err ){
        /* create & start thread */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 3, 0)
        tsk = kthread_run(drvcnt_threadFunc, pStorageDrvCnt, "drvcnt_threadFunc");
        if (IS_ERR(tsk)) {
            storage_drvcnt_freeThread();
            err = GSTORAGE__ERROR;
            GS_ERR( GS_OUT__PROBE, "kthread_run() error (%p)", tsk );
        }
        else
            pid = tsk->pid;
#else
        if ( ( pid = kernel_thread( drvcnt_threadFunc, pStorageDrvCnt,
                                   (CLONE_VM | CLONE_FS | CLONE_FILES) ) ) < 0 ){
            storage_drvcnt_freeThread();
            err = GSTORAGE__ERROR;
            GS_ERR( GS_OUT__PROBE, "kernel_thread() error" );
        }
#endif
    }
    GS_DET( GS_OUT__DAEMONIZE, "drvcnt_threadFunc pid = %d", pid );

    return err;
}

/**
 * storage_drvcnt_freeThread
 *
 * סDrive Controller 
 **/
void storage_drvcnt_freeThread( void )
{
    GS_DET( GS_OUT__REMOVE, "func Req" );

    if ( pStorageDrvCnt ){
        kfree( pStorageDrvCnt );
        pStorageDrvCnt = NULL;
    }
    if ( pMbf ){
        del_mbf( pMbf );
        pMbf = NULL;
    }

    return;
}

/**
 * drvcnt_sendMsg
 *
 * סDrive Controller ؤΥå
 **/
static void drvcnt_sendMsg( GSTORAGE__Msg *pMsg, int msgSize )
{
    GS_DET( GS_OUT__MBF, "func Req" );

    if ( snd_mbf( pMbf, pMsg, msgSize ) ){
        GS_ERR( GS_OUT__MBF, "snd_mbf()" );
    }

    return;
}

/**
 * void drvcnt_threadFunc( void *pStorageDrvcnt_ )
 **/
static int drvcnt_threadFunc( void *pStorageDrvCnt_ )
{
    GSTORAGE__Msg   msg;
    int             msgSize;
    GSTORAGE__State currentState = DRVCNT_STATE_OFF;
    GSTORAGE__State nextState;

    pStorageDrvCnt = ( GSTORAGE__Thread * )pStorageDrvCnt_;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 3, 0)
#else
    daemonize( "drvcnt_threadFunc" );
#endif

    while ( 1 ) {
        /* receive Message */
        do {
            msgSize = rcv_mbf( pMbf, &msg );
        } while( msgSize  == 0 );
        if ( msgSize < 0 ){
            GS_ERR( GS_OUT__DRVCNT, "rcv_mbf()" );
            return 0;
        }
        /* ؿ¹ */
        nextState = storage_execFunc( &msg, currentState,
                                      spStorageMsgTbl_DrvCnt );
        /* ξ֤ */
        currentState = nextState;

        /* λåɲ  Linux Ǥ thread λɬͭ */
        if ( pStorageDrvCnt->end ){
            msg.cb.cb( GSTORAGE__SUCCESS );
            break;
        }
    }

    return 0;
}


/**
    ǥХåϢ
 **/
/**
 * printDevCtx
 **/
void printDevCtx( void )
{
    int i, j;
    char *pInquiryData;

    GS_DBG( GS_OUT__CTX, "CTX : pDevCtx                             = %p", pDevCtx );
    GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->maxLun                     = %d" , pDevCtx->maxLun );
    for ( i = 0; i <= pDevCtx->maxLun; i++ ){
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]                         = %p", i, pDevCtx->pUnitCtx[i] );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDevCtx                = %p", i, pDevCtx->pUnitCtx[i]->pDevCtx );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pSendBuf               = %p", i, pDevCtx->pUnitCtx[i]->pSendBuf );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pReceiveBuf            = %p", i, pDevCtx->pUnitCtx[i]->pReceiveBuf );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pSendReadBuf[ 0 ]      = %p", i, pDevCtx->pUnitCtx[i]->pSendReadBuf[ 0 ] );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pSendReadBuf[ 1 ]      = %p", i, pDevCtx->pUnitCtx[i]->pSendReadBuf[ 1 ] );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive                 = %p", i, pDevCtx->pUnitCtx[i]->pDrive );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->devNode        = %s" , i, (char *)pDevCtx->pUnitCtx[i]->pDrive->devNode );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->drvType        = %d" , i, pDevCtx->pUnitCtx[i]->pDrive->drvType );
        pInquiryData = pDevCtx->pUnitCtx[i]->pDrive->pInquiryData;
        for ( j = 0; j < pDevCtx->pUnitCtx[i]->pDrive->inquiryDataLen; j++ ){
            GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->pInquiryData[%d] = %2X",
                                                                                                 i, j, (int)*pDevCtx->pUnitCtx[i]->pDrive->pInquiryData );
            pInquiryData++;
        }
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->inquiryDataLen = %d" , i, (int)pDevCtx->pUnitCtx[i]->pDrive->inquiryDataLen );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->blockNum       = %d" , i, (int)pDevCtx->pUnitCtx[i]->pDrive->blockNum );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->blockLength    = %d" , i, (int)pDevCtx->pUnitCtx[i]->pDrive->blockLength );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->pDrive->forceWP        = %d" , i, pDevCtx->pUnitCtx[i]->pDrive->forceWP );
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pUnitCtx[%d]->fd                     = %p", i, pDevCtx->pUnitCtx[i]->fd );
        printMediaInfo( pDevCtx->pUnitCtx[i] );
    }
    GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pCmdCtx                    = %p", pDevCtx->pCmdCtx );
    GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->extCmdNum                  = %d", pDevCtx->extCmdNum );
    for ( i = 0; i < pDevCtx->extCmdNum; i++ ){
        GS_DBG( GS_OUT__CTX, "CTX : pDevCtx->pExtCmd[%d]->opCode         = 0x%02X", i, pDevCtx->pExtCmd[i]->opCode );
    }

    return;
}

/**
 * printCmdCtx
 **/
void printCmdCtx( GSTORAGE_DRV__CmdContext *pCmdCtx )
{
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx                = %p", pCmdCtx );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->pUnitCtx      = %p", pCmdCtx->pUnitCtx );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->pCbw          = %p", pCmdCtx->pCbw );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->pCdb          = %p", pCmdCtx->pCdb );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->cdbLength     = %8X", pCmdCtx->cdbLength );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->dio           = %d" , pCmdCtx->dio );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->expectDatLen  = %8X", pCmdCtx->expectDatLen );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->pData         = %p", pCmdCtx->pData );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->status        = %d" , pCmdCtx->status );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->totalTransLen = %8X", pCmdCtx->totalTransLen );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->cb            = %p", pCmdCtx->cb );
    GS_DBG( GS_OUT__CTX, "CTX : pCmdCtx->pProcParam    = %p", pCmdCtx->pProcParam );

    return;
}

/**
 * printMediaInfo
 **/
void printMediaInfo( GSTORAGE_DRV__UnitContext *pUnitCtx )
{
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.blockLength     = %d", pUnitCtx->media.blockLength );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.blocks          = %d", pUnitCtx->media.blocks );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.lastLBA         = %d", pUnitCtx->media.lastLBA );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.writeProtect    = %d", pUnitCtx->media.writeProtect );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.mediumType      = %d", pUnitCtx->media.mediumType );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.mediaStatus     = %d", pUnitCtx->media.mediaStatus );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.unitStatus      = %d", pUnitCtx->media.unitStatus );
    GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.changed         = %d", pUnitCtx->media.changed );
    if ( pUnitCtx->pDrive->drvType == GSTORAGE__DRIVE_ID_MS
         || pUnitCtx->pDrive->drvType == GSTORAGE__DRIVE_ID_MSB ){
        GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.pMsInfo         = %p", pUnitCtx->mediaExt.pMsInfo );
    }
    else {
        GS_DBG( GS_OUT__CTX, "CTX : pUnitCtx->media.pExt            = %p", pUnitCtx->mediaExt.pExt );
    }

    return;
}

