// SPDX-License-Identifier: GPL-2.0
/* 2019-06-27: File changed by Sony Corporation */
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/utsname.h>

#ifdef CONFIG_SNSC
extern int __init nlver_init(void);
#endif

static int version_proc_show(struct seq_file *m, void *v)
{
	seq_printf(m, linux_proc_banner,
		utsname()->sysname,
		utsname()->release,
		utsname()->version);
	return 0;
}

static int __init proc_version_init(void)
{

#ifdef CONFIG_SNSC
        /* NSC Linux version */
        nlver_init();
#endif
	proc_create_single("version", 0, NULL, version_proc_show);
	return 0;
}
fs_initcall(proc_version_init);
