/*
 *  linux/dmac.h
 *
 *  Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef __LINUX_DMAC_H
#define __LINUX_DMAC_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* ---------------------------------
	ioctl
--------------------------------- */
#define DMA_MEM_TRANSFER      0x00000001

struct dma_request{
	uint32_t ch;
	uint32_t size;
	uint64_t src;
	uint64_t dst;
};


/* ---------------------------------
	Kernel API
--------------------------------- */
#if defined(__KERNEL__) || !defined(TARGET_APP_USERSPACE)

struct peri_config {
	union {
		struct {
			uint8_t direction;
			uint8_t peripheral_id;
			uint8_t brst_size;
			uint8_t brst_len;
			uint8_t src_inc;
			uint8_t dst_inc;
			uint8_t __1; /* reserved */
			uint8_t __2; /* reserved */
		};
		uint64_t data;
	};
};

#define DMA_PERI_AUTO_WIDTH 0xFF

struct dma_private_t {
	void *dummy1[2];
	uint32_t dummy2;
};

struct dma_request_async {
	uint32_t ch;
	uint32_t size;
	uint64_t src;
	uint64_t dst;
	struct peri_config pconf;
	void (*callback)(int err, void *cookies);
	void *cookies;

	/* driver internal use */
#ifdef __CXD_DMA_INTERNAL_H
	struct __dma_private_t drv;
#else
	struct dma_private_t driver;
#endif
};

enum dmac_transfer_type_t {
	DMA_TRANS_TYPE_MEM2PERI = 1,
	DMA_TRANS_TYPE_PERI2MEM,
	DMA_TRANS_TYPE_MAX
};

extern int dma_mem_transfer_async(struct dma_request_async *param);
extern int dma_peri_transfer_async(struct dma_request_async *param);
extern int dma_reset_channel(uint32_t ch);
#endif /* __KERNEL__ || !TARGET_APP_USERSPACE */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __LINUX_DMAC_H */
