/*
 * include/linux/gpio/gpio.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef __GPIO_H__
#define __GPIO_H__

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/
// define
/*--------------------------------------------------------------------------*/
#define GPIOMODE_GPIO                   (0x00000001U)
#define GPIOMODE_PERIPHERAL             (0x00000002U)
#define GPIOMODE_PERIPHERAL2            (0x00000100U)
#define GPIOMODE_PERIPHERAL3            (0x00000200U)

#define GPIOMODE_INPUT                  (0x00000004U)
#define GPIOMODE_OUTPUT_H               (0x00000008U)
#define GPIOMODE_OUTPUT_L               (0x00000010U)

#define GPIO_CMD_READ                   (0xC0104700U)
#define GPIO_CMD_WRITE                  (0xC0104701U)
#define GPIO_CMD_SET_MODE               (0xC0104702U)
#define GPIO_CMD_GET_MODE               (0xC0104703U)

/* GPIO-A */
#define GPIO_PORT_0                     0x00U
#define GPIO_PORT_1                     0x01U
#define GPIO_PORT_2                     0x02U
#define GPIO_PORT_3                     0x03U
#define GPIO_PORT_4                     0x04U
#define GPIO_PORT_5                     0x05U
#define GPIO_PORT_6                     0x06U
#define GPIO_PORT_7                     0x07U
#define GPIO_PORT_8                     0x08U
#define GPIO_PORT_9                     0x09U
#define GPIO_PORT_10                    0x0AU
#define GPIO_PORT_11                    0x0BU
#define GPIO_PORT_12                    0x0CU
#define GPIO_PORT_13                    0x0DU
#define GPIO_PORT_14                    0x0EU
/* GPIO-B */
#define GPIO_PORT_64                    0x40U
#define GPIO_PORT_65                    0x41U
#define GPIO_PORT_66                    0x42U
#define GPIO_PORT_67                    0x43U
#define GPIO_PORT_68                    0x44U
#define GPIO_PORT_69                    0x45U
#define GPIO_PORT_70                    0x46U
#define GPIO_PORT_71                    0x47U
#define GPIO_PORT_72                    0x48U
#define GPIO_PORT_73                    0x49U
#define GPIO_PORT_74                    0x4AU

#define GPIO_PORT_MAX                   0x4BU

typedef enum gpio_portctrl
{
    GPIO_CTRL_BIT = 0,
    GPIO_CTRL_PORT,
}GPIO_PORTCTRL;

/*--------------------------------------------------------------------------*/
// struct
/*--------------------------------------------------------------------------*/
typedef struct gpio_ioctl_port
{
    GPIO_PORTCTRL       portctl;                            /**< port contrl flag(BIT/PORT) */
    unsigned char       portid;                             /**< Port number */
    union{
        unsigned char   bitnum;                             /**< bit number */
        unsigned int    bitmask;                            /**< bitmask */
    };
    unsigned int value;                                     /**< set/get value */
}GPIO_PORT;


#ifdef __KERNEL__
/* kernel-API */
extern int gpio_get_data_bit(unsigned char port, unsigned int bit, unsigned int* data);
extern int gpio_get_data_port(unsigned char port, unsigned int bitmask, unsigned int* data );
extern int gpio_set_data_bit(unsigned char port, unsigned int bit, unsigned int data);
extern int gpio_set_data_port(unsigned char port, unsigned int bitmask, unsigned int data);
extern int gpio_set_mode_bit(unsigned char port, unsigned int bit, unsigned int mode);
extern int gpio_set_mode_port(unsigned char port, unsigned int bitmask, unsigned int mode);
extern int gpio_get_mode_bit(unsigned char port, unsigned int bit, unsigned int* mode);
#endif /* __KERNEL__ */

#ifdef __cplusplus
}
#endif

#endif /*__GPIO_H__*/
