/*
 * include/linux/pcidma.h
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __INCLUDE_PCIDMA_H__
#define __INCLUDE_PCIDMA_H__

#ifdef __cplusplus
extern "C" {
#endif

enum {
	PCIDMA_PCIE0 = 0,
	PCIDMA_PCIE1,
	PCIDMA_PCIE2,
	PCIDMA_PCIE3,
	PCIDMA_PCIE4,
	PCIDMA_PCIE_MAX
};

/* aliases */
#define PCIDMA_PCIE_N	PCIDMA_PCIE0
#define PCIDMA_PCIE_M0	PCIDMA_PCIE1
#define PCIDMA_PCIE_M1	PCIDMA_PCIE2
#define PCIDMA_PCIE_C	PCIDMA_PCIE3
#define PCIDMA_PCIE_F	PCIDMA_PCIE4

#ifndef PCIE_DWC_H
enum {
	PCIDMA_CH0 = 0,
	PCIDMA_CH1,
	PCIDMA_CH2,
	PCIDMA_CH3,
	PCIDMA_CH4,
	PCIDMA_CH5,
	PCIDMA_CH6,
	PCIDMA_CH7,
	PCIDMA_CH_MAX
};

enum {
	PCIDMA_RD = 0,
	PCIDMA_WR
};
#endif /* !PCIE_DWC_H */

/*
 *  IOCTL
 */
#include  <linux/ioctl.h>

#define PCIDMA_TRANSFER	_IOW('P', 1, struct pcidma_param)

#ifndef PCIE_DWC_H
struct pcidma_param {
	uint8_t pcie_ch;
	uint8_t dmac_ch;
	uint8_t dir;
	uint8_t pad[1];

	uint32_t size;
	uint64_t src;
	uint64_t dst;
};
#endif /* PCIE_DWC_H */

#if defined(__KERNEL__)
/*
 *  Kernel API
 */
struct pcidma_private_t {
	void *dummy1[2];
	uint32_t dummy2;
};

struct pcidma_request {
	uint8_t pcie_ch;
	uint8_t dmac_ch;
	uint8_t dir;
	uint8_t pad[1];

	uint32_t size; /* 0 means LL mode */
	uint64_t src;  /* in LL mode, phys addr of LL */
	uint64_t dst;  /* not used in LL mode */

	void (*callback)(int err, void *cookies);
	void *cookies;

	/* driver internal use */
#ifdef __CXD_PCIDMA_INTERNAL_H
	struct __pcidma_private_t drv;
#else
	struct pcidma_private_t driver;
#endif
};

#define PCIDMA_LLI_ALIGN_SHIFT	3 /* 2^3 byte align */
#define PCIDMA_LLI_ALIGN	(1U << PCIDMA_LLI_ALIGN_SHIFT)

struct pcidma_lli {
	uint32_t ctrl;
	uint32_t size;
	uint32_t src_lo;
	uint32_t src_hi;
	uint32_t dst_lo;
	uint32_t dst_hi;
} __attribute__ ((aligned(PCIDMA_LLI_ALIGN)));

extern int pcidma_transfer_async(struct pcidma_request *req);
extern int pcidma_connect(uint pcie_ch, int connect);

#endif /* __KERNEL__ */

#ifdef __cplusplus
}
#endif
#endif /* __INCLUDE_PCIDMA_H__ */
