/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright 2022 Sony Corporation, SOCIONEXT INC.
 *
 */

#ifndef PCIE_DWC_H
#define PCIE_DWC_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

enum PCIE_LANE {
	PCIE_LANE1 = 1,
	PCIE_LANE2,
	PCIE_LANE4,
	PCIE_LANE_NUM,
};

enum PCIE_SPEED {
	PCIE_SPEED1 = 1,
	PCIE_SPEED2,
	PCIE_SPEED3,
	PCIE_SPEED4,
	PCIE_SPEED_MAX,
};

enum PCIE_CH {
	PCIE_CH0,
	PCIE_CH1,
	PCIE_CH2,
	PCIE_CH3,
	PCIE_CH4,
	PCIE_CH_MAX,
};

enum PCIE_ATU {
	PCIE_ATU0,
	PCIE_ATU1,
	PCIE_ATU2,
	PCIE_ATU3,
	PCIE_ATU4,
	PCIE_ATU5,
	PCIE_ATU6,
	PCIE_ATU7,
	PCIE_ATU_MAX,
};

enum PCIDMA_CH {
	PCIDMA_CH0,
	PCIDMA_CH1,
	PCIDMA_CH2,
	PCIDMA_CH3,
	PCIDMA_CH4,
	PCIDMA_CH5,
	PCIDMA_CH6,
	PCIDMA_CH7,
	PCIDMA_CH_MAX,
};

enum PCIDMA_DIR {
	PCIDMA_RD,
	PCIDMA_WR,
	PCIDMA_NUM,
};

struct pcidma_param {
	uint8_t pcie_ch;
	uint8_t dmac_ch;
	uint8_t dir;
	uint8_t pad[1];
	uint32_t size;
	uint64_t src;
	uint64_t dst;
};

enum PCIE_CTRL {
	PCIE_CTRL_OFF,
	PCIE_CTRL_ON,
	PCIE_CTRL_PREP_OFF,
	PCIE_CTRL_MAX,
};

enum PCIE_NOTIFY {
	PCIE_NOTIFY_START,
	PCIE_NOTIFY_TERM,
	PCIE_NOTIFY_IRQCOM,
	PCIE_NOTIFY_MAX,
};

int pcie_dwc_set_atu(int pcie_ch, int atu_idx, u64 axi_addr, u64 pci_addr, u64 size);
int pcie_dwc_get_atu(int pcie_ch, int atu_idx);
int pcie_dwc_clr_atu(int pcie_ch, int atu_idx);
int pcie_dwc_dma_start(struct pcidma_param *req,
		       void (*cb)(uint64_t err, void *cookies), void *cookies);
int pcie_dwc_dma_stop(int pcie_ch, int dmac_ch);
int pcie_dwc_root_ctrl(int pcie_ch, int on);
int pcie_dwc_set_lanes(struct pci_dev *dev, int lanes);
int pcie_dwc_get_lanes(struct pci_dev *dev);
int pcie_is_linkup(struct pci_dev *dev);
void pcie_err_clr(struct pci_bus *bus);
int pcie_err_stat(struct pci_bus *bus);
struct firm_info * pcie_dwc_firm(int firm_id);
int pcie_dwc_vboost(int pcie_ch);
int pcie_dwc_tmo(int pcie_ch);
void pcie_perst_delay(int pcie_ch);
int pcie_check_prsnt(struct pci_dev *dev);
int pcie_aspm_policy(int pcie_ch);
int pcie_dwc_max_speed(int pcie_ch);
int pcie_dwc_set_speed(struct pci_dev *dev, int speed);
int pcie_dwc_get_speed(struct pci_dev *dev);
int pcie_ext_err_stat(struct pci_bus *bus, void __iomem *dbi, void __iomem *link);
void pcie_dwc_notify(struct device *dev, int pcie_ch, enum PCIE_NOTIFY event, void __iomem *link_base);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // PCIE_DWC_H
