/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright 2022 Sony Corporation, SOCIONEXT INC.
 *
 */
#ifndef SCU_CLOCK_H
#define SCU_CLOCK_H

#ifdef __cplusplus
extern "C" {
#endif
//#define TESTCODE_LIN_CLOCK

#ifndef SCU_RESET_H
typedef enum {
	E_SCU_ERR_OK,
	E_SCU_ERR_SYS,
	E_SCU_ERR_PARAM,
} E_SCU_ERR;
#endif

typedef enum {
	E_SCU_CLK_CM_PMU_PCLK,
	E_SCU_CLK_BP_C_PCLK,
	E_SCU_CLK_BP_C_ACLK,
	E_SCU_CLK_BP_M_PCLK,
	E_SCU_CLK_BP_M_ACLK,
	E_SCU_CLK_CM_UART_PCLK,
	E_SCU_CLK_CM_UART_SCLK_DELETED,
	E_SCU_CLK_CM_TPU0_CLK,
	E_SCU_CLK_CM_TPU0_PS,
	E_SCU_CLK_CM_TPU1_CLK,
	E_SCU_CLK_CM_TPU1_PS,
	E_SCU_CLK_CM_TPU2_CLK,
	E_SCU_CLK_CM_TPU2_PS,
	E_SCU_CLK_CM_TPU3_CLK,
	E_SCU_CLK_CM_TPU3_PS,
	E_SCU_CLK_CM_TPU4_CLK,
	E_SCU_CLK_CM_TPU4_PS,
	E_SCU_CLK_CM_TPU5_CLK,
	E_SCU_CLK_CM_TPU5_PS,
	E_SCU_CLK_CM_GPIO_PCLK,
	E_SCU_CLK_CM_GPIOINT_PCLK,
	E_SCU_CLK_CM_ADC_PCLK,
	E_SCU_CLK_CM_SIO_PCLK,
	E_SCU_CLK_CM_SIO_PS,
	E_SCU_CLK_CM_SRAM_ACLK,
	E_SCU_CLK_PCIE4LC_C0_PCLK,
	E_SCU_CLK_PCIE4LC_C0_CK,
	E_SCU_CLK_PCIE4LC_C1_PCLK,
	E_SCU_CLK_PCIE4LC_C1_CK,
	E_SCU_CLK_PCIE4LC_M_PCLK,
	E_SCU_CLK_PCIE4LC_M_CK,
	E_SCU_CLK_EMMC_ACLK,
	E_SCU_CLK_EMMC_PCLK,
	E_SCU_CLK_EMMC_SD4CLK,
	E_SCU_CLK_PCIE4LF_M_ACLK,
	E_SCU_CLK_PCIE4LF_S_ACLK,
	E_SCU_CLK_PCIE4LF_DBI_ACLK,
	E_SCU_CLK_PCIE4LF_AUX_CLK,
	E_SCU_CLK_PCIE4LF_HCLK,
	E_SCU_CLK_PCIE4LF_PHY_CR_PARA_CLK,
	E_SCU_CLK_PCIE4LF_PHY_PCLK,
	E_SCU_CLK_EMMC_C_PCLK,
	E_SCU_CLK_EMMC_C_CK,
	E_SCU_CLK_EMMC_M_PCLK,
	E_SCU_CLK_EMMC_M_CK,
	E_SCU_CLK_AUDIO_DSP1_CLK,
	E_SCU_CLK_AUDIO_DSP1_BCLK,
	E_SCU_CLK_AUDIO_DSP2_CLK,
	E_SCU_CLK_AUDIO_DSP2_BCLK,
	E_SCU_CLK_AUDIO_IF_PCLK,
	E_SCU_CLK_AUDIO_IF_ACLK,
	E_SCU_CLK_AUDIO_IF_MCLK,
	E_SCU_CLK_AUDIO_IF_SYSCLK,
	E_SCU_CLK_AUDIO_IF_PWMCLK,
	E_SCU_CLK_AUDIO_C0_PCLK,
	E_SCU_CLK_AUDIO_C0_CK,
	E_SCU_CLK_AUDIO_M_PCLK,
	E_SCU_CLK_AUDIO_M_CK,
	E_SCU_CLK_OTP_PCLK,
	E_SCU_CLK_M_CPUINT_PCLK,
	E_SCU_CLK_LDEC_ACLK,
	E_SCU_CLK_LDEC_PCLK,
	E_SCU_CLK_FEC_ACLK,
	E_SCU_CLK_FEC_PCLK,
	E_SCU_CLK_CRYPTO_E0_ACLK,
	E_SCU_CLK_CRYPTO_E0_S_PCLK,
	E_SCU_CLK_CRYPTO_E0_NS_PCLK,
	E_SCU_CLK_CRYPTO_E0_CLK,
	E_SCU_CLK_CRYPTO_E1_ACLK,
	E_SCU_CLK_CRYPTO_E1_S_PCLK,
	E_SCU_CLK_CRYPTO_E1_NS_PCLK,
	E_SCU_CLK_CRYPTO_E1_CLK,
	E_SCU_CLK_CRYPTO_XTS_ACLK,
	E_SCU_CLK_CRYPTO_XTS_S_PCLK,
	E_SCU_CLK_CRYPTO_XTS_NS_PCLK,
	E_SCU_CLK_M_GPIO_PCLK,
	E_SCU_CLK_M_DMAC_C_PCLK,
	E_SCU_CLK_M_DMAC_C_CK,
	E_SCU_CLK_TZCMP0_M_PCLK,
	E_SCU_CLK_TZCMP0_M_CK,
	E_SCU_CLK_TZCMP3_M_PCLK,
	E_SCU_CLK_TZCMP3_M_CK,
	E_SCU_CLK_M_MAIN_C_PCLK,
	E_SCU_CLK_M_MAIN_C_CK,
	E_SCU_CLK_TRNG_RNG_CLK,
	E_SCU_CLK_TZC400_ACLK0,
	E_SCU_CLK_TZC400_ACLK1,
	E_SCU_CLK_TZC400_ACLK2,
	E_SCU_CLK_TZC400_ACLK3,
	E_SCU_CLK_TZC400_PCLK,
	E_SCU_CLK_M_PERI_NIC_ACLK,
	E_SCU_CLK_M_PERI_NIC_GB_ACLK,
	E_SCU_CLK_M_PERI_NIC_GC_ACLK,
	E_SCU_CLK_M_PERI_NIC_HCLK,
	E_SCU_CLK_M_PERI_NIC_M_PCLK,
	E_SCU_CLK_M_PERI_NIC_PCLK,
	E_SCU_CLK_M_PERI_NIC_U3CLK,
	E_SCU_CLK_S_SRAM_ACLK,
	E_SCU_CLK_M_WDT_WDOGCLK,
	E_SCU_CLK_M_WDT_PCLK,
	E_SCU_CLK_M_TIMER00_PCLK,
	E_SCU_CLK_M_TIMER00_TIMER_CLK,
	E_SCU_CLK_M_TIMER01_PCLK,
	E_SCU_CLK_M_TIMER01_TIMER_CLK,
	E_SCU_CLK_M_TIMER02_PCLK,
	E_SCU_CLK_M_TIMER02_TIMER_CLK,
	E_SCU_CLK_M_TIMER03_PCLK,
	E_SCU_CLK_M_TIMER03_TIMER_CLK,
	E_SCU_CLK_M_TIMER04_PCLK,
	E_SCU_CLK_M_TIMER04_TIMER_CLK,
	E_SCU_CLK_M_TIMER05_PCLK,
	E_SCU_CLK_M_TIMER05_TIMER_CLK,
	E_SCU_CLK_M_TIMER06_PCLK,
	E_SCU_CLK_M_TIMER06_TIMER_CLK,
	E_SCU_CLK_M_TIMER07_PCLK,
	E_SCU_CLK_M_TIMER07_TIMER_CLK,
	E_SCU_CLK_M_TIMER08_PCLK,
	E_SCU_CLK_M_TIMER08_TIMER_CLK,
	E_SCU_CLK_M_TIMER09_PCLK,
	E_SCU_CLK_M_TIMER09_TIMER_CLK,
	E_SCU_CLK_M_TIMER10_PCLK,
	E_SCU_CLK_M_TIMER10_TIMER_CLK,
	E_SCU_CLK_M_TIMER11_PCLK,
	E_SCU_CLK_M_TIMER11_TIMER_CLK,
	E_SCU_CLK_M_TIMER12_PCLK,
	E_SCU_CLK_M_TIMER12_TIMER_CLK,
	E_SCU_CLK_M_TIMER13_PCLK,
	E_SCU_CLK_M_TIMER13_TIMER_CLK,
	E_SCU_CLK_M_TIMER14_PCLK,
	E_SCU_CLK_M_TIMER14_TIMER_CLK,
	E_SCU_CLK_M_TIMER15_PCLK,
	E_SCU_CLK_M_TIMER15_TIMER_CLK,
	E_SCU_CLK_M_UART1_PCLK,
	E_SCU_CLK_M_UART1_SCLK_DELETED,
	E_SCU_CLK_M_UART2_PCLK,
	E_SCU_CLK_M_UART2_SCLK_DELETED,
	E_SCU_CLK_M_UART3_PCLK,
	E_SCU_CLK_M_UART3_SCLK_DELETED,
	E_SCU_CLK_M_SIO_PCLK,
	E_SCU_CLK_M_SIO_PS,
	E_SCU_CLK_M_SPI0_PCLK,
	E_SCU_CLK_M_SPI0_SSPCLK,
	E_SCU_CLK_M_SPI1_PCLK,
	E_SCU_CLK_M_SPI1_SSI_CLK,
	E_SCU_CLK_M_SPI2_PCLK,
	E_SCU_CLK_M_SPI2_SSI_CLK,
	E_SCU_CLK_M_SPI3_PCLK,
	E_SCU_CLK_M_SPI3_SSI_CLK,
	E_SCU_CLK_S_SPI_PCLK,
	E_SCU_CLK_S_SPI_SSI_CLK,
	E_SCU_CLK_M_I2C0_PCLK,
	E_SCU_CLK_M_I2C0_IC_CLK,
	E_SCU_CLK_M_I2C1_PCLK,
	E_SCU_CLK_M_I2C1_IC_CLK,
	E_SCU_CLK_M_I2C2_PCLK,
	E_SCU_CLK_M_I2C2_IC_CLK,
	E_SCU_CLK_MEDIA_C_PCLK,
	E_SCU_CLK_MEDIA_C_CK,
	E_SCU_CLK_MEDIA_M_PCLK,
	E_SCU_CLK_MEDIA_M_CK_DELETED,
	E_SCU_CLK_USB_M_PCLK,
	E_SCU_CLK_USB_M_CK_DELETED,
	E_SCU_CLK_PCIE2LM0_M_ACLK,
	E_SCU_CLK_PCIE2LM0_S_ACLK,
	E_SCU_CLK_PCIE2LM0_DBI_ACLK,
	E_SCU_CLK_PCIE2LM0_AUX_CLK,
	E_SCU_CLK_PCIE2LM0_HCLK,
	E_SCU_CLK_PCIE2LM0_PHY_CR_PARA_CLK,
	E_SCU_CLK_PCIE2LM0_PHY_PCLK,
	E_SCU_CLK_PCIE2LM1_M_ACLK,
	E_SCU_CLK_PCIE2LM1_S_ACLK,
	E_SCU_CLK_PCIE2LM1_DBI_ACLK,
	E_SCU_CLK_PCIE2LM1_AUX_CLK,
	E_SCU_CLK_PCIE2LM1_HCLK,
	E_SCU_CLK_PCIE2LM1_PHY_CR_PARA_CLK,
	E_SCU_CLK_PCIE2LM1_PHY_PCLK,
	E_SCU_CLK_PCIE1L_M_ACLK,
	E_SCU_CLK_PCIE1L_S_ACLK,
	E_SCU_CLK_PCIE1L_DBI_ACLK,
	E_SCU_CLK_PCIE1L_AUX_CLK,
	E_SCU_CLK_PCIE1L_HCLK,
	E_SCU_CLK_PCIE1L_PHY_CR_PARA_CLK,
	E_SCU_CLK_PCIE1L_PHY_PCLK,
	E_SCU_CLK_USB32_ACLK,
	E_SCU_CLK_USB32_SUSPEND_CLK,
	E_SCU_CLK_USB32_TCA_APB_CLK,
	E_SCU_CLK_USB20_OHCI_CLK48,
	E_SCU_CLK_USB20_HO_HCLK,
	E_SCU_CLK_USB20_HCLK,
	E_SCU_CLK_UHS2_0_ACLK,
	E_SCU_CLK_UHS2_0_HCLK,
	E_SCU_CLK_UHS2_0_SD4CLK,
	E_SCU_CLK_UHS2_0_BCLK2_DELETED,
	E_SCU_CLK_UHS2_1_ACLK,
	E_SCU_CLK_UHS2_1_HCLK,
	E_SCU_CLK_UHS2_1_SD4CLK,
	E_SCU_CLK_UHS2_1_BCLK2_DELETED,
	E_SCU_CLK_UHS1_HCLK,
	E_SCU_CLK_UHS1_SD_SD4CLK,
	E_SCU_CLK_USB20_MMU_CCLK,
	E_SCU_CLK_USB20_MMU_TBU_BCLK0,
	E_SCU_CLK_UHS2_MMU_0_CCLK,
	E_SCU_CLK_UHS2_MMU_0_TBU_BCLK0,
	E_SCU_CLK_UHS2_MMU_1_CCLK,
	E_SCU_CLK_UHS2_MMU_1_TBU_BCLK0,
	E_SCU_CLK_UHS1_MMU_CCLK,
	E_SCU_CLK_UHS1_MMU_TBU_BCLK0,
	E_SCU_CLK_MS_XMSCKI,
	E_SCU_CLK_MS_HCLK,
	E_SCU_CLK_MS_DVEN,
	E_SCU_CLK_AUDIO_C1_PCLK,
	E_SCU_CLK_AUDIO_C1_CK,
	E_SCU_CLK_SRAM_A0_ACLK,
	E_SCU_CLK_SRAM_A1_ACLK,
	E_SCU_CLK_TBL_SRAM_ACLK,
	E_SCU_CLK_FCS_HCLK,
	E_SCU_CLK_FCS_PCLK,
	E_SCU_CLK_LM_DSP_396,
	E_SCU_CLK_LM,
	E_SCU_CLK_LM_54,
	E_SCU_CLK_LM_V_CORE,
	E_SCU_CLK_LM_V_CTRL,
	E_SCU_CLK_LM_V_CTRL_M,
	E_SCU_CLK_LM_V_V,
	E_SCU_CLK_LM_12,
	E_SCU_CLK_PCIE4LC_M_ACLK,
	E_SCU_CLK_PCIE4LC_S_ACLK,
	E_SCU_CLK_PCIE4LC_DBI_ACLK,
	E_SCU_CLK_PCIE4LC_AUX_CLK,
	E_SCU_CLK_PCIE4LC_HCLK,
	E_SCU_CLK_PCIE4LC_PHY_CR_PARA_CLK,
	E_SCU_CLK_PCIE4LC_PHY_PCLK,
	E_SCU_CLK_COPY0_ACLK,
	E_SCU_CLK_COPY0_PCLK,
	E_SCU_CLK_COPY1_ACLK,
	E_SCU_CLK_COPY1_PCLK,
	E_SCU_CLK_COPY2_ACLK,
	E_SCU_CLK_COPY2_PCLK,
	E_SCU_CLK_COPY3_ACLK,
	E_SCU_CLK_COPY3_PCLK,
	E_SCU_CLK_M_DMACS_CORE,
	E_SCU_CLK_M_DMACS_PCLK,
	E_SCU_CLK_M_DMACS_HS_CLK0,
	E_SCU_CLK_M_DMACS_HS_CLK1,
	E_SCU_CLK_M_DMAC1_CORE,
	E_SCU_CLK_M_DMAC1_PCLK,
	E_SCU_CLK_M_DMAC2_CORE,
	E_SCU_CLK_M_DMAC2_PCLK,
	E_SCU_CLK_M_DMAC3_CORE,
	E_SCU_CLK_M_DMAC3_PCLK,
	E_SCU_CLK_M_DMAC4_CORE,
	E_SCU_CLK_M_DMAC4_PCLK,
	E_SCU_CLK_M_DMAC4_HS_CLK00,
	E_SCU_CLK_M_DMAC4_HS_CLK01,
	E_SCU_CLK_M_DMAC4_HS_CLK02,
	E_SCU_CLK_M_DMAC4_HS_CLK03,
	E_SCU_CLK_M_DMAC4_HS_CLK04,
	E_SCU_CLK_M_DMAC4_HS_CLK05,
	E_SCU_CLK_M_DMAC4_HS_CLK06,
	E_SCU_CLK_M_DMAC4_HS_CLK07,
	E_SCU_CLK_M_DMAC4_HS_CLK08,
	E_SCU_CLK_M_DMAC4_HS_CLK09,
	E_SCU_CLK_M_DMAC4_HS_CLK10,
	E_SCU_CLK_M_DMAC4_HS_CLK11,
	E_SCU_CLK_LM_DSP396,
	E_SCU_CLK_LM_V_CORE_V,
	E_SCU_CLK_MAX,
} E_SCU_CLK;

typedef enum {
	E_SCU_CLKSEL_UHS1_SD4CLK,
	E_SCU_CLKSEL_EMMC_SD4CLK,
	E_SCU_CLKSEL_MAX,
} E_SCU_CLKSEL;

typedef enum {
	SCU_CLKSEL_UHS1_PLLSD,
	SCU_CLKSEL_UHS1_PLL4,
	SCU_CLKSEL_UHS1_PLL5,
	SCU_CLKSEL_UHS1_MAX,
} E_SCU_CLKSEL_UHS1;

typedef enum {
	SCU_CLKSEL_EMMC_PLLSD,
	SCU_CLKSEL_EMMC_PLL4,
	SCU_CLKSEL_EMMC_PLL5,
	SCU_CLKSEL_EMMC_MAX,
} E_SCU_CLKSEL_EMMC;

typedef enum {
	E_SCU_CLKDIV_UHS2_0,
	E_SCU_CLKDIV_UHS2_1,
	E_SCU_CLKDIV_UHS1_PLL4,
	E_SCU_CLKDIV_UHS1_PLL5,
	E_SCU_CLKDIV_UHS1_PLLSD,
	E_SCU_CLKDIV_EMMC_PLL4,
	E_SCU_CLKDIV_EMMC_PLL5,
	E_SCU_CLKDIV_EMMC_PLLSD,
	E_SCU_CLKDIV_AUDIO_MCLK,
	E_SCU_CLKDIV_AUDIO_PWMCLK,
	E_SCU_CLKDIV_MAX,
} E_SCU_CLKDIV;

extern E_SCU_ERR scu_clk_enable(const E_SCU_CLK id);
extern E_SCU_ERR scu_clk_disable(const E_SCU_CLK id);
extern E_SCU_ERR scu_clk_select(const E_SCU_CLKSEL id, uint32_t param);
extern E_SCU_ERR scu_div_set(const E_SCU_CLKDIV id, uint32_t param);

#ifdef TESTCODE_LIN_CLOCK

extern uint32_t SCU_lin_clk_gate_reg_direct_read_gate(uint32_t offset);
extern uint32_t SCU_lin_clk_gate_reg_direct_read_mux(uint32_t offset);
#ifndef CONFIG_CLOCK_FPGA_ENV
extern uint32_t SCU_lin_clk_gate_reg_direct_read_div(uint32_t offset);
#endif
extern int scu_clk_state(const E_SCU_CLK id);

void SCU_time_mesure_reset(void);
void SCU_time_mesure_start(void);
void SCU_time_mesure_stop(void);
void SCU_time_mesure_print(void);

#endif

#ifdef __cplusplus
}
#endif

#endif
