// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright 2022 Sony Corporation, SOCIONEXT INC.
 *
 */
#ifndef SCU_RESET_H
#define SCU_RESET_H

#ifdef __cplusplus
extern "C" {
#endif
//#define TESTCODE_LIN_RESET

#ifndef SCU_CLOCK_H
typedef enum {
	E_SCU_ERR_OK,
	E_SCU_ERR_SYS,
	E_SCU_ERR_PARAM,
} E_SCU_ERR;
#endif

typedef enum {
	E_SCU_RST_BP_C_PRESETN,
	E_SCU_RST_BP_C_ARESETN,
	E_SCU_RST_BP_M_PRESETN,
	E_SCU_RST_BP_M_ARESETN,
	E_SCU_RST_CM_UART_PRESETN,
	E_SCU_RST_CM_UART_S_RST_N_DELETED,
	E_SCU_RST_CM_TPU0_RESETN,
	E_SCU_RST_CM_TPU1_RESETN,
	E_SCU_RST_CM_TPU2_RESETN,
	E_SCU_RST_CM_TPU3_RESETN,
	E_SCU_RST_CM_TPU4_RESETN,
	E_SCU_RST_CM_TPU5_RESETN,
	E_SCU_RST_CM_GPIO_PRESETN,
	E_SCU_RST_CM_GPIOINT_PRESETN,
	E_SCU_RST_CM_ADC_PRESETN,
	E_SCU_RST_CM_SIO_PRESETN,
	E_SCU_RST_CM_SRAM_ARESETN,
	E_SCU_RST_PCIE4LC_C0_ARESETN,
	E_SCU_RST_PCIE4LC_C1_ARESETN,
	E_SCU_RST_PCIE4LC_M_ARESETN,
	E_SCU_RST_EMMC_XRESET,
	E_SCU_RST_PCIE4LF_RST_N,
	E_SCU_RST_EMMC_C_ARESETN,
	E_SCU_RST_EMMC_M_ARESETN,
	E_SCU_RST_AUDIO_DSP1_DRESET,
	E_SCU_RST_AUDIO_DSP1_BRESET,
	E_SCU_RST_AUDIO_DSP2_DRESET,
	E_SCU_RST_AUDIO_DSP2_BRESET,
	E_SCU_RST_AUDIO_IF_NRESET,
	E_SCU_RST_AUDIO_C0_ARESETN,
	E_SCU_RST_AUDIO_M_ARESETN,
	E_SCU_RST_OTP_RESETN,
	E_SCU_RST_M_CPUINT_PRESETN,
	E_SCU_RST_LDEC_RESETN,
	E_SCU_RST_FEC_RESETN,
	E_SCU_RST_CRYPT_E0_RSTX,
	E_SCU_RST_CRYPT_E1_RSTX,
	E_SCU_RST_CRYPT_XTS_RSTX,
	E_SCU_RST_M_GPIO_PRESETN,
	E_SCU_RST_M_DMAC_C_ARESETN,
	E_SCU_RST_TZCMP0_M_ARESETN,
	E_SCU_RST_TZCMP3_M_ARESETN,
	E_SCU_RST_M_MAIN_C_ARESETN,
	E_SCU_RST_TRNG_RST_N,
	E_SCU_RST_TZC400_ARESETN0,
	E_SCU_RST_TZC400_ARESETN1,
	E_SCU_RST_TZC400_ARESETN2,
	E_SCU_RST_TZC400_ARESETN3,
	E_SCU_RST_TZC400_PRESETN,
	E_SCU_RST_M_TIMER00_PRESETN,
	E_SCU_RST_M_TIMER01_PRESETN,
	E_SCU_RST_M_TIMER02_PRESETN,
	E_SCU_RST_M_TIMER03_PRESETN,
	E_SCU_RST_M_TIMER04_PRESETN,
	E_SCU_RST_M_TIMER05_PRESETN,
	E_SCU_RST_M_TIMER06_PRESETN,
	E_SCU_RST_M_TIMER07_PRESETN,
	E_SCU_RST_M_TIMER08_PRESETN,
	E_SCU_RST_M_TIMER09_PRESETN,
	E_SCU_RST_M_TIMER10_PRESETN,
	E_SCU_RST_M_TIMER11_PRESETN,
	E_SCU_RST_M_TIMER12_PRESETN,
	E_SCU_RST_M_TIMER13_PRESETN,
	E_SCU_RST_M_TIMER14_PRESETN,
	E_SCU_RST_M_TIMER15_PRESETN,
	E_SCU_RST_M_UART1_PRESETN,
	E_SCU_RST_M_UART1_S_RST_N_DELETED,
	E_SCU_RST_M_UART2_PRESETN,
	E_SCU_RST_M_UART2_S_RST_N_DELETED,
	E_SCU_RST_M_UART3_PRESETN,
	E_SCU_RST_M_UART3_S_RST_N_DELETED,
	E_SCU_RST_M_SIO_PRESETN,
	E_SCU_RST_M_SPI0_PRESETN,
	E_SCU_RST_M_SPI0_SSPRST_N,
	E_SCU_RST_M_SPI1_PRESETN,
	E_SCU_RST_M_SPI1_SSI_RST_N,
	E_SCU_RST_M_SPI2_PRESETN,
	E_SCU_RST_M_SPI2_SSI_RST_N,
	E_SCU_RST_M_SPI3_PRESETN,
	E_SCU_RST_M_SPI3_SSI_RST_N,
	E_SCU_RST_S_SPI_PRESETN,
	E_SCU_RST_S_SPI_SSI_RST_N,
	E_SCU_RST_M_I2C0_PRESETN,
	E_SCU_RST_M_I2C0_IC_RST_N,
	E_SCU_RST_M_I2C1_PRESETN,
	E_SCU_RST_M_I2C1_IC_RST_N,
	E_SCU_RST_M_I2C2_PRESETN,
	E_SCU_RST_M_I2C2_IC_RST_N,
	E_SCU_RST_MEDIA_C_ARESETN,
	E_SCU_RST_MEDIA_M_ARESETN,
	E_SCU_RST_USB_M_ARESETN,
	E_SCU_RST_PCIE2LM0_RST_N,
	E_SCU_RST_PCIE2LM1_RST_N,
	E_SCU_RST_PCIE1L_RST_N,
	E_SCU_RST_USB32_ARESETN,
	E_SCU_RST_USB32_POR,
	E_SCU_RST_USB32_PHY_RESET,
	E_SCU_RST_USB32_APBRST,
	E_SCU_RST_USB20_HO_HRESETN,
	E_SCU_RST_USB20_HRESETN,
	E_SCU_RST_USB20_PRST_N,
	E_SCU_RST_USB20_POR,
	E_SCU_RST_UHS2_0_XRESET,
	E_SCU_RST_UHS2_1_XRESET,
	E_SCU_RST_UHS1_XRESET,
	E_SCU_RST_USB20_MMU_CRESETN,
	E_SCU_RST_USB20_MMU_TBU_BRESETN0,
	E_SCU_RST_UHS2_MMU_0_CRESETN,
	E_SCU_RST_UHS2_MMU_0_TBU_BRESETN0,
	E_SCU_RST_UHS2_MMU_1_CRESETN,
	E_SCU_RST_UHS2_MMU_1_TBU_BRESETN0,
	E_SCU_RST_UHS1_MMU_CRESETN,
	E_SCU_RST_UHS1_MMU_TBU_BRESETN0,
	E_SCU_RST_MS_HRESETN,
	E_SCU_RST_M_PERI_NIC_ARESETN,
	E_SCU_RST_M_PERI_NIC_GB_ARESETN,
	E_SCU_RST_M_PERI_NIC_GC_ARESETN,
	E_SCU_RST_M_PERI_NIC_HRESETN,
	E_SCU_RST_M_PERI_NIC_M_PRESETN,
	E_SCU_RST_M_PERI_NIC_PRESETN,
	E_SCU_RST_M_PERI_NIC_U3RESETN,
	E_SCU_RST_S_SRAM_ARESETN,
	E_SCU_RST_M_WDT_WDOGRESN,
	E_SCU_RST_M_WDT_PRESETN,
	E_SCU_RST_AUDIO_C1_ARESETN,
	E_SCU_RST_SRAM_A0_ARESETN,
	E_SCU_RST_SRAM_A1_ARESETN,
	E_SCU_RST_TBL_SRAM_ARESETN,
	E_SCU_RST_FCS_ARESETN,
	E_SCU_RST_PCIE4LC_RST_N,
	E_SCU_RST_COPY0_RESETN,
	E_SCU_RST_COPY1_RESETN,
	E_SCU_RST_COPY2_RESETN,
	E_SCU_RST_COPY3_RESETN,
	E_SCU_RST_M_DMACS_RESETN,
	E_SCU_RST_M_DMACS_PRESETN,
	E_SCU_RST_M_DMACS_HS_RSTN0,
	E_SCU_RST_M_DMACS_HS_RSTN1,
	E_SCU_RST_M_DMAC1_RESETN,
	E_SCU_RST_M_DMAC1_PRESETN,
	E_SCU_RST_M_DMAC2_RESETN,
	E_SCU_RST_M_DMAC2_PRESETN,
	E_SCU_RST_M_DMAC3_RESETN,
	E_SCU_RST_M_DMAC3_PRESETN,
	E_SCU_RST_M_DMAC4_RESETN,
	E_SCU_RST_M_DMAC4_PRESETN,
	E_SCU_RST_M_DMAC4_HS_RSTN00,
	E_SCU_RST_M_DMAC4_HS_RSTN01,
	E_SCU_RST_M_DMAC4_HS_RSTN02,
	E_SCU_RST_M_DMAC4_HS_RSTN03,
	E_SCU_RST_M_DMAC4_HS_RSTN04,
	E_SCU_RST_M_DMAC4_HS_RSTN05,
	E_SCU_RST_M_DMAC4_HS_RSTN06,
	E_SCU_RST_M_DMAC4_HS_RSTN07,
	E_SCU_RST_M_DMAC4_HS_RSTN08,
	E_SCU_RST_M_DMAC4_HS_RSTN09,
	E_SCU_RST_M_DMAC4_HS_RSTN10,
	E_SCU_RST_M_DMAC4_HS_RSTN11,
} E_SCU_RST;

extern E_SCU_ERR scu_rst_enable(const E_SCU_RST id);
extern E_SCU_ERR scu_rst_disable(const E_SCU_RST id);
#ifdef TESTCODE_LIN_RESET
extern uint32_t SCU_lin_reset_reg_direct_read(uint32_t offset);
extern int scu_rst_state(const E_SCU_RST id);
#endif

#ifdef __cplusplus
}
#endif

#endif
