/*
 * include/linux/usb/f_usb/usb_otg_control.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*--------------------------------------------------------------------------*
 * include/linux/usb/scd/usb_otg_control.h
 *
 * USB controller driver OTG API
 *
 * Copyright 2005,2006,2008,2011 Sony Corporation
 *
 * This file is part of the HS-OTG Controller Driver SCD.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *---------------------------------------------------------------------------*/

#ifndef _USB_OTG_CONTROL_H_
#define _USB_OTG_CONTROL_H_

enum usb_otg_control_speed {
	USB_OTG_SPEED_LS,		/**< Low Speed  */
	USB_OTG_SPEED_FS,		/**< Full Speed */
	USB_OTG_SPEED_HS,		/**< High Speed */
	USB_OTG_SPEED_SS,		/**< Super Speed */
	USB_OTG_SPEED_SSP,		/**< Super Speed Plus */
	USB_OTG_SPEED_NATIVE,	/**< Gadget Native Speed  */
	USB_OTG_SPEED_UNKNOWN,	/**< Unknown */
};


enum usb_otg_control_test_mode {
	USB_OTG_TEST_MODE_NORMAL,

	USB_OTG_TEST_MODE_G_PACKET,
	USB_OTG_TEST_MODE_G_K,
	USB_OTG_TEST_MODE_G_J,
	USB_OTG_TEST_MODE_G_SE0_NAK,

	USB_OTG_TEST_MODE_G_FORCE_PACKET,

	USB_OTG_TEST_MODE_H_PACKET,
	USB_OTG_TEST_MODE_H_K,
	USB_OTG_TEST_MODE_H_J,
	USB_OTG_TEST_MODE_H_SE0_NAK,

	USB_OTG_TEST_MODE_H_SETUP,
	USB_OTG_TEST_MODE_H_IN,
	USB_OTG_TEST_MODE_H_AS,
	USB_OTG_TEST_MODE_H_LS,
	USB_OTG_TEST_MODE_H_FS,
	USB_OTG_TEST_MODE_H_HS,
	USB_OTG_TEST_MODE_H_SS,
};

struct usb_otg_control_port_info {
	unsigned int nr;
	unsigned int current_port;
};

#define USB_OTG_TYPEC_ORIENTATION_NORMAL	(0)
#define USB_OTG_TYPEC_ORIENTATION_FLIPPED	(1)

#define USB_OTG_USB_SS_OPERATION_ENABLE	(0)
#define USB_OTG_USB_SS_OPERATION_DISABLE	(1)

#define USB_OTG_PORT_TYPE_TYPEC0	(0)
#define USB_OTG_PORT_TYPE_TYPEC1	(1)

struct usb_otg_line_state {
	uint8_t dp;			/**< D+ line state	*/
	uint8_t dm;			/**< D- line state	*/
	uint16_t reserved;		/**< Reserved		*/
};



struct usb_otg_control; 		/**< prototype */

struct usb_otg_control_ops {
	int (*get_port_info) (struct usb_otg_control *,struct usb_otg_control_port_info * info);
	int (*select_port) (struct usb_otg_control *, unsigned int pn);
	int (*start_control) (struct usb_otg_control *, unsigned int port);
	int (*stop_control) (struct usb_otg_control *, unsigned int port);
	int (*start_gadget) (struct usb_otg_control *, unsigned int port);
	int (*stop_gadget) (struct usb_otg_control *, unsigned int port);
	int (*enable_rchost) (struct usb_otg_control *, unsigned int port);
	int (*disable_rchost) (struct usb_otg_control *, unsigned int port);
	int (*stop_rchost) (struct usb_otg_control *, unsigned int port);
	int (*start_host) (struct usb_otg_control *, unsigned int port);
	int (*stop_host) (struct usb_otg_control *, unsigned int port);
	int (*start_rcgadget) (struct usb_otg_control *, unsigned int port);
	int (*stop_rcgadget) (struct usb_otg_control *, unsigned int port);
	int (*get_mode) (struct usb_otg_control *, unsigned int port);
	int (*request_session) (struct usb_otg_control *, unsigned int port);
	int (*set_speed) (struct usb_otg_control *,unsigned int port, enum usb_otg_control_speed speed);
	enum usb_otg_control_speed (*get_speed) (struct usb_otg_control *, unsigned int port);
	int (*set_test_mode) (struct usb_otg_control *,enum usb_otg_control_test_mode test_mode);
	enum usb_otg_control_test_mode (*get_test_mode) (struct usb_otg_control*);
	int (*set_tpc_setting) (struct usb_otg_control *,int orientation,int ss_operation);
	int (*set_phy) (unsigned int port, const void *);
	int (*set_port_type) (int type);
};


struct usb_otg_control {
	struct usb_otg_control_ops *ops;
	struct usb_otg_core *otg_core;
	const char *name;
	void *data;
};


struct usb_otg_core {
	int (*bind) (struct usb_otg_control * otg_control);
	int (*unbind) (struct usb_otg_control * otg_control);
};



struct usb_otg_module_ops {
	struct platform_device *pdev;			/**<  */
	void *data;					/**<  */
	int (*probe) (void *data);			/**<  */
	int (*remove) (void *data);			/**<  */
};


struct usb_otg_module_gadget_ops {
	struct platform_device *pdev;			/**<  */
	void *data;					/**<  */
	int (*probe) (void *data);			/**<  */
	int (*remove) (void *data);			/**<  */
	enum usb_otg_control_speed (*get_speed) (void *data);
};



extern int usb_otg_control_register_core(struct usb_otg_core *otg_core);

extern int usb_otg_control_unregister_core(struct usb_otg_core *otg_core);


static inline int
usb_otg_core_bind(struct usb_otg_core *otg_core,
		  struct usb_otg_control *otg_control)
{
	return otg_core->bind(otg_control);
}

static inline int
usb_otg_core_unbind(struct usb_otg_core *otg_core,
		    struct usb_otg_control *otg_control)
{
	return otg_core->unbind(otg_control);
}


static inline int
usb_otg_control_get_port_info(struct usb_otg_control *otg_control,
			      struct usb_otg_control_port_info *info)
{
	if (!info) {
		return -EINVAL;
	}
	return otg_control->ops->get_port_info(otg_control, info);
}


static inline int
usb_otg_control_select_port(struct usb_otg_control *otg_control,
			    unsigned int pn)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->select_port(otg_control, (u32)pn);
}

static inline int
usb_otg_control_start_control(struct usb_otg_control *otg_control,
			      unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->start_control(otg_control, port);
}


static inline int
usb_otg_control_stop_control(struct usb_otg_control *otg_control,
			     unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->stop_control(otg_control, port);
}


static inline int
usb_otg_control_start_gadget(struct usb_otg_control *otg_control,
			     unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->start_gadget(otg_control, port);
}


static inline int
usb_otg_control_stop_gadget(struct usb_otg_control *otg_control,
			    unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->stop_gadget(otg_control, port);
}


static inline int
usb_otg_control_enable_rchost(struct usb_otg_control *otg_control,
			      unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->enable_rchost(otg_control, port);
}


static inline int
usb_otg_control_disable_rchost(struct usb_otg_control *otg_control,
			       unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->disable_rchost(otg_control, port);
}


static inline int
usb_otg_control_stop_rchost(struct usb_otg_control *otg_control,
			    unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->stop_rchost(otg_control, port);
}


static inline int
usb_otg_control_start_host(struct usb_otg_control *otg_control,
			   unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->start_host(otg_control, port);
}


static inline int usb_otg_control_stop_host(struct usb_otg_control *otg_control,
					    unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->stop_host(otg_control, port);
}


static inline int
usb_otg_control_start_rcgadget(struct usb_otg_control *otg_control,
			       unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->start_rcgadget(otg_control, port);
}


static inline int
usb_otg_control_stop_rcgadget(struct usb_otg_control *otg_control,
			      unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->stop_rcgadget(otg_control, port);
}


static inline int usb_otg_control_get_mode(struct usb_otg_control *otg_control,
					   unsigned int port)

{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->get_mode(otg_control, port);
}

#define USB_OTG_CONTROL_STOP		1U
#define USB_OTG_CONTROL_IDLE		2U
#define USB_OTG_CONTROL_GADGET		3U
#define USB_OTG_CONTROL_RCHOST		4U
#define USB_OTG_CONTROL_HOST		5U
#define USB_OTG_CONTROL_RCGADGET	6U


static inline int
usb_otg_control_request_session(struct usb_otg_control *otg_control,
				unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->request_session(otg_control, port);
}


static inline int
usb_otg_control_set_speed(struct usb_otg_control *otg_control,
			  unsigned int port,
			  unsigned int speed)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->set_speed(otg_control, port, speed);
}


static inline enum usb_otg_control_speed
usb_otg_control_get_speed(struct usb_otg_control *otg_control,
			  unsigned int port)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->get_speed(otg_control, port);
}


static inline int
usb_otg_control_set_test_mode(struct usb_otg_control *otg_control,
			      enum usb_otg_control_test_mode test_mode)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->set_test_mode(otg_control, test_mode);
}


static inline enum usb_otg_control_test_mode
usb_otg_control_get_test_mode(struct usb_otg_control *otg_control)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->get_test_mode(otg_control);
}


static inline int
usb_otg_control_set_tpc_setting(struct usb_otg_control *otg_control,
			  int orientation, int ss_operation)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->set_tpc_setting(otg_control, orientation, ss_operation);
}


static inline int
usb_otg_control_set_phy(struct usb_otg_control *otg_control,
			unsigned int port,
			const void *data)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->set_phy(port, data);
}

static inline int
usb_otg_control_set_port_type(struct usb_otg_control *otg_control, int type)
{
	if (!otg_control) {
		return -EINVAL;
	}
	return otg_control->ops->set_port_type(type);
}

extern void *fusb_otg_get_base_addr(unsigned int flag);
#define FUSB_ADDR_TYPE_HOST		0
#define FUSB_ADDR_TYPE_GADGET		1U
#define FUSB_ADDR_TYPE_GLOBAL		2U
extern void fusb_otg_resume_initial_set(void);
extern int usb_otg_set_vbus(int vbus);
extern int usb_otg_set_cid(int cid);

#define BACKUP_PHY_PARAM_SIZE	36
// Phy Param offset of Backup
#define P0_PARAM_COMPDISTUNE0		0
#define P0_PARAM_TXVREFTUNE0		1
#define P0_PARAM_TXPREEMPAMPTUNE0	2
#define P0_PARAM_SQRXTUNE0		3
#define P0_PARAM_TXRISETUNE0		4
#define P0_PARAM_TX_VBOOST_LVL_EN	5
#define P0_PARAM_TX_VBOOST_LVL		6
#define P0_PARAM_MAIN_OVRD_EN_L1	7
#define P0_PARAM_TX_MAIN_CURSOR_L1	8
#define P0_PARAM_POST_OVRD_EN_L1	9
#define P0_PARAM_TX_POST_CURSOR_L1	10
#define P0_PARAM_PRE_OVRD_EN_L1		11
#define P0_PARAM_TX_PRE_CURSOR_L1	12
#define P0_PARAM_MAIN_OVRD_EN_L2	13
#define P0_PARAM_TX_MAIN_CURSOR_L2	14
#define P0_PARAM_POST_OVRD_EN_L2	15
#define P0_PARAM_TX_POST_CURSOR_L2	16
#define P0_PARAM_PRE_OVRD_EN_L2		17
#define P0_PARAM_TX_PRE_CURSOR_L2	18
#define P1_PARAM_COMPDISTUNE0		31
#define P1_PARAM_TXVREFTUNE0		32
#define P1_PARAM_TXPREEMPAMPTUNE0	33
#define P1_PARAM_SQRXTUNE0		34
#define P1_PARAM_TXRISETUNE0		35
typedef struct cxd_phy_param {
        unsigned char phy_data[BACKUP_PHY_PARAM_SIZE];
} cxd_phy_param_t;
extern cxd_phy_param_t backup_phy_param;
#endif			/* _USB_OTG_CONTROL_H_ */
