/*
 * include/linux/usb/f_usb/usb_otg_extcon.h
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined(__USB_OTG_DWC2_EXTCON_H__)
#define __USB_OTG_DWC2_EXTCON_H__

#include <linux/platform_device.h>
#include <linux/usb/f_usb/usb_otg_notify.h>

#ifdef CONFIG_USB_FUSB_OTG_EXTCON
enum DWC2_DRD {
	DWC2_DRD_HOST,
	DWC2_DRD_GADGET,
	DWC2_DRD_IDLE,
};

#define FUSB_DWC_PORT_TYPE_USB2 (1)

int fusb_otg_set_dwc2_drd_state(enum DWC2_DRD state);
int fusb_otg_get_dwc2_drd_state(enum DWC2_DRD *state);
extern int32_t fusb_otg_dwc2_extcon_setup(void);
extern int32_t fusb_otg_dwc2_extcon_teardown(void);
bool fusb_otg_dwc2_read_vbus(void);
void fusb_otg_dwc2_enable_irq(void);
void fusb_otg_dwc2_disable_irq(void);
extern void fusb_interrupt_usb_vbus1(enum usb_otg_vbus_stat vbus1);
#else
static inline int fusb_otg_set_dwc2_drd_state(enum DWC2_DRD state) { return 0; }
static inline int fusb_otg_get_dwc2_drd_state(enum DWC2_DRD *state) { *state = 0; return 0; }
static inline int fusb_otg_dwc2_extcon_setup(struct platform_device *pdev) { return 0; }
static inline int fusb_otg_dwc2_extcon_teardown(struct platform_device *pdev) { return 0; }
#endif  /* CONFIG_USB_FUSB_OTG_EXTCON */

#endif  /* __USB_OTG_DWC2_EXTCON_H__ */
