/*
 * include/linux/usb/f_usb/usb_otg_extcon.h
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined(__USB_OTG_DWC3_EXTCON_H__)
#define __USB_OTG_DWC3_EXTCON_H__

#include <linux/platform_device.h>
#include <linux/usb/f_usb/usb_otg_notify.h>

#ifdef CONFIG_USB_FUSB_OTG_EXTCON
enum DWC3_DRD {
	DWC3_DRD_HOST,
	DWC3_DRD_GADGET,
	DWC3_DRD_IDLE,
};

#define FUSB_DWC_PORT_TYPE_USB3 (0)

int fusb_otg_set_dwc3_drd_state(enum DWC3_DRD state);
int fusb_otg_get_dwc3_drd_state(enum DWC3_DRD *state);
int fusb_otg_set_dwc3_tpc_setting(bool orientation, bool ss_operation);
int fusb_otg_set_dwc3_orientation(bool orientation);
int fusb_otg_set_dwc3_ss_operation(bool ss_operation);
int32_t fusb_otg_dwc3_extcon_setup(void);
int32_t fusb_otg_dwc3_extcon_teardown(void);
bool fusb_otg_dwc3_read_vbus(void);
void fusb_otg_dwc3_enable_irq(void);
void fusb_otg_dwc3_disable_irq(void);
extern void fusb_interrupt_usb_vbus0(enum usb_otg_vbus_stat vbus0);
#else
static inline int fusb_otg_set_dwc3_drd_state(enum DWC3_DRD state) { return 0; }
static inline int fusb_otg_get_dwc3_drd_state(enum DWC3_DRD *state) { *state = 0; return 0; }
static inline int fusb_otg_set_dwc3_tpc_setting(bool orientation, bool ss_operation) { return 0; }
static inline int fusb_otg_set_dwc3_orientation(bool orientation) { return 0; }
static inline int fusb_otg_set_dwc3_ss_operation(bool ss_operation) { return 0; }
static inline int fusb_otg_extcon_setup(struct platform_device *pdev) { return 0; }
static inline int fusb_otg_extcon_teardown(struct platform_device *pdev) { return 0; }
#endif  /* CONFIG_USB_FUSB_OTG_EXTCON */

#endif  /* __USB_OTG_DWC3_EXTCON_H__ */
