/*
 * include/linux/wdt.h
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __LINUX_WDT_H
#define __LINUX_WDT_H

#define WDT_IOC_MAGIC   'w'
#define STOP_WDT        0
#define START_WDT       1
#define START_DEBUG     2
#define WDT_SET_START   _IOW(WDT_IOC_MAGIC, START_WDT, unsigned int)
#define WDT_SET_STOP    _IO(WDT_IOC_MAGIC, STOP_WDT)
#define WDT_SET_DEBUG   _IOW(WDT_IOC_MAGIC, START_DEBUG, unsigned int)
#define WDT_NAME	"wdt"

#ifdef __KERNEL__
#ifdef CONFIG_CXD_WDT
extern void watchdog_start(void);
extern void watchdog_stop(void);
extern void watchdog_touch(void);
extern int watchdog_touch_exception(void);
extern void watchdog_reg_callback(void (*p)(void));
#else /* CONFIG_CXD_WDT */
static inline void watchdog_start(void){}
static inline void watchdog_stop(void){}
static inline void watchdog_touch(void){}
static inline int watchdog_touch_exception(void){ return 0; }
static inline void watchdog_reg_callback(void (*p)(void)){}
#endif /* CONFIG_CXD_WDT */
#endif /* __KERNEL__ */

#endif /* __LINUX_WDT_H */
