/*
 * cxd-adrs_conv.h
 *
 * DMA address converter
 *
 * Copyright 2022 Sony Corporation
 *
 */
#ifndef __UAPI_LINUX_CXD_ADRS_CONV_H
#define __UAPI_LINUX_CXD_ADRS_CONV_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <mach/dma32.h>

/*
 * PHYS32_TO_PHYS64
 * SYNOPSIS
 *	#include <uapi/linux/cxd-adrs_conv.h>
 *	uint64_t PHYS32_TO_PHYS64(uint32_t);
 * INPUT
 *	32bit DMA address
 * RETURN VALUE
 *	Kernel physical address
 */
#define PHYS32_TO_PHYS64(x)	__arch_p32_to_p64(x)

/*
 * PHYS64_TO_PHYS32
 * SYNOPSIS
 *	#include <uapi/linux/cxd-adrs_conv.h>
 *	uint32_t PHYS64_TO_PHYS32(uint64_t);
 * INPUT
 *	Kernel physical address
 * RETURN VALUE
 *	32bit DMA address
 *	If input is out of range, PHYS32_ERR shall be returned.
 */
#define PHYS64_TO_PHYS32(x)	__arch_p64_to_p32(x)

#ifdef __cplusplus
}
#endif

#endif /* __UAPI_LINUX_CXD_ADRS_CONV_H */
