/* SPDX-License-Identifier: GPL-2.0+ WITH Linux-syscall-note */
/*
 * include/uapi/linux/i2c-dev_ext.h
 *
 * I2C ioctl extension
 *
 * Copyright 2024 Sony Corporation
 *
 * This code is based on include/uapi/linux/i2c-dev.h
 */
/*
 * i2c-dev.h - I2C bus char device interface
 *
 * Copyright (C) 1995-97 Simon G. Vogl
 * Copyright (C) 1998-99 Frodo Looijaard <frodol@dds.nl>
 * Copyright 2022 Sony Corporation, SOCIONEXT INC.
 */

#ifndef _UAPI_LINUX_I2C_DEV_EXT_H
#define _UAPI_LINUX_I2C_DEV_EXT_H

/* ioctl */
#ifndef I2C_CLOCK_FREQUENCY
#define I2C_CLOCK_FREQUENCY 0x0710 /* Set I2C bus clock frequency(Hz) */
#define  I2C_CLOCK_FREQUENCY_100K  100000 /* standard mode */
#define  I2C_CLOCK_FREQUENCY_400K  400000 /* fast mode */
#define  I2C_CLOCK_FREQUENCY_1M   1000000 /* fast mode plus */
#endif

#endif /* _UAPI_LINUX_I2C_DEV_EXT_H */
