/*
 * usbg_storage.h
 *
 * USB Mass Storage Gadget
 *
 * Copyright 2005,2006,2008,2009,2010 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * << Mass Storage Common Information Header >>
 *
 */


#ifndef __UAPI_USBG_STORAGE_H__
#define __UAPI_USBG_STORAGE_H__

#include <uapi/linux/usb/specific_gadget/usb_serial.h>

/* for IOCTL(USBG_IOC_STORAGE_SET_INIT_INFO) ---------------------------*/
typedef struct {
    char            *devNode;           /* Device Node Name             */
    unsigned int    drvType;            /* Drive Type                   */
    uint32_t        inquiryDataLen;     /* Inquiry Data Size            */
    char            *pInquiryData;      /* Inquiry Data Pointer         */
    uint32_t        blockNum;           /* Max Block Num                */
    uint32_t        blockLength;        /* Block Length                 */
    char            forceWP;            /* Forced Write Protect         */
    char            driveRemovable;     /* Removable Drive              */
    char            driveLock;          /* Drive Lock ON/OFF            */
    char            flushEnable;        /* Flush Enable/Disable         */
    char            preventEnable;      /* Prevent Enable/Disable       */
    unsigned char   vpdSerialData[USB_SERIAL_A_SIZE];  /* VPD Serial Data              */
} GSTORAGE__InfoInitDrive;

typedef struct {
    unsigned char	opCode;             /* ExtCommand OP code           */
} GSTORAGE__InfoInitExtCmd;

typedef struct {
    int                     num;                /* Max LUN Num          */
    GSTORAGE__InfoInitDrive **ppInfoDrives;     /* Drive Information    */

    int                      extCmdNum;         /* ExtCommand Entry Num   */
    GSTORAGE__InfoInitExtCmd **ppInfoExtCmd;    /* ExtCommand Information */

    uintptr_t               PhySendBuf;
    uintptr_t               PhyReceiveBuf;
    uintptr_t               PhySendReadBuf0[4];
    uintptr_t               PhySendReadBuf1[4];

} GSTORAGE__InfoInit;

/* for IOCTL(USBG_IOC_STORAGE_SET_MEDIA_STATUS) ------------------------*/
#define GSTORAGE_INFO_ATTR_SZ   (96)
typedef struct {
    int lun;                            /* LUN                          */
    int status;                         /* media status                 */
    unsigned int lastLBA;               /* Last LBA                     */
    unsigned int blocks;                /* number of blocks             */
    signed int   writeProtect;          /* write Protect                */
    signed int   mediumType;            /* Media Type Code              */
    unsigned char attr[GSTORAGE_INFO_ATTR_SZ]; /* attribute             */
} GSTORAGE__InfoMediaStatus;

/*  */
/* IOCTL  send, receive Υǡ˻Ȥ				*/
/*  */
typedef struct {
    void           *vp_buf;
    unsigned short us_sz;
} GSTORAGE__data;

/*  */
/* GSTORAGE__KEVENT_ID_EXT_COMMANDåarg	*/
/*  */
typedef struct {
	int				lun;			/* LUN		*/
	unsigned char	CDB[ 12 ];		/* CDB		*/
} GSTORAGE__ExtCmdCDB;

/*  */
/* GSTORAGE__KEVENT_ID_COMP_SET_MEDIA_STATUSåarg	*/
/*  */
typedef struct {
	char	errStat;		/* err status		*/
	int	lun;			/* LUN		*/
} GSTORAGE__CmpSetMediaStatusCDB;

/*  */
/* MassStorage ѥɥ饤ּ ID					*/
/*  */
enum GSTORAGE__DRIVE_ID {
    GSTORAGE__DRIVE_ID_MS = 0,
    GSTORAGE__DRIVE_ID_HDD,
    GSTORAGE__DRIVE_ID_CF,
    GSTORAGE__DRIVE_ID_NAND,
    GSTORAGE__DRIVE_ID_DVD,
    GSTORAGE__DRIVE_ID_HARD,
    GSTORAGE__DRIVE_ID_MSB,
    GSTORAGE__DRIVE_ID_MMC,
    GSTORAGE__DRIVE_ID_SXS,
    GSTORAGE__DRIVE_ID_SXS_ADPT,
    GSTORAGE__DRIVE_ID_DUMMY,
    GSTORAGE__DRIVE_ID_NBROF,
};

/* MS  -------------------------------------------------------------*/
#define GSTORAGE_MEDIA__MS_V1       0x10                /* MS ver.1     */
#define GSTORAGE_MEDIA__MS_MG       0x11                /* MS-MG        */
#define GSTORAGE_MEDIA__MS_R        0x12                /* MS-R         */
#define GSTORAGE_MEDIA__MS_HG       0x19                /* MS-HG        */
#define GSTORAGE_MEDIA__MS_PRO      0x20                /* MS-PRO       */
#define GSTORAGE_MEDIA__MS_XC       0x40                /* MS-XC        */
#define GSTORAGE_MEDIA__MS_IOEX     0x04                /* MS-IOEX      */
#define GSTORAGE_MEDIA__MS_UNDEF    0x00                /* UNDEFINED    */

#define GSTORAGE_MEDIA__MS_MG_CHECK 40                  /* for MG check */

/*  */
/* MassStorage  MEDIA STATUS						*/
/*  */
enum GSTORAGE__MEDIA_STATUS {
    GSTORAGE__MEDIA_UNKNOWN = 0,
    GSTORAGE__MEDIA_READY,
    GSTORAGE__MEDIA_NOT_READY,
    GSTORAGE__MEDIA_ERROR,
    GSTORAGE__MEDIA_NBROF,
};

/*  */
/* MassStorage  MEDIA PROTECT STATUS					*/
/*  */
enum GSTORAGE__MEDIA_PROTECT {
    GSTORAGE_CMD__MEDIA_PROTECT_OFF = 0,
    GSTORAGE_CMD__MEDIA_PROTECT_ON,
};

/*  */
/* MassStorage  LOCK б ID					*/
/*  */
enum GSTORAGE__MEDIA_LOCK_ID {
    GSTORAGE__LOCK_NOT_SUPPORTED = 0,
    GSTORAGE__LOCK_VIRTUAL,
    GSTORAGE__LOCK_REAL,
};

/*  */
/* MassStorageѥ٥IDȥѥ᡼				*/
/*  */
enum GSTORAGE__KEVENT_ID {
    GSTORAGE__KEVENT_ID_COMP_REMOVE = 0,
    GSTORAGE__KEVENT_ID_MASSSTORAGE_IN,
    GSTORAGE__KEVENT_ID_MASSSTORAGE_OUT,
    GSTORAGE__KEVENT_ID_COMP_SET_MEDIA_STATUS,
    GSTORAGE__KEVENT_ID_EXT_COMMAND,
    GSTORAGE__KEVENT_ID_NBROF,
};

/*  */
/* MassStorage  Max DevNode Length					*/
/*  */
#define GSTORAGE_MAX_DEV_NODE_LEN   16

/*  */
/* MassStorage   procfs̾					*/
/*  */
#define GSTORAGE_PROCFS_DIRECTORY   "usbg_storage"
#define GSTORAGE_ACCESS_INFO        "storage_access_info"


struct GSTORAGE__Event {
    void ( * CompRemove         )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
    void ( * MassStorageIN      )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
    void ( * MassStorageOUT     )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
    void ( * CompSetMediaStatus )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
    void ( * ExtCommand         )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
};

#endif	/* __UAPI_USBG_STORAGE_H__ */
