/*
 * kernel/power/wbi_lz77.c
 *
 * WBI LZ77
 *
 * Copyright 2024 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 *
 */
#include <linux/types.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/lz77.h>
#include <mach/noncache.h>
#include "wbi_lz77.h"

#if (WBI_LZ77_MAX_PAYLOAD != PAGE_SIZE)
#error WBI_LZ77_MAX_PAYLOAD != PAGE_SIZE
#endif

static unsigned char lz77cache[PAGE_ALIGN(WBI_LZ77_MAX_PAYLOAD)] __attribute__((aligned(PAGE_SIZE)));
static unsigned char lz77work[PAGE_ALIGN(LZ77_WORKSPACE_SIZE(WBI_LZ77_MAX_PAYLOAD))] __attribute__((aligned(PAGE_SIZE)));

/*------------------------ API ----------------------------*/

#if 0
unsigned int wbi_lz77_min_dst_len(void)
{
	int size = 0;
	const int header    = 1; /* header size */
	const int inst_nr   = 8; /* number of instructions in a instruction packet */
	const int flag      = 1; /* flag size of instruction packet */
	const int imm_inst  = 1; /* IMM instruction size */
	const int term_inst = 2; /* terminator size */

	size += header;
	size += (flag + imm_inst * inst_nr) * ((WB_LZ77_MAX_PAYLOAD + inst_nr - 1) / inst_nr);
	size += (flag + term_inst);

	return size;
}
#endif

int wbi_lz77_deflate(unsigned char **src, unsigned long *src_len, unsigned char *dst, int dst_len)
{
	int sum = 0;

	while ((*src_len > 0 ) && (dst_len >= WBI_LZ77_MIN_DST_LEN)) {
		int slen;
		int ret;

		if (*src_len < WBI_LZ77_MAX_PAYLOAD) {
			return -(*src_len);
		}

		slen = (int)((*src_len <= WBI_LZ77_MAX_PAYLOAD) ? *src_len : WBI_LZ77_MAX_PAYLOAD);
		memcpy(lz77cache, *src, slen);

		ret = lz77_deflate_fast(lz77cache, slen, dst, dst_len, lz77work, sizeof(lz77work));
		if (ret < 0) {
			return ret;
		}

		*src += slen;
		*src_len -= slen;
		dst += ret;
		dst_len -= ret;
		sum += ret;
	}

	return sum;
}
