/*
 * kernel/power/wbi_lz77.h
 *
 * WBI LZ77 header
 *
 * Copyright 2024 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 *
 */

#ifndef __WBI_LZ77_H__
#define __WBI_LZ77_H__

#define WBI_LZ77_MAX_PAYLOAD (4096)
#define WBI_LZ77_MAX_RECORDS (8191)
#define WBI_LZ77_MAX_SLEN (WBI_LZ77_MAX_PAYLOAD * WBI_LZ77_MAX_RECORDS)
#define WBI_LZ77_MIN_DST_LEN (WBI_LZ77_MAX_PAYLOAD + WBI_LZ77_MAX_PAYLOAD/2 + 4)

int wbi_lz77_deflate(unsigned char **src, unsigned long *src_len, unsigned char *dst, int dst_len);

#endif /* __WBI_LZ77_H__ */
