// ------------------------------------------------------------------------
//
//                (C) COPYRIGHT 2011 - 2015 SYNOPSYS, INC.
//                          ALL RIGHTS RESERVED
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  version 2 as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, see <https://gnu.org/licenses/>.
//
// ------------------------------------------------------------------------

#include <elpspacc.h>

/* Read the IRQ status register and process as needed */

uint32_t spacc_process_irq(spacc_device *spacc)
{
	uint32_t temp;
	unsigned long lock_flag;

	PDU_LOCK(&spacc->lock, lock_flag);

	temp = pdu_io_read32(spacc->regmap + SPACC_REG_IRQ_STAT);

	/* clear interrupt pin and run registered callback */
	if (temp & SPACC_IRQ_STAT_STAT) {
		SPACC_IRQ_STAT_CLEAR_STAT(spacc);
		if (spacc->irq_cb_stat != NULL && !pop_jobs_in_isr){
			spacc->irq_cb_stat(spacc);
		}
	}

	PDU_UNLOCK(&spacc->lock, lock_flag);

	return temp;
}
