/*
 * gpio.c
 *
 * GPIO for CXD900XX
 *
 * Copyright 2018 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/module.h>
#include <mach/irqs.h>

#define GPIO_INT	17

/*
 * NAME
 * 	gpiopin_to_irq
 * SYNOPSIS
 *	#include <mach/irqs.h>
 *	int gpiopin_to_irq(unsigned int port, unsigned int bit);
 * INPUT
 *	port: GPIO port number (17=GPIO_INT)
 *       bit: GPIO bit number (0..31)
 * RETURN VALUE
 *      IRQ number
 *	  If input is out of range, -1 shall be returned.
 */
int gpiopin_to_irq(unsigned int port, unsigned int bit)
{
	int irq = -1;

	switch (port) {
	case GPIO_INT:
		if (bit < NR_GPIO_IRQ) {
			irq = IRQ_GPIO_BASE + bit;
		} else if (24 == bit) {
			irq = IRQ_GPIO24;
		} else if (25 == bit) {
			irq = IRQ_GPIO25;
		}
		break;
	default:
		break;
	}
	return irq;
}
EXPORT_SYMBOL(gpiopin_to_irq);
