/*
 * mach-cxd900xx/include/mach/regs-clk.h
 *
 * CXD90057 CLK registers
 *
 * Copyright 2018,2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __REGS_CLK_H
#define __REGS_CLK_H

#include <mach/regs-scu.h>
#define CLK_DATA	SCU_DATA
#define CLK_SET		SCU_SET
#define CLK_CLR		SCU_CLR

/* channels */
#define CLKEN_MEDIA	0
#define CLKEN_RAM	1
# define CLKEN_DDR_ALL	0xFFFFF
#define CLKEN_DMAC	2
#define CLKEN_BRIDGE	3
#define CLKEN_TIMER	4
#define CLKEN_SERIAL	5
#define CLKEN_MISC	6
#define CLKEN_LOGIC	7
#define CLKEN_PCI	8
# define CLKEN_PCI_SHIFT(ch) ((ch) * 6)
# define CLKEN_PCI_APB	  1
# define CLKEN_PCI_DBI	  2
# define CLKEN_PCI_SLV	  3
# define CLKEN_PCI_MST	  4
# define CLKEN_PCI_AUX	  5

/* PLLs */
#define PLL4_DIVN1	3
#define PLL4_DIVN2	4
#define PLL4_DIVN3	5
#define PLL4_DIVN4	6
#define PLL4_DIVN5	7

/* Select */
#define CLKSEL_PLL	0
#define CLKSEL_UART	1
#define CLKSEL_MEDIA	2
#define CLKSEL_SPI	3
#define CLKSEL_DDR	4

#endif /* __REGS_CLK_H */
