/**
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2  of
 * the License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#if !defined(__CRPHY_DEFS_H__)
#define __CRPHY_DEFS_H__

/*
 *    u2phy for Micro
 *
 * int u2phy_adjust(void __iomem *reg, const void *_data, const void *_port);
 */

#define U2PHY_CFGR0                           0x0000

#define U2PHY_CFGR0_r_COMPDISTUNE0_BOFS       0
#define U2PHY_CFGR0_r_COMPDISTUNE0_MSK        (0x7)
#define U2PHY_CFGR0_r_COMPDISTUNE0_MAG        (8)

#define U2PHY_CFGR1                           0x0004

#define U2PHY_CFGR1_r_TXVREFTUNE0_BOFS        1
#define U2PHY_CFGR1_r_TXVREFTUNE0_MSK         (0x0f)
#define U2PHY_CFGR1_r_TXVREFTUNE0_MAG         (3)

#define U2PHY_CFGR1_r_TXPREEMPPULSETUNE0_BOFS 2
#define U2PHY_CFGR1_r_TXPREEMPPULSETUNE0_MSK  (0x1)
#define U2PHY_CFGR1_r_TXPREEMPPULSETUNE0_MAG  (2)

#define U2PHY_CFGR1_r_TXPREEMPAMPTUNE0_BOFS   3
#define U2PHY_CFGR1_r_TXPREEMPAMPTUNE0_MSK    (0x3)
#define U2PHY_CFGR1_r_TXPREEMPAMPTUNE0_MAG    (0)

/*#define U2PHY_CFGR0                           0x0000*/

#define U2PHY_CFGR0_r_SQRXTUNE0_BOFS          4
#define U2PHY_CFGR0_r_SQRXTUNE0_MSK           (0x7)
#define U2PHY_CFGR0_r_SQRXTUNE0_MAG           (25)



/*
 *    cr phy31
 *
 * int cr_phy31_adjust(void __iomem *reg, const void *data);
 * int cr_phy31_adjust_post_csftrst(void __iomem *reg, const void *_data);
 */

#define SUP_DIG_LVL_OVRD_IN                     0x003c
#define SD_LVL_TX_VBOOST_LVL_EN_BOFS  5
#define SD_LVL_TX_VBOOST_LVL_EN_MSK   (0x1)
#define SD_LVL_TX_VBOOST_LVL_EN_MAG   (9)
#define SD_LVL_TX_VBOOST_LVL_BOFS     6
#define SD_LVL_TX_VBOOST_LVL_MSK      (0x7)
#define SD_LVL_TX_VBOOST_LVL_MAG      (6)

#define CRPHY_NUM_LANES       (4)
#define CRPHY_DATA_START_BOFS (SD_LVL_TX_VBOOST_LVL_BOFS+1)
#define CRPHY_NUM_LANE_DATA   (27)

#define CRPHY_CH_OFSET(a)               (0x100*4*(a))
/*
#define CRPHY_SUP_DIG_LVL_OVRD_IN_BOOST_EN_MASK  (1<<9)
#define CRPHY_SUP_DIG_LVL_OVRD_IN_BOOST_EN_VAL   CRPHY_SUP_DIG_LVL_OVRD_IN_BOOST_EN_MASK
#define CRPHY_SUP_DIG_LVL_OVRD_IN_BOOST_LV_MASK  (7<<6)
#define CRPHY_SUP_DIG_LVL_OVRD_IN_BOOST_LV_VAL   CRPHY_SUP_DIG_LVL_OVRD_IN_BOOST_LV_MASK
*/

#define LANEN_DIG_ASIC_TX_OVRD_IN_1(a)          (0x4008+CRPHY_CH_OFSET(a))
#define LDA_TX_MAIN_OVRD_EN_BOFS     0
#define LDA_TX_MAIN_OVRD_EN_MSK      (0x1)
#define LDA_TX_MAIN_OVRD_EN_MAG      (15)
#define LDA_TX_MAIN_CURSOR_BOFS      1
#define LDA_TX_MAIN_CURSOR_MSK       (0x3f)
#define LDA_TX_MAIN_CURSOR_MAG       (9)
#define LANEN_DIG_ASIC_TX_OVRD_IN_2(a)          (0x400C+CRPHY_CH_OFSET(a))
#define LDA_TX_POST_OVRD_EN_BOFS     2
#define LDA_TX_POST_OVRD_EN_MSK      (0x1)
#define LDA_TX_POST_OVRD_EN_MAG      (13)
#define LDA_TX_POST_CURSOR_BOFS      3
#define LDA_TX_POST_CURSOR_MSK       (0x3f)
#define LDA_TX_POST_CURSOR_MAG       (7)
#define LDA_TX_PRE_OVRD_EN_BOFS      4
#define LDA_TX_PRE_OVRD_EN_MSK       (0x1)
#define LDA_TX_PRE_OVRD_EN_MAG       (6)
#define LDA_TX_PRE_CURSOR_BOFS       5
#define LDA_TX_PRE_CURSOR_MSK        (0x3f)
#define LDA_TX_PRE_CURSOR_MAG        (0)

#define RAWLANEN_DIG_PCS_XF_TX_OVRD_IN_1(a)     (0xC004+CRPHY_CH_OFSET(a))
#define RD_RESET_OVRD_EN_BOFS        6
#define RD_RESET_OVRD_EN_MSK         (0x1)
#define RD_RESET_OVRD_EN_MAG         (1)
#define RD_RESET_OVRD_VAL_BOFS       7
#define RD_RESET_OVRD_VAL_MSK        (0x1)
#define RD_RESET_OVRD_VAL_MAG        (0)
#define RD_VBOOST_EN_OVRD_EN_BOFS    8
#define RD_VBOOST_EN_OVRD_EN_MSK     (0x1)
#define RD_VBOOST_EN_OVRD_EN_MAG     (7)
#define RD_VBOOST_EN_OVRD_VAL_BOFS   9
#define RD_VBOOST_EN_OVRD_VAL_MSK    (0x1)
#define RD_VBOOST_EN_OVRD_VAL_MAG    (6)
/*#define RAWLANEN_DIG_PCS_XF_TX_OVRD_IN_1(a)     (0xC004+CRPHY_CH_OFSET(a))*/
#define RD_IBOOST_LVL_OVRD_EN_BOFS   10
#define RD_IBOOST_LVL_OVRD_EN_MSK    (0x1)
#define RD_IBOOST_LVL_OVRD_EN_MAG    (12)
#define RD_IBOOST_LVL_OVRD_VAL_BOFS  11
#define RD_IBOOST_LVL_OVRD_VAL_MSK   (0x0f)
#define RD_IBOOST_LVL_OVRD_VAL_MAG   (8)

#define LANEN_DIG_ASIC_RX_OVRD_IN_3(a)          (0x4028+CRPHY_CH_OFSET(a))
#define LDA_LOS_OVRD_EN_BOFS         12
#define LDA_LOS_OVRD_EN_MSK          (0x1)
#define LDA_LOS_OVRD_EN_MAG          (14)
#define LDA_LOS_LFPS_EN_BOFS         13
#define LDA_LOS_LFPS_EN_MSK          (0x1)
#define LDA_LOS_LFPS_EN_MAG          (13)
#define LDA_LOS_THRSHLD_BOFS         14
#define LDA_LOS_THRSHLD_MSK          (0x7)
#define LDA_LOS_THRSHLD_MAG          (10)
#define LDA_DISABLE_OVRD_EN_BOFS     15
#define LDA_DISABLE_OVRD_EN_MSK      (0x1)
#define LDA_DISABLE_OVRD_EN_MAG      (9)
#define LDA_DISABLE_BOFS             16
#define LDA_DISABLE_MSK              (0x1)
#define LDA_DISABLE_MAG              (8)
#define RAWLANEN_DIG_RX_CTL_RX_LOS_MASK_CTL(a)  (0xC384+CRPHY_CH_OFSET(a))
#define RD_RX_LOS_MASK_CNT_LSB_BOFS  17
#define RD_RX_LOS_MASK_CNT_LSB_MSK   (0x0ff)
#define RD_RX_LOS_MASK_CNT_LSB_MAG   (0)
#define RD_RX_LOS_MASK_CNT_MSB_BOFS  18
#define RD_RX_LOS_MASK_CNT_MSB_MSK   (0x1)
#define RD_RX_LOS_MASK_CNT_MSB_MAG   (8)

#define LANEN_DIG_ASIC_RX_OVRD_EQ_IN_1(a)       (0x4038+CRPHY_CH_OFSET(a))
#define LDA_RX_EQ_OVRD_EN_BOFS       19
#define LDA_RX_EQ_OVRD_EN_MSK        (1)
#define LDA_RX_EQ_OVRD_EN_MAG        (15)
#define LANEN_DIG_ASIC_RX_OVRD_EQ_IN_0(a)       (0x4034+CRPHY_CH_OFSET(a))
#define LDA_RX_EQ_CTLE_BOOST_BOFS    20
#define LDA_RX_EQ_CTLE_BOOST_MSK     (0x1f)
#define LDA_RX_EQ_CTLE_BOOST_MAG     (11)
#define LDA_RX_EQ_AFE_GAIN_BOFS      21
#define LDA_RX_EQ_AFE_GAIN_MSK       (0x0f)
#define LDA_RX_EQ_AFE_GAIN_MAG       (3)
#define LDA_RX_EQ_ATT_LVL_BOFS       22
#define LDA_RX_EQ_ATT_LVL_MSK        (0x3)
#define LDA_RX_EQ_ATT_LVL_MAG        (0)
/*#define LANEN_DIG_ASIC_RX_OVRD_EQ_IN_1(a)       (0x4038+CRPHY_CH_OFSET(a))*/
#define LDA_RX_EQ_DFE_TAP1_BOFS      23
#define LDA_RX_EQ_DFE_TAP1_MSK       (0x0ff)
#define LDA_RX_EQ_DFE_TAP1_MAG       (7)
#define LDA_RX_EQ_DFE_TAP2_BOFS      24
#define LDA_RX_EQ_DFE_TAP2_MSK       (0x7f)
#define LDA_RX_EQ_DFE_TAP2_MAG       (0)

#define RAWLANEN_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN(a)       (0xC064+CRPHY_CH_OFSET(a))
#define RD_RX_EQ_DELTA_IQ_OVRD_EN_BOFS     25
#define RD_RX_EQ_DELTA_IQ_OVRD_EN_MSK      (0x1)
#define RD_RX_EQ_DELTA_IQ_OVRD_EN_MAG      (4)
#define RD_RX_EQ_DELTA_IQ_OVRD_VAL_BOFS    26
#define RD_RX_EQ_DELTA_IQ_OVRD_VAL_MSK     (0x0f)
#define RD_RX_EQ_DELTA_IQ_OVRD_VAL_MAG     (0)

/*
 *    u2phy for Type-C
 *
 * int u2phy_adjust(void __iomem *reg, const void *_data, const void *_port);
 */
#define U2PHY_TPC_DATA_START_BOFS (CRPHY_DATA_START_BOFS + CRPHY_NUM_LANES * CRPHY_NUM_LANE_DATA)

#endif  /* __CRPHY_DEFS_H__ */
