/*
 * drivers/usb/f_usb/usb_otg.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*--------------------------------------------------------------------------*
 * drivers/usb/scd/scd_device.c
 *
 * OTG and, Platform bus driver operations
 *
 * Copyright 2011 Sony Corporation
 *
 * This file is part of the HS-OTG Controller Driver SCD.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *---------------------------------------------------------------------------*/

#ifndef _USB_OTG_H_
#define _USB_OTG_H_

#include <linux/usb/f_usb/usb_otg_notify.h>

#define FUSB_VERSION			20180719U

#define FUSB_OTG_OK			0

#define FUSB_OTG_FLAG_OFF		0
#define FUSB_OTG_FLAG_ON		1U

#define FUSB_PROC_NAME			"fusb"

#define FUSB_IPRESET_MS_TIME		1U

#define FUSB_DEVICE_CONNETCT_TIMER	100U

#define FUSB_INITIAL_BASE		((void *)(0xFFFF8000U))

#define current_otg_mode		g_fusb_device_control->otg_mode

#ifndef TEST_USB_CNTL_DRV
/* Release   */
#define fusb_lock(lock) 		spin_lock_irq(lock)
#define fusb_unlock(lock)		spin_unlock_irq(lock)
#else  /* #ifndef TEST_FUSB_DRV */
/* USB Controller Driver Test */
#define fusb_lock(lock) {						\
		fusb_lock_cnt++;					\
		spin_lock_irq(lock);					\
	}
#define fusb_unlock(lock) {						\
		spin_unlock_irq(lock); 				\
		fusb_lock_cnt--;					\
	}
#endif /* #ifndef TEST_GPIO_DRV */

struct fusb_device_control {
	struct usb_otg_control otgc;

	void __iomem *otg_regs;
	void __iomem *host_regs;
	void __iomem *gadget_regs;
	void __iomem *global_regs;

	int otg_mode;
	int cid;
	enum usb_otg_vbus_stat vbus;
	int init_comp_flag;
	volatile unsigned int host_resume_comp_flag;

	struct usb_otg_dwc3_ops *dwc3_ops;
	struct usb_otg_dwc3_of_cxd_ops *dwc3_of_cxd_ops;
	int port_type;
};

static inline struct fusb_device_control *otgc_to_fusb(struct usb_otg_control *otgc) {
	return container_of(otgc, struct fusb_device_control, otgc);
}

static int fusb_get_port_info(struct usb_otg_control *otg_control,
			      struct usb_otg_control_port_info *info);
static int fusb_select_port(struct usb_otg_control *otg_control, unsigned int pn);
static int fusb_start_control(struct usb_otg_control *otg_control);
static int fusb_stop_control(struct usb_otg_control *otg_control);
static int fusb_start_gadget(struct usb_otg_control *otg_control);
static int fusb_stop_gadget(struct usb_otg_control *otg_control);
static int fusb_enable_rchost(struct usb_otg_control *otg_control);
static int fusb_disable_rchost(struct usb_otg_control *otg_control);
static int fusb_stop_rchost(struct usb_otg_control *otg_control);
static int fusb_start_host(struct usb_otg_control *otg_control);
static int fusb_stop_host(struct usb_otg_control *otg_control);
static int fusb_start_rcgadget(struct usb_otg_control *otg_control, unsigned int port);
static int fusb_stop_rcgadget(struct usb_otg_control *otg_control, unsigned int port);
static int fusb_get_mode(struct usb_otg_control *otg_control);
static int fusb_request_session(struct usb_otg_control *otg_control);
static int fusb_set_speed(struct usb_otg_control *otg_control, unsigned int speed);
static enum usb_otg_control_speed fusb_get_speed(struct usb_otg_control *otg_control);

static int fusb_set_test_mode(struct usb_otg_control *otg_control,
			      enum usb_otg_control_test_mode test_mode);
static enum usb_otg_control_test_mode fusb_get_test_mode(struct usb_otg_control *otg_control);

static int fusb_set_tpc_setting(struct usb_otg_control *otg_control, int orientation, int ss_operation);
static int fusb_set_phy(const void *data);
static int fusb_set_port_type(int type);

static int fusb_try_start_control(struct fusb_device_control *fusb);
static int fusb_try_stop_control(struct fusb_device_control *fusb);
static int fusb_try_start_gadget(struct fusb_device_control *fusb);
static int fusb_try_stop_gadget(struct fusb_device_control *fusb);
static int fusb_try_start_host(struct fusb_device_control *fusb);
static int fusb_try_stop_host(struct fusb_device_control *fusb);

#endif  /* _USB_OTG_H_ */
