
/*******************************************************************************//**
 * @file    usbg_buspower_main.c
 * @brief   USB Gadget BusPower Driver - main
 * 
 * Copyright 2011 Sony Corporation
 * Copyright 2018, 2019 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *******************************************************************************/

/*=============================================================================
/  Includes
/==============================================================================*/

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/version.h>
#include <linux/usb/ch9.h>
#include <linux/device.h>
#include <linux/usb/gadget.h>

#include <linux/usb/gcore/usb_event.h>
#include <linux/usb/gcore/usb_gadgetcore.h>

#include <linux/udif/cdev.h>
#include <mach/udif/devno.h>

#include <linux/usb/specific_gadget/usbg_cmn.h>

#define FNAME "usbg_buspower_main.c"
#include "usbg_buspower_pvt.h"

MODULE_AUTHOR("Sony Corporation");
MODULE_DESCRIPTION(USBG_BUSPWR_FUNC_NAME);
MODULE_VERSION(USBG_BUSPWR_VER);
MODULE_LICENSE("GPL");

/*=============================================================================
/  Enumerations
/==============================================================================*/


/*=============================================================================
/  Structs
/==============================================================================*/

/**
 *  @brief  File operations
 */
static struct UDIF_CDEV_OPS usbg_buspower_core_fops = {
    .open    = usbg_buspower_core_open,
    .close   = usbg_buspower_core_release,
    .ioctl   = usbg_buspower_core_ioctl,
    .write   = usbg_buspower_core_write,
};

/**
 *  @brief  Core driver information
 */
static struct usbg_cdev usbg_buspower_core_dev = {
    .node = udif_device_node( UDIF_NODE_USB_GADGET_BUSPOWER ),
    .fops = &usbg_buspower_core_fops,
};


/*=============================================================================
/  Prototypes
/==============================================================================*/


/*=============================================================================
/  Variable Declarations
/==============================================================================*/


/*=============================================================================
/  Functions
/==============================================================================*/

/*
 *  @brief  Driver load
 */
static int __init start_module( void )
{
    
    int err;
    
    USBG_BUSPWR_PINF( "Calling: %s() ", __FUNCTION__ );
    
    // Register core driver
    err = usbg_cmn_reg( &usbg_buspower_core_dev );
    
    if( err ){
        
        USBG_BUSPWR_PERR( "%s():Failed to register core driver. error code is %d", __FUNCTION__, err );
        return err;
        
    }
    
    // Create "this" instance
    err = usbg_buspower_create_this();
    
    USBG_BUSPWR_LOCK_INI();
    
    USBG_BUSPWR_PDEBUG( "Leaving: %s() , return val is %d ", __FUNCTION__, err );
    
    return err;
    
}

/*
 *  @brief  Driver unload
 */
static void __exit stop_module( void )
{
    
    USBG_BUSPWR_PINF( "Calling: %s() ", __FUNCTION__ );
    
    // Delete "this" instance
    usbg_buspower_delete_this();
    
    usbg_cmn_dereg( &usbg_buspower_core_dev );
    
    USBG_BUSPWR_PDEBUG( "Leaving: %s()", __FUNCTION__ );
    
}

// module_init/module_exit
module_init( start_module );
module_exit( stop_module );

