/*
 * usbg_storage_drvcnt.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Drive Controller Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_DRVCNT_H__	    /* ť󥯥롼ɥ顼ɻ */
#define __USBG_STORAGE_DRVCNT_H__
/*

 󥯥롼ɥե                                                 
*/
#include "usbg_storage_cmn.h"
#include "usbg_storage_cmd.h"

/*

                                                              
*/
/* ޥɼ¹ԥơ */
#define GSTORAGE_DRV__PASS      0
#define GSTORAGE_DRV__FAIL      1
#define GSTORAGE_DRV__FATAL     2
#define GSTORAGE_DRV__CONTINUE  3

/* Unit Status */
#define GSTORAGE__UNIT_NOT_EJECT_START  0   /* Mode : Not Eject & Start */
#define GSTORAGE__UNIT_NOT_EJECT_STOP   1   /* Mode : Not Eject & Stop  */
#define GSTORAGE__UNIT_EJECT            2   /* Mode : Eject             */

/* error type	*/
#define GSTORAGE__RES_OK        0
#define GSTORAGE__RES_STATUS    1
#define GSTORAGE__RES_PTR       2
#define GSTORAGE__RES_PARAM     3
#define GSTORAGE__RES_NOTREADY  4
#define GSTORAGE__RES_SYS       5

/*

                                                                
*/
/* typedef ******************************************************************/
/* ¤ ==================================================================*/
typedef struct  _GSTORAGE_DRV__PreReadInfo   GSTORAGE_DRV__PreReadInfo;
typedef struct  _GSTORAGE_DRV__ContinueInfo  GSTORAGE_DRV__ContinueInfo;
typedef struct  _GSTORAGE_DRV__MediaInfo     GSTORAGE_DRV__MediaInfo;
typedef struct  _GSTORAGE_DRV__SenseCode     GSTORAGE_DRV__SenseCode;
typedef struct  _GSTORAGE_DRV__MsInfo        GSTORAGE_DRV__MsInfo;
typedef struct  _GSTORAGE_DRV__DeviceContext GSTORAGE_DRV__DeviceContext;
typedef struct  _GSTORAGE_DRV__UnitContext   GSTORAGE_DRV__UnitContext;
typedef struct  _GSTORAGE_DRV__CmdContext    GSTORAGE_DRV__CmdContext;
/* ؿ ====================================================================*/
typedef unsigned int ( *GSTORAGE__CmdCb )( void * );
typedef unsigned int ( *GSTORAGE__CmdProc )( GSTORAGE_DRV__CmdContext * );


/* ¤ */
/* ɤ߾ ==============================================================*/
struct _GSTORAGE_DRV__PreReadInfo {
    unsigned char    *pAccessBuf;   /* ѥХåեݥ           */
    signed long long startAddr;     /* åѤƬɥ쥹           */
    signed long long nextAddr;      /* ˥åͽƬɥ쥹     */
};

/* ʬѾ ==========================================================*/
struct _GSTORAGE_DRV__ContinueInfo {
    GSTORAGE__CmdProc pProc;        /* ³δؿݥ               */
    signed long long address;       /* ɥ쥹(Read/Write Buffer Ǥ LBA) */
    unsigned int remainLen;         /* žĤǡĹ                     */
                                    /* (Read/Write Buffer Ǥ ĥ֥å */
    unsigned int remainLenCdb;      /* CDBžĤǡĹ                  */
                                    /* (Read/Write Ǥ ĥ֥å        */
    unsigned int transferLen;       /* žѤߤΥǡĹ( Byte )           */
                                    /* (󥳥ޥɼ˥ꥢ)         */
    unsigned char extcmd;           /* ޥɤĥޥɤξON   */
                                    /* ΥޥɼOFF                */
};

/* ǥȤξ(DVD) =========================================*/
struct _GSTORAGE_DRV__MediaInfo {
    unsigned int lastLBA;           /* Last LBA : open(blocks - 1)    */
    unsigned int blockLength;       /* ֥åĹ 512 ()                */
    unsigned int blocks;            /* Block Open (lastLBA + 1)     */
    signed int   writeProtect;      /* MS:ץ , ¾:0             */
    signed int   mediumType;        /* Media Type Code                      */
    signed int   mediaStatus;       /* Media Ready/NotReady/Error           */
    signed int   unitStatus;        /* Unit                   */
    signed int   changed;           /* Media ȴȯե饰(Media ̵ͭ    */
                                    /* ѲꡢSenseCode Фǥꥢ)  */
};

/* SENSE ===================================================================*/
struct _GSTORAGE_DRV__SenseCode {
    unsigned char sense;
    unsigned char asc;
    unsigned char ascq;
    unsigned char reserved;
};

/* ME INFO =================================================================*/
struct _GSTORAGE_DRV__MsInfo {
    unsigned char attribute[ GSTORAGE_INFO_ATTR_SZ ];
};

/* DEVICE CONTEXT ==========================================================*/
struct _GSTORAGE_DRV__DeviceContext{
    /* LUN ˴طʤ --------------------------------------------------*/
    unsigned int maxLun;
    /* LUN ξ --------------------------------------------------------*/
    GSTORAGE_DRV__UnitContext *pUnitCtx[ GSTORAGE__MAX_UNIT ];
    /* Command Context -----------------------------------------------------*/
    GSTORAGE_DRV__CmdContext *pCmdCtx;
    /* ĥޥϿ ------------------------------------------------*/
    unsigned int                extCmdNum;
    GSTORAGE__InfoInitExtCmd    *pExtCmd[ GSTORAGE__EXTCMD_MAX_ENTNUM ];
    struct file                 *fd_ext;            /* extcmd fd            */
    char                        *extNode;           /* ext Node Name        */
};

/* UNIT CONTEXT ============================================================*/
struct _GSTORAGE_DRV__UnitContext {
    /* Device Context ------------------------------------------------------*/
    GSTORAGE_DRV__DeviceContext *pDevCtx;
    /* Svc  ------------------------------------------------*/
    unsigned char *pSendBuf;                /* ѥХåե(Readʳ)     */
    unsigned char *pReceiveBuf;             /* ѥХåե()         */
    unsigned char *pSendReadBuf[ 2 ];       /* read ѤǡХåե  */
    GSTORAGE__InfoInitDrive *pDrive;        /* ɥ饤־                 */
    /* Open ꤹ -----------------------------------------------*/
    struct file               *fd;          /* file ݥ(Open )   */
    GSTORAGE_DRV__MediaInfo   media;        /* ǥ                 */
    union {
        GSTORAGE_DRV__MsInfo  *pMsInfo;     /* MS ͭ(Attribute )*/
        unsigned char         *pExt;        /* ͭؤΥݥ(̤) */
    } mediaExt;
    GSTORAGE_CMD__DatReadCapa DatReadCapa;  /* Read Capacity Data           */
    /* ¾ --------------------------------------------------------------*/
    GSTORAGE_DRV__SenseCode    sense;              /* SenseCode(DVD ʳ)   */
    unsigned char              senseDvd[ 64 ];     /* SenseCode(DVD )     */
    unsigned char              senseFlg;           /* SenseCode   */
    GSTORAGE_DRV__PreReadInfo  preRead;            /* ɤ߾            */
    GSTORAGE_DRV__ContinueInfo continueInfo;       /* ʬ          */
    unsigned char              mediaAccess;        /* Media Access check  */
    unsigned char              currentLock;        /* LOCK              */
    unsigned char              driveReset;         /* Drive Reset       */
};

/* COMMAND CONTEXT ---------------------------------------------------------*/
struct _GSTORAGE_DRV__CmdContext {
    /* Unit Context --------------------------------------------------------*/
    GSTORAGE_DRV__UnitContext    *pUnitCtx;
    /* Main Controller  ------------------------------------*/
    GSTORAGE__Cbw *pCbw;                        /* CBWؤΥݥ          */
    GSTORAGE__Cdb *pCdb;                        /* CDBؤΥݥ          */
    unsigned int cdbLength;                     /* CDBΥ(12byte)      */
    unsigned int dio;                           /* ǡž           */
    unsigned int expectDatLen;                  /* ž׵᥵           */
    /* Main Controller ֤ ------------------------------------------*/
    unsigned char *pData;                   /* ǡΥХåեݥ */
    unsigned char status;                   /* Status                       */
    /* Drive Controller ǤΤ߻Ȥ ---------------------------------*/
    unsigned int totalTransLen;     /* ʬѤߤΥ   */
                                    /*       ʬκݤ continue.transLen   */
                                    /*       ܺ륵           */
                                    /* ʬǽѤߤΥ   */
                                    /*       ʬκݤ continue.transLen   */
                                    /*       ܺ           */
    GSTORAGE__CmdCb cb;             /* ؿݥ( ɤ߽ )   */
    void            *pProcParam;    /* ؿϤѥ᡼Υݥ */
};

/*

 饹                                                           
*/

/*

 ؿ                                                         
*/
/* Drive Controller Thread ׵ ----------------------------------------*/
extern void storage_drvcnt_reqStopThread( GSTORAGE__Cb );
/* ǥХϿ ------------------------------------------------------*/
extern signed int storage_drvcnt_setInitInfo( signed int, GSTORAGE__InfoInitCmn *,
                                              GSTORAGE__InfoInitLun ** );
/* ǥХκ ------------------------------------------------------*/
extern void storage_drvcnt_clearInitInfo( void );
/* ǥХκ ------------------------------------------------------*/
extern unsigned char *storage_drvcnt_getReceiveBufP( signed int );
/* Drive Controller  ---------------------------------------------------*/
extern void storage_drvcnt_startDrvCnt( GSTORAGE__StartCb );
/* Drive Controller  ---------------------------------------------------*/
extern void storage_drvcnt_stopDrvCnt( GSTORAGE__Cb );
/* Set Media Status ׵ ---------------------------------------------------*/
extern void storage_drvcnt_reqSetMediaStatus( GSTORAGE__MedStatCb, GSTORAGE__InfoMediaStatus * );
/* Check Media Access ׵ -------------------------------------------------*/
extern void storage_drvcnt_checkMediaAccess( unsigned char * );
/* Check Media Access Ԥ -------------------------------------------------*/
extern int storage_drvcnt_waitMediaAccess( void );
/* Set Media Access ׵ ---------------------------------------------------*/
extern void storage_drvcnt_setMediaAccess( GSTORAGE_DRV__UnitContext * );
/* ޥ ------------------------------------------------------------*/
extern void storage_drvcnt_sndCmdPacket( GSTORAGE__PacketCb, GSTORAGE__Packet * );
extern void storage_drvcnt_sndCmdContinue( GSTORAGE__PacketCb );
/* alloc Drive Controller --------------------------------------------------*/
extern signed int storage_drvcnt_allocThread( void );
/* free Drive Controller ---------------------------------------------------*/
extern void storage_drvcnt_freeThread( void );
/* ext Command Drive Controller --------------------------------------------*/
extern int storage_drvcnt_extcmdOpen(void);
extern int storage_drvcnt_extcmdClose(void);
extern int storage_drvcnt_extcmdCancel(void);

/*

 ѿ                                                         
*/

#endif/*__USBG_STORAGE_DRVCNT_H__*/

