/*
 * include/linux/usb/f_usb/fusb_dwc3.h
 *
 * Copyright 2019 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined(__FUSB_DWC3_H__)
#define __FUSB_DWC3_H__

#include <linux/platform_device.h>

#define FUSB_DWC3_PORT_TYPE_MICRO (0)
#define FUSB_DWC3_PORT_TYPE_TYPEC (1)

struct usb_otg_dwc3_ops {
	struct platform_device *pdev;			/**<  */
	int (*stop) (struct platform_device *);			/**<  */
	int (*start) (struct platform_device *);			/**<  */
	int (*wait_gadget) (struct platform_device *);			/**<  */
	void (*set_limited_gadget_speed) (struct platform_device *, unsigned);			/**<  */
};

void fusb_otg_dwc3_bind(struct usb_otg_dwc3_ops *ops);


struct usb_otg_dwc3_of_cxd_ops {
	struct platform_device *pdev;			/**<  */
	int (*set_phy) (struct platform_device *, const void *, const void *);			/**<  */
};
void fusb_otg_dwc3_of_cxd_bind(struct usb_otg_dwc3_of_cxd_ops *ops);

#endif  /* __FUSB_DWC3_H__ */
