/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __USBD_CMN_H__
#define __USBD_CMN_H__


#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 21)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <uapi/linux/usb/specific_gadget/usbg_type.h>
#include <linux/usb/gcore/usb_gadgetcore.h>

#ifdef CONFIG_OSAL_UDIF
#include <linux/udif/cdev.h>
#endif

/*  */
/* Core->Function٥						*/
/* 	CoreΥ٥ȥХå				*/
/*  */
struct core_event{
    void(*start)( struct usb_gadget_func_driver* p_drv,
                  int speed,
                  unsigned char alt,
                  struct usb_gadget_ep_list list );
    void(*stop)( struct usb_gadget_func_driver* p_drv );
    int(*ep_set_halt)( struct usb_gadget_func_driver* p_drv,
                       struct usb_ep* p_ep );
    int(*ep_clear_halt)( struct usb_gadget_func_driver* p_drv,
                         struct usb_ep* p_ep );
    void(*suspend)( void );
    void(*resume)( void );
    int(*class_req)( struct usb_gadget_func_driver* p_drv,
                  struct usb_ctrlrequest* p_ctrl,
                  struct usb_ep* p_ep );
    int(*vendor_req)( struct usb_gadget_func_driver* p_drv,
                  struct usb_ctrlrequest* p_ctrl,
                  struct usb_ep* p_ep );
};
/*  */
/* Function󥹥󥹤Υ						*/
/*  */
struct func_data {
    /* Svcꤵ					*/
    /* ioctlprobe()Ƿޤ					*/
    struct probe_info info;
    /* FunctionǻȤ					*/
    /* open()ƥॳǷޤ				*/
    
    struct usb_gadget_func_driver core_reg_info;
    					/* Coreؤregister		*/
    struct usb_gadget_func_driver extended_core_reg_info;
                        /* OTG Core register info for Bus/Self Power Setting */
    unsigned char uc_core_reg_entry;	/* register		*/
    
    /* start()٥Ȥǳꤹ				*/
    char c_configuration;		/* Configuration		*/
    char c_alternate;			/* Alternate			*/
    char c_interface;			/* Interface			*/
    
    struct usb_ep** ptbl_ep;		/* EPΥꥹ		*/
    unsigned char uc_ep_num;		/* endpointο			*/

    void *vp_user;			/* ĥ				*/
};

#ifdef CONFIG_OSAL_UDIF
/*  */
/* USB charactor device regist info                                     */
/*  */
struct usbg_cdev {
    struct UDIF_CDEV       cdev;  /* charactor device info */
    UDIF_DEVNODE           *node; /* device node info      */
    struct UDIF_CDEV_OPS   *fops; /* file operations       */
};

int usbg_cmn_reg( struct usbg_cdev* p_this_dev );
void usbg_cmn_dereg( struct usbg_cdev* p_this_dev );
#else
int usbg_cmn_reg( struct sonymisc_device* p_this_dev );
void usbg_cmn_dereg( struct sonymisc_device* p_this_dev );
#endif
int usbg_cmn_new(struct inode *inode, struct file *fd);
void usbg_cmn_delete( struct func_data* p_this );
int usbg_cmn_copy_probe_info( struct func_data* p_this,
                                     struct probe_info *p_info );
void usbg_cmn_clear_probe_info( struct func_data* p_this );
int usbg_cmn_make_ep_list( struct func_data* p_this,
                                  unsigned char alt,
                                  struct usb_gadget_ep_list list );
void usbg_cmn_clear_ep_list( struct func_data* p_this );

#endif
