#ifndef USB__COMPOSITE_IO__H
#define USB__COMPOSITE_IO__H

#include <uapi/linux/usb/video.h>

#define FS_COMPOSITE_IO "/proc/usb_gadget"

struct usb_device_desc_overwrite {
    uint16_t idVendor;
    uint16_t idProduct;
    uint16_t bcdDevice;
};

struct usb_config_desc_overwrite {
    uint8_t  bmAttributes;
    uint16_t bMaxPower_hs;
    uint16_t bMaxPower_ss;
};

struct usb_string_desc {
    uint8_t len;
    char    *s;
};

struct usb_string_desc_overwrite {
    struct usb_string_desc *manufacturer;
    struct usb_string_desc *product;
    struct usb_string_desc *serial;
};

struct usb_ssp_cap_descriptor_m {
    uint8_t  bLength;
    uint8_t  bDescriptorType;
    uint8_t  bDevCapabilityType;
    uint8_t  bReserved;
    uint32_t bmAttributes;
    uint16_t wFunctionalitySupport;
    uint16_t wReserved;
    uint32_t bmSublinkSpeedAttr[32]; /* size fixed */
} __attribute__((packed));

struct usb_bos_desc_overwrite {
    struct usb_bos_descriptor       *bos;
    struct usb_ext_cap_descriptor   *cap_ext;
    struct usb_ss_cap_descriptor    *cap_ss;
    struct usb_ssp_cap_descriptor_m *cap_ssp;
};

struct gadget_desc_overwrite_table {
    struct usb_device_desc_overwrite    *device;
    struct usb_config_desc_overwrite    *config;
    struct usb_string_desc_overwrite    *string;
    struct usb_bos_desc_overwrite       *bos;
};

#endif /*  USB__COMPOSITE_IO__H */
