/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __UAPI_USB_IOCTL_H__
#define __UAPI_USB_IOCTL_H__

#include <asm/ioctl.h>
#include <linux/ioctl.h>

/* IOCTLޥåʥС						*/
/* SequenceʥСϸġ					*/
#define USB_IOC_CMN		0xE0	/* IO			*/
#define USB_IOC_EVENT		0xE1	/* Event			*/
#define USB_IOC_GADGETCORE	0xE2	/* Gadget Core			*/
#define USB_IOC_OTGCORE	0xE3	/* OTG Core			*/
#define USB_IOC_MASSSTORAGE	0xE4	/* Mass storage			*/
#define USB_IOC_SICD_CORE	0xE5	/* Still image core		*/
#define USB_IOC_SICD_DATA	0xE6	/* Still image data		*/
#define USB_IOC_SICD_EVENT	0xE7	/* Still image event		*/
#define USB_IOC_SE		0xE8	/* se				*/
#define USB_IOC_TE		0xE9	/* te				*/
#define USB_IOC_VSPE		0xEA	/* Vspe				*/
#define USB_IOC_EXT_CMD		0xEB	/* Extension command		*/
#define USB_IOC_USBCORE		0xEC	/* USB Core(Host Core)		*/
#define USB_IOC_SCSI		0xED	/* SCSI				*/
#define USB_IOC_CURRENT		0xEE	/* Current Driver		*/
#define USB_IOC_ADB			0xEF	/* ADB Driver				*/
/* ɲä롣							*/
#define USBG_IOC_STD		0xF0	/* test				*/
/* USBG_IOC_STD(ƥ)Ŭ					*/
#define USBG_IOC_IAP		0xF1	/* iAP Driver	*/

/* SequenceʥС							*/
#define USB_IOC_CMN_PROBE	_IOW( USB_IOC_CMN, 0, struct probe_info )
#define USB_IOC_CMN_REMOVE	_IO( USB_IOC_CMN, 1 )
#define USB_IOC_CMN_NBROF	2

#endif
