/*
 * Copyright (C) 2022 SONY.
 *    Released under GPL v2.
 */

#ifdef ADJUST_PCIE_STATE_CHANGE

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/sysctl.h>

int r8125_d3hot_flg = 0;

static struct ctl_table r8125_table[] = {
    { .procname     = "r8125_d3hot_flg",
      .data         = &r8125_d3hot_flg,
      .maxlen       = sizeof(r8125_d3hot_flg),
      .mode         = 0644,
      .proc_handler = proc_dointvec },
    { }
};

static struct ctl_table r8125_dir_table[] = {
    { .procname    = "r8125",
      .mode        = 0555,
      .child    = r8125_table },
    { }
};

static struct ctl_table r8125_root_table[] = {
    { .procname    = "debug",
      .mode        = 0555,
      .child    = r8125_dir_table },
    { }
};

static struct ctl_table_header *r8125_table_header;

int r8125_init_sysctl(void)
{
    static int initialized = 0;

    printk(KERN_INFO "%s: start\n", __FUNCTION__);

    if(initialized == 1)
        return 0;

    r8125_table_header = register_sysctl_table(r8125_root_table);
    if (!r8125_table_header) {
        printk(KERN_INFO "%s: register_sysctl_table error\n", __FUNCTION__);
        return -ENOMEM;
    }

    initialized = 1;
    printk(KERN_INFO "%s: normal finish\n", __FUNCTION__);
    return 0;
}

void r8125_cleanup_sysctl(void)
{
    printk(KERN_INFO "%s: start\n", __FUNCTION__);
    unregister_sysctl_table(r8125_table_header);
    printk(KERN_INFO "%s: unregister_sysctl_table finish\n", __FUNCTION__);
    return;
}
#endif // ADJUST_PCIE_STATE_CHANGE
