/*
 * usbg_iap.h
 *
 * USB iAP Gadget
 *
 * Copyright 2024 Sony Group Corporation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#ifndef __UAPI_USBG_IAP_H__
#define __UAPI_USBG_IAP_H__

/* ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ */
/* iAP用イベントIDとパラメータ型				*/
/* ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ */
enum USBG_IAP_KEVENT {
    USBG_IAP_KEVENT_READ_COMP = 0,
    USBG_IAP_KEVENT_WRITE_COMP,
};

struct USBG_IAP_KEVENT_FUNC {
    void ( *read_comp  )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
    void ( *write_comp )(usb_hndl_t, usb_kevent_id_t, unsigned char, void* vp_arg);
};

struct usbg_iap_data {
    void *read_data;
    size_t buf_sz;
};

#define USBG_IOC_IAP_GET_DATA   _IOWR( USBG_IOC_IAP, 0, struct usbg_iap_data )

#endif	/* __UAPI_USBG_IAP_H__ */
