/*
 *  platform.h
 *
 *  Copyright 2018 Sony Corporation.
 *  Copyright 2019,2020 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __PCIEDMA_PLATFORM_H__
#define __PCIEDMA_PLATFORM_H__

#define PCIE_CTRL_N	0xf6400000UL
#define PCIE_CTRL_M0	0xf6800000UL
#define PCIE_CTRL_M1	0xf6c00000UL
#define PCIE_CTRL_I	0xf7000000UL
#define PCIE_CTRL_C	0xf7400000UL

#define PCIE_PHY_N	0xf1100000UL
#define PCIE_PHY_M0	0xf1140000UL
#define PCIE_PHY_M1	0xf1180000UL
#define PCIE_PHY_I	0xf11c0000UL
#define PCIE_PHY_C	0xf1200000UL

#define PCIE_IRQ_I	198
#define PCIE_IRQ_M0	200
#define PCIE_IRQ_M1	202
#define PCIE_IRQ_C	204
#define PCIE_IRQ_N	206

#define PCIE_NAME_I	"i"
#define PCIE_NAME_C	"c"
#define PCIE_NAME_N	"n"
#define PCIE_NAME_M0	"m0"
#define PCIE_NAME_M1	"m1"

#endif /* __PCIEDMA_PLATFORM_H__ */
